/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Sentities.BaseEntities;

import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Core.Sblocks;
import com.Harbinger.Spore.Core.Ssounds;
import com.Harbinger.Spore.ExtremelySusThings.SporeSavedData;
import com.Harbinger.Spore.ExtremelySusThings.Utilities;
import com.Harbinger.Spore.Sentities.AI.FloatDiveGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.BufferAI;
import com.Harbinger.Spore.Sentities.AI.LocHiv.LocalTargettingGoal;
import com.Harbinger.Spore.Sentities.AI.LocHiv.SearchAreaGoal;
import com.Harbinger.Spore.Sentities.BaseEntities.Infected;
import com.Harbinger.Spore.Sentities.BaseEntities.UtilityEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.WallClimberNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class Hyper
extends Infected {
    public static final EntityDataAccessor<BlockPos> NEST = SynchedEntityData.m_135353_(Infected.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);

    public Hyper(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        this.f_21344_ = new WallClimberNavigation((Mob)this, level);
    }

    @Override
    public boolean canStarve() {
        return false;
    }

    protected int m_5639_(float p_149389_, float p_149390_) {
        return super.m_5639_(p_149389_, p_149390_) - 5;
    }

    @Override
    protected void addRegularGoals() {
        this.f_21345_.m_25352_(3, (Goal)new LocalTargettingGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new GoBackToTheNest(this));
        this.f_21345_.m_25352_(4, (Goal)new SearchAreaGoal(this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new BufferAI(this));
        this.f_21345_.m_25352_(6, (Goal)new FloatDiveGoal((Mob)this));
    }

    @Override
    public boolean m_6785_(double value) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            SporeSavedData data = SporeSavedData.getDataLocation(serverLevel);
            return data != null && data.getAmountOfHiveminds() >= (Integer)SConfig.SERVER.proto_spawn_world_mod.get() && value > 256.0;
        }
        return false;
    }

    @Override
    public boolean blockBreakingParameter(BlockState blockstate, BlockPos blockpos) {
        float value = blockstate.m_60800_((BlockGetter)this.m_9236_(), blockpos);
        return this.f_19797_ % 20 == 0 && (value > 0.0f && value <= (float)this.getBreaking() || blockstate.m_204336_(Utilities.biomass));
    }

    protected boolean m_7341_(Entity entity) {
        if (entity instanceof Infected || entity instanceof UtilityEntity) {
            return super.m_7341_(entity);
        }
        return false;
    }

    protected SoundEvent m_7975_(DamageSource p_34327_) {
        return (SoundEvent)Ssounds.HYPER_DAMAGE.get();
    }

    @Override
    public boolean m_142582_(Entity entity) {
        LivingEntity livingEntity;
        if (entity instanceof LivingEntity && this.m_20280_((Entity)(livingEntity = (LivingEntity)entity)) < 100.0) {
            return true;
        }
        return super.m_142582_(entity);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_9236_().m_46791_() == Difficulty.HARD && (double)amount > this.getDamageCap() && ((Boolean)SConfig.SERVER.damagecap.get()).booleanValue()) {
            return super.m_6469_(source, (float)this.getDamageCap());
        }
        return super.m_6469_(source, amount);
    }

    public double getDamageCap() {
        return this.m_21233_() / 3.0f;
    }

    public int getBreaking() {
        return (Integer)SConfig.SERVER.hyper_bd.get();
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("nestX", ((BlockPos)this.f_19804_.m_135370_(NEST)).m_123341_());
        tag.m_128405_("nestY", ((BlockPos)this.f_19804_.m_135370_(NEST)).m_123342_());
        tag.m_128405_("nestZ", ((BlockPos)this.f_19804_.m_135370_(NEST)).m_123343_());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        int x = tag.m_128451_("nestX");
        int y = tag.m_128451_("nestY");
        int z = tag.m_128451_("nestZ");
        this.f_19804_.m_135381_(NEST, (Object)new BlockPos(x, y, z));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(NEST, (Object)BlockPos.f_121853_);
    }

    public BlockPos getNestLocation() {
        return (BlockPos)this.f_19804_.m_135370_(NEST);
    }

    public void setNestLocation(BlockPos pos) {
        this.f_19804_.m_135381_(NEST, (Object)pos);
    }

    @Override
    public boolean additionalBreakingTriggers() {
        return this.m_21225_() == this.m_269291_().m_269318_();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_21434_, DifficultyInstance p_21435_, MobSpawnType p_21436_, @Nullable SpawnGroupData p_21437_, @Nullable CompoundTag p_21438_) {
        this.setNestLocation(this.m_20097_());
        return super.m_6518_(p_21434_, p_21435_, p_21436_, p_21437_, p_21438_);
    }

    static class GoBackToTheNest
    extends Goal {
        protected Hyper hyper;
        public int tryTicks;

        public GoBackToTheNest(Hyper hyper) {
            this.hyper = hyper;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            return this.hyper.m_5448_() == null;
        }

        public boolean m_8036_() {
            return this.hyper.getEvoPoints() > 1 && this.hyper.getNestLocation() != BlockPos.f_121853_;
        }

        protected void moveMobToBlock(BlockPos pos) {
            double x = (double)this.hyper.f_19796_.m_216339_(-2, 2) + 0.5;
            double z = (double)this.hyper.f_19796_.m_216339_(-2, 2) + 0.5;
            this.hyper.m_21573_().m_26519_((double)pos.m_123341_() + x, (double)(pos.m_123342_() + 1), (double)pos.m_123343_() + z, 1.0);
        }

        protected void tryToLayCorpsesAround() {
            AABB aabb = this.hyper.m_20191_().m_82400_(10.0);
            for (BlockPos blockpos : BlockPos.m_121976_((int)Mth.m_14107_((double)aabb.f_82288_), (int)Mth.m_14107_((double)aabb.f_82289_), (int)Mth.m_14107_((double)aabb.f_82290_), (int)Mth.m_14107_((double)aabb.f_82291_), (int)Mth.m_14107_((double)aabb.f_82292_), (int)Mth.m_14107_((double)aabb.f_82293_))) {
                Level level = this.hyper.m_9236_();
                boolean isGround = level.m_8055_(blockpos).m_60838_((BlockGetter)level, blockpos);
                boolean isAir = level.m_8055_(blockpos.m_7494_()).m_60795_();
                if (!(Math.random() < 0.01) || !isGround || !isAir || level.f_46443_) continue;
                level.m_7731_(blockpos.m_7494_(), ((Block)Sblocks.REMAINS.get()).m_49966_(), 3);
                this.hyper.setEvoPoints(this.hyper.getEvoPoints() - 1);
                break;
            }
        }

        public boolean shouldRecalculatePath() {
            return this.tryTicks % 80 == 0;
        }

        public void m_8037_() {
            super.m_8037_();
            ++this.tryTicks;
            if (this.hyper.getNestLocation() != BlockPos.f_121853_ && this.shouldRecalculatePath()) {
                this.moveMobToBlock(this.hyper.getNestLocation());
            }
        }

        public void m_8056_() {
            this.moveMobToBlock(this.hyper.getNestLocation());
            BlockPos pos = this.hyper.getNestLocation();
            if (this.hyper.m_20275_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) < 80.0) {
                this.tryToLayCorpsesAround();
            }
            super.m_8056_();
        }

        public boolean m_183429_() {
            return true;
        }
    }
}

