/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.SBlockEntities;

import com.Harbinger.Spore.Core.SblockEntities;
import com.Harbinger.Spore.SBlockEntities.AnimatedEntity;
import com.Harbinger.Spore.Screens.IncubatorMenu;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeArmorData;
import com.Harbinger.Spore.Sitems.BaseWeapons.SporeWeaponData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class IncubatorBlockEntity
extends BlockEntity
implements AnimatedEntity,
WorldlyContainer,
MenuProvider {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{0};
    private NonNullList<ItemStack> stacks = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    public int fuel;
    private int tick;
    private int side;

    public IncubatorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SblockEntities.INCUBATOR.get(), pos, state);
        this.side = this.setSide(state);
    }

    private int setSide(BlockState state) {
        Property property = state.m_60734_().m_49965_().m_61081_("facing");
        if (property instanceof DirectionProperty) {
            DirectionProperty directionProperty = (DirectionProperty)property;
            return ((Direction)state.m_61143_((Property)directionProperty)).m_122411_();
        }
        return 2;
    }

    public void setSide(int i) {
        this.side = i;
    }

    public int getSide() {
        return this.side;
    }

    public NonNullList<ItemStack> getStacks() {
        return this.stacks;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("fuel", this.getFuel());
        tag.m_128405_("side", this.getSide());
        ContainerHelper.m_18973_((CompoundTag)tag, this.stacks);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.fuel = tag.m_128451_("fuel");
        this.side = tag.m_128451_("side");
        this.stacks = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.stacks);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        this.m_6596_();
        return this.m_187480_();
    }

    public void setFuel(int i) {
        this.fuel = i;
    }

    public int getFuel() {
        return this.fuel;
    }

    public void addTick() {
        this.tick = this.tick < 720 ? ++this.tick : 0;
    }

    public void HealItemStack() {
        for (ItemStack stack : this.stacks) {
            if (stack == ItemStack.f_41583_ || this.getFuel() <= 0 || !stack.m_41768_()) continue;
            Item item = stack.m_41720_();
            if (item instanceof SporeWeaponData) {
                SporeWeaponData data = (SporeWeaponData)item;
                data.healTool(stack, 1);
            } else {
                item = stack.m_41720_();
                if (item instanceof SporeArmorData) {
                    SporeArmorData data = (SporeArmorData)item;
                    data.healTool(stack, 1);
                } else {
                    int l = stack.m_41773_() - 1;
                    stack.m_41721_(l);
                }
            }
            this.setFuel(this.getFuel() - 1);
        }
    }

    public static <E extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, IncubatorBlockEntity e) {
        e.HealItemStack();
    }

    public static <E extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, IncubatorBlockEntity e) {
        e.addTick();
    }

    public boolean isActive() {
        return this.getFuel() > 0 && this.stacks.get(0) != ItemStack.f_41583_;
    }

    @Override
    public int getTicks() {
        return this.tick;
    }

    public int[] m_7071_(Direction direction) {
        return direction == Direction.UP ? slotsTop : slotsBottom;
    }

    public boolean m_7155_(int p_19235_, ItemStack item, @Nullable Direction direction) {
        if ((direction == Direction.NORTH || direction == Direction.SOUTH || direction == Direction.EAST || direction == Direction.WEST) && this.getFuel() <= 750) {
            this.setFuel(this.getFuel() + 250);
            item.m_41774_(1);
        }
        return direction == Direction.UP && item.m_204117_(ItemTags.create((ResourceLocation)new ResourceLocation("spore:weapons")));
    }

    public boolean m_7157_(int p_19239_, ItemStack stack, Direction direction) {
        return direction == Direction.DOWN && !stack.m_41768_();
    }

    public int m_6643_() {
        return this.stacks.size();
    }

    public boolean m_7983_() {
        for (int i = 0; i < this.m_6643_(); ++i) {
            if (this.m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack m_7407_(int index, int count) {
        if (!((ItemStack)this.stacks.get(index)).m_41619_()) {
            ItemStack itemstack;
            if (((ItemStack)this.stacks.get(index)).m_41613_() <= count) {
                itemstack = (ItemStack)this.stacks.get(index);
                this.stacks.set(index, (Object)ItemStack.f_41583_);
            } else {
                itemstack = ((ItemStack)this.stacks.get(index)).m_41620_(count);
                if (((ItemStack)this.stacks.get(index)).m_41619_()) {
                    this.stacks.set(index, (Object)ItemStack.f_41583_);
                }
            }
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack m_8016_(int index) {
        ItemStack stack = (ItemStack)this.stacks.get(index);
        this.stacks.set(index, (Object)ItemStack.f_41583_);
        return stack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_183515_(this.m_5995_());
    }

    public boolean m_6542_(Player p_18946_) {
        return true;
    }

    public void m_6211_() {
        this.stacks.clear();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        if (packet != null && packet.m_131708_() != null) {
            this.m_142466_(packet.m_131708_());
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.spore.incubator");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new IncubatorMenu(i, inventory);
    }
}

