/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Compat;

import com.Harbinger.Spore.Core.Sitems;
import com.Harbinger.Spore.Recipes.InjectionRecipe;
import com.Harbinger.Spore.Sentities.VariantKeeper;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class InjectionCraftingCategory
implements IRecipeCategory<InjectionRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("spore", "injection");
    public static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/gui/injection_gui.png");
    public static final RecipeType<InjectionRecipe> INJECTION_TYPE = new RecipeType(UID, InjectionRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public InjectionCraftingCategory(IGuiHelper helper) {
        this.background = helper.drawableBuilder(TEXTURE, 0, 0, 176, 82).setTextureSize(176, 166).build();
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)Sitems.SYRINGE.get()));
    }

    public RecipeType<InjectionRecipe> getRecipeType() {
        return INJECTION_TYPE;
    }

    public Component getTitle() {
        return Component.m_237115_((String)"item.spore.syringe");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder iRecipeLayoutBuilder, InjectionRecipe injectionRecipe, IFocusGroup iFocusGroup) {
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.INPUT, 97, 17).addIngredients(Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)Sitems.SYRINGE.get()}));
        iRecipeLayoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 97, 53).addIngredients(Ingredient.m_43927_((ItemStack[])new ItemStack[]{injectionRecipe.m_8043_(null)}));
    }

    public void draw(InjectionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        ResourceLocation location;
        Entity entity;
        super.draw((Object)recipe, recipeSlotsView, guiGraphics, mouseX, mouseY);
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null && (entity = ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(location = new ResourceLocation(recipe.getEntityId()))).m_20615_((Level)level)) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (living instanceof VariantKeeper) {
                VariantKeeper keeper = (VariantKeeper)living;
                keeper.setVariant(recipe.getEntityType());
                this.renderEntityInInventoryFollowsAngle(guiGraphics, 34, 70, 20, 0.0f, 0.0f, living);
            } else {
                this.renderEntityInInventoryFollowsAngle(guiGraphics, 34, 70, 20, 0.0f, 0.0f, living);
            }
        }
    }

    private void renderEntityInInventoryFollowsAngle(GuiGraphics guiGraphics, int x, int y, int scale, float angleXComponent, float angleYComponent, LivingEntity entity) {
        Quaternionf pose = new Quaternionf().rotateZ((float)Math.PI);
        Quaternionf cameraOrientation = new Quaternionf().rotateX(angleYComponent * 20.0f * ((float)Math.PI / 180));
        pose.mul((Quaternionfc)cameraOrientation);
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 180.0f + angleXComponent * 20.0f;
        entity.m_146922_(180.0f + angleXComponent * 40.0f);
        entity.m_146926_(-angleYComponent * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        InventoryScreen.m_280432_((GuiGraphics)guiGraphics, (int)x, (int)y, (int)scale, (Quaternionf)pose, (Quaternionf)cameraOrientation, (LivingEntity)entity);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
    }
}

