/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.VolatileModel;
import com.Harbinger.Spore.Client.Special.BaseInfectedRenderer;
import com.Harbinger.Spore.Sentities.EvolvedInfected.Volatile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VolatileRenderer<Type extends Volatile>
extends BaseInfectedRenderer<Type, VolatileModel<Type>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/volatile.png");
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/volatile.png");

    public VolatileRenderer(EntityRendererProvider.Context context) {
        super(context, new VolatileModel(context.m_174023_(VolatileModel.LAYER_LOCATION)), 0.5f);
        this.m_115326_(new VolatileGlowingLayers(this));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    static class VolatileGlowingLayers<T extends Volatile, M extends VolatileModel<T>>
    extends RenderLayer<T, M> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/volatile_pulsation.png");

        public VolatileGlowingLayers(RenderLayerParent<T, M> p_117346_) {
            super(p_117346_);
        }

        public void render(PoseStack matrixStack, MultiBufferSource buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!entity.m_20145_()) {
                float alpha = 0.5f + 0.5f * Mth.m_14031_((float)(ageInTicks * 0.1f));
                VertexConsumer vertexConsumer = buffer.m_6299_(SporeRenderTypes.glowingTranslucent(TEXTURE));
                ((VolatileModel)this.m_117386_()).m_7695_(matrixStack, vertexConsumer, packedLight, 0xF00000, 1.0f, 1.0f, 1.0f, alpha);
            }
        }
    }
}

