/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Models.SickleModel;
import com.Harbinger.Spore.Sentities.Projectile.ThrownSickle;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class SickleRenderer
extends EntityRenderer<ThrownSickle> {
    private static final ResourceLocation SICKLE_TEXTURE = new ResourceLocation("spore", "textures/entity/infected_sickle.png");
    private static final ResourceLocation SPINE_TEXTURE = new ResourceLocation("spore", "textures/entity/spine.png");
    private final SickleModel<ThrownSickle> model;

    public SickleRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new SickleModel(context.m_174023_(SickleModel.LAYER_LOCATION));
    }

    public void render(ThrownSickle sickle, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        int color = sickle.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, -1.0f, 0.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14179_((float)partialTicks, (float)sickle.f_19859_, (float)sickle.m_146908_())));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(Mth.m_14179_((float)partialTicks, (float)sickle.f_19860_, (float)sickle.m_146909_())));
        poseStack.m_85841_(1.8f, 1.8f, 1.8f);
        VertexConsumer sickleConsumer = ItemRenderer.m_115222_((MultiBufferSource)bufferSource, (RenderType)this.model.m_103119_(this.getTextureLocation(sickle)), (boolean)false, (boolean)sickle.isFoil());
        this.model.m_7695_(poseStack, sickleConsumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
        poseStack.m_85849_();
        Entity owner = sickle.m_19749_();
        if (owner != null) {
            this.renderConnection(sickle, owner, poseStack, bufferSource, partialTicks, r, g, b);
        }
        super.m_7392_((Entity)sickle, entityYaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(ThrownSickle sickle) {
        return SICKLE_TEXTURE;
    }

    private void renderConnection(ThrownSickle parent, Entity to, PoseStack stack, MultiBufferSource buffer, float partialTick, float r, float g, float b) {
        Vec3 start = parent.m_20318_(partialTick).m_82549_(parent.m_20184_().m_82541_().m_82490_(-0.3));
        Vec3 vec3 = new Vec3(0.2, 1.35, 0.6).m_82524_(-to.m_146908_() * ((float)Math.PI / 180) - 1.5707964f);
        Vec3 end = to.m_20318_(partialTick).m_82520_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        Vec3 direction = end.m_82546_(start);
        float length = (float)direction.m_82553_();
        length = Math.max(length, 1.5f);
        direction = direction.m_82541_();
        float yaw = (float)Math.atan2(direction.f_82479_, direction.f_82481_);
        float pitch = (float)(-Math.asin(direction.f_82480_));
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252961_(yaw));
        stack.m_252781_(Axis.f_252529_.m_252961_(pitch));
        float startWidth = 0.5f;
        float startHeight = 0.5f;
        float endWidth = 0.5f;
        float endHeight = 0.5f;
        VertexConsumer vertexConsumer = ItemRenderer.m_115222_((MultiBufferSource)buffer, (RenderType)RenderType.m_110473_((ResourceLocation)SPINE_TEXTURE), (boolean)false, (boolean)parent.isFoil());
        PoseStack.Pose pose = stack.m_85850_();
        Matrix4f matrix = pose.m_252922_();
        this.drawTaperedConnection(vertexConsumer, matrix, pose.m_252943_(), startWidth, startHeight, endWidth, endHeight, length, OverlayTexture.f_118083_, 0xF000F0, r, g, b, 1.0f);
        stack.m_85849_();
    }

    private void drawTaperedConnection(VertexConsumer vertexConsumer, Matrix4f matrix, Matrix3f normal, float startWidth, float startHeight, float endWidth, float endHeight, float length, int overlay, int lightmap, float red, float green, float blue, float alpha) {
        float hwStart = startWidth / 2.0f;
        float hhStart = startHeight / 2.0f;
        float hwEnd = endWidth / 2.0f;
        float hhEnd = endHeight / 2.0f;
        vertexConsumer.m_252986_(matrix, -hwStart, -hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwStart, hhStart, 0.0f).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 0.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwEnd, hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(1.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
        vertexConsumer.m_252986_(matrix, -hwEnd, -hhEnd, length).m_85950_(red, green, blue, alpha).m_7421_(0.0f, 1.0f).m_86008_(overlay).m_85969_(lightmap).m_252939_(normal, -1.0f, 0.0f, 0.0f).m_5752_();
    }
}

