/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.GrakenMembraneLayer;
import com.Harbinger.Spore.Client.Layers.WaterCalamityCamo;
import com.Harbinger.Spore.Client.Models.GrakensenkerModel;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.FootSeg;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.HandSeg1;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.HandSeg2;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg1;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg10;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg11;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg12;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg2;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg3;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg4;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg5;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg6;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg7;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg8;
import com.Harbinger.Spore.Client.Models.KrakenTentacles.Seg9;
import com.Harbinger.Spore.Client.Special.CalamityRenderer;
import com.Harbinger.Spore.Client.SpecialEffects;
import com.Harbinger.Spore.Sentities.BaseEntities.Calamity;
import com.Harbinger.Spore.Sentities.Calamities.Grakensenker;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class KrakenRenderer<Type extends Grakensenker>
extends CalamityRenderer<Type, EntityModel<Type>> {
    private final Seg1<Type> tentacleSegmentModel1 = new Seg1();
    private final Seg2<Type> tentacleSegmentModel2 = new Seg2();
    private final Seg3<Type> tentacleSegmentModel3 = new Seg3();
    private final Seg4<Type> tentacleSegmentModel4 = new Seg4();
    private final Seg5<Type> tentacleSegmentModel5 = new Seg5();
    private final Seg6<Type> tentacleSegmentModel6 = new Seg6();
    private final Seg7<Type> tentacleSegmentModel7 = new Seg7();
    private final Seg8<Type> tentacleSegmentModel8 = new Seg8();
    private final Seg9<Type> tentacleSegmentModel9 = new Seg9();
    private final Seg10<Type> tentacleSegmentModel10 = new Seg10();
    private final Seg11<Type> tentacleSegmentModel11 = new Seg11();
    private final Seg12<Type> tentacleSegmentModel12 = new Seg12();
    private final FootSeg<Type> foot = new FootSeg();
    private final HandSeg1<Type> armModel1 = new HandSeg1();
    private final HandSeg2<Type> armModel2 = new HandSeg2();
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/graken.png");
    private static final ResourceLocation TENTACLES = new ResourceLocation("spore", "textures/entity/kraken/kraken_t1.png");
    private static final ResourceLocation KRAKEN_HAND = new ResourceLocation("spore", "textures/entity/kraken/hand.png");
    private static final ResourceLocation EYES_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/graken.png");
    private static final ResourceLocation WATER = new ResourceLocation("spore", "textures/entity/vortex/water_vortex.png");
    private static final ResourceLocation WATER_RIPTIDE = new ResourceLocation("spore", "textures/entity/vortex/vortex_riptide.png");

    public KrakenRenderer(EntityRendererProvider.Context context) {
        super(context, new GrakensenkerModel(), 4.0f);
        this.m_115326_(new GrakenMembraneLayer(this));
        this.m_115326_(new WaterCalamityCamo(this));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return TEXTURE;
    }

    public EntityModel<Type> getTentacleModel(int i) {
        return switch (i) {
            case 0 -> this.tentacleSegmentModel1;
            case 1 -> this.tentacleSegmentModel2;
            case 2 -> this.tentacleSegmentModel3;
            case 3 -> this.tentacleSegmentModel4;
            case 4 -> this.tentacleSegmentModel5;
            case 5 -> this.tentacleSegmentModel6;
            case 6 -> this.tentacleSegmentModel7;
            case 7 -> this.tentacleSegmentModel8;
            case 8 -> this.tentacleSegmentModel9;
            case 9 -> this.tentacleSegmentModel10;
            case 10 -> this.tentacleSegmentModel11;
            default -> this.tentacleSegmentModel12;
        };
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYES_TEXTURE;
    }

    public void render(Type entity, float entityYaw, float partialTicks, PoseStack stack, MultiBufferSource bufferSource, int light) {
        int color = ((Biome)entity.m_9236_().m_204166_(entity.m_20097_()).m_203334_()).m_47560_();
        int packedColor = color | 0xFF000000;
        Entity camera = Minecraft.m_91087_().m_91288_();
        float time = ((float)((Grakensenker)entity).f_19797_ + partialTicks) * -0.25f;
        float time2 = ((float)((Grakensenker)entity).f_19797_ + partialTicks) * -0.35f;
        stack.m_85836_();
        stack.m_252880_(0.0f, ((Grakensenker)entity).getExtendedHeight(), 0.0f);
        stack.m_252781_(Axis.f_252436_.m_252977_((float)((Grakensenker)entity).getWaterTicks()));
        super.m_7392_(entity, entityYaw, partialTicks, stack, bufferSource, light);
        stack.m_85849_();
        Vec3 entityPos = entity.m_20318_(partialTicks);
        stack.m_85836_();
        stack.m_85837_(-entityPos.f_82479_, -entityPos.f_82480_, -entityPos.f_82481_);
        if (!entity.m_20145_()) {
            this.renderTentacle(stack, entity, light, bufferSource, ((Grakensenker)entity).getBackRightTentacle().getEntities(), ((Grakensenker)entity).getBackRightTentacle().getSegmentVar(), (LivingEntity)entity, partialTicks, false, false);
            this.renderTentacle(stack, entity, light, bufferSource, ((Grakensenker)entity).getBackLeftTentacle().getEntities(), ((Grakensenker)entity).getBackLeftTentacle().getSegmentVar(), (LivingEntity)entity, partialTicks, false, false);
            this.renderTentacle(stack, entity, light, bufferSource, ((Grakensenker)entity).getMiddleLeftTentacle().getEntities(), ((Grakensenker)entity).getMiddleLeftTentacle().getSegmentVar(), (LivingEntity)entity, partialTicks, false, false);
            this.renderTentacle(stack, entity, light, bufferSource, ((Grakensenker)entity).getMiddleRightTentacle().getEntities(), ((Grakensenker)entity).getMiddleRightTentacle().getSegmentVar(), (LivingEntity)entity, partialTicks, false, false);
            this.renderTentacle(stack, entity, light, bufferSource, ((Grakensenker)entity).getFrontLeftTentacle().getEntities(), ((Grakensenker)entity).getFrontLeftTentacle().getSegmentVar(), (LivingEntity)entity, partialTicks, false, false);
            this.renderTentacle(stack, entity, light, bufferSource, ((Grakensenker)entity).getFrontRightTentacle().getEntities(), ((Grakensenker)entity).getFrontRightTentacle().getSegmentVar(), (LivingEntity)entity, partialTicks, false, false);
            this.renderTentacle(stack, entity, light, bufferSource, ((Grakensenker)entity).getRightArmTentacle().getEntities(), ((Grakensenker)entity).getRightArmTentacle().getSegmentVar(), (LivingEntity)entity, partialTicks, true, false);
            this.renderTentacle(stack, entity, light, bufferSource, ((Grakensenker)entity).getLeftArmTentacle().getEntities(), ((Grakensenker)entity).getLeftArmTentacle().getSegmentVar(), (LivingEntity)entity, partialTicks, true, true);
        }
        if (((Grakensenker)entity).hasVortex() && ((Grakensenker)entity).getVortexTimeOut() <= 0 && camera != null && camera.isEyeInFluidType(Fluids.f_76193_.getFluidType())) {
            PoseStack.Pose pose = stack.m_85850_();
            Matrix4f matrix4f = pose.m_252922_();
            Matrix3f matrix3f = pose.m_252943_();
            SpecialEffects.renderFunnel(matrix4f, matrix3f, light, bufferSource, ((Grakensenker)entity).getVortexFunnel().getEntities(), time, packedColor, 1.0f, WATER);
            SpecialEffects.renderFunnel(matrix4f, matrix3f, light, bufferSource, ((Grakensenker)entity).getVortexFunnel().getEntities(), time, -1, 1.1f, WATER_RIPTIDE);
            SpecialEffects.renderFunnel(matrix4f, matrix3f, light, bufferSource, ((Grakensenker)entity).getVortexFunnel().getEntities(), time2, packedColor, 0.9f, WATER);
        }
        stack.m_85849_();
    }

    private void renderTentacle(PoseStack stack, Type type, int light, MultiBufferSource buffer, Vec3[] segments, int[] var, LivingEntity parent, float partial, boolean arm, boolean right) {
        if (segments == null || segments.length < 2) {
            return;
        }
        float hurtTime = (float)parent.f_20916_ - partial;
        float flashIntensity = 0.0f;
        int mutationColor = ((Calamity)type).getMutationColor() == 0 ? -1 : ((Calamity)type).getMutationColor();
        Vec3 origin = null;
        if (hurtTime > 0.0f) {
            flashIntensity = Math.min(hurtTime / 10.0f, 1.0f);
        }
        float baseR = (float)(mutationColor >> 16 & 0xFF) / 255.0f;
        float baseG = (float)(mutationColor >> 8 & 0xFF) / 255.0f;
        float baseB = (float)(mutationColor & 0xFF) / 255.0f;
        float flash = flashIntensity * 0.5f;
        float g = Mth.m_14179_((float)flash, (float)baseG, (float)0.2f);
        float b = Mth.m_14179_((float)flash, (float)baseB, (float)0.2f);
        for (int i = 0; i < segments.length; ++i) {
            Vec3 currentPos = segments[i];
            this.renderConnection(origin, currentPos, type, light, stack, buffer, i, var[i], partial, baseR, g, b, i == segments.length - 1, arm, right);
            origin = currentPos;
        }
    }

    private void renderConnection(Vec3 from, Vec3 to, Type parent, int light, PoseStack stack, MultiBufferSource buffer, int index, int var, float partial, float r, float g, float b, boolean last, boolean arm, boolean right) {
        if (from == null || to == null) {
            return;
        }
        Vec3 direction = to.m_82546_(from);
        float length = (float)direction.m_82553_();
        if (length < 1.0E-4f) {
            return;
        }
        direction = direction.m_82541_();
        float yaw = (float)Math.atan2(direction.f_82479_, direction.f_82481_);
        float pitch = (float)(-Math.asin(direction.f_82480_));
        float size = index % 2 == 0 ? 1.2f : 1.0f;
        stack.m_85836_();
        stack.m_85837_(from.f_82479_, from.f_82480_, from.f_82481_);
        stack.m_252781_(Axis.f_252436_.m_252961_(yaw));
        stack.m_252781_(Axis.f_252529_.m_252961_(pitch));
        stack.m_85836_();
        VertexConsumer consumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)(arm ? KRAKEN_HAND : TENTACLES)));
        EntityModel typeEntityModel = last ? (arm ? (right ? this.armModel1 : this.armModel2) : this.foot) : this.getTentacleModel(var);
        stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        stack.m_252880_(0.0f, -length / 2.0f, 0.0f);
        stack.m_85841_(size, length * 1.05f, size);
        typeEntityModel.m_6973_(parent, 0.0f, 0.0f, (float)((Grakensenker)parent).f_19797_ + partial, 0.0f, 0.0f);
        typeEntityModel.m_7695_(stack, consumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
        stack.m_85849_();
        stack.m_85849_();
    }
}

