/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Renderers;

import com.Harbinger.Spore.Client.Layers.HowitzerEmissiveLayer;
import com.Harbinger.Spore.Client.Layers.HowitzerLightsLayer;
import com.Harbinger.Spore.Client.Layers.SporeRenderTypes;
import com.Harbinger.Spore.Client.Models.HowitzerModel;
import com.Harbinger.Spore.Client.Special.CalamityRenderer;
import com.Harbinger.Spore.Sentities.Calamities.Howitzer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HowitzerRenderer<Type extends Howitzer>
extends CalamityRenderer<Type, HowitzerModel<Type>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("spore", "textures/entity/howitzer.png");
    private static final ResourceLocation RADIATION = new ResourceLocation("spore", "textures/entity/nuclear_howitzer.png");
    private static final ResourceLocation EYE_TEXTURE = new ResourceLocation("spore", "textures/entity/eyes/howitzer_eyes.png");

    public HowitzerRenderer(EntityRendererProvider.Context context) {
        super(context, new HowitzerModel(), 4.0f);
        this.m_115326_(new HowitzerNeonGreenLayer(this));
        this.m_115326_(new HowitzerEmissiveLayer(this));
        this.m_115326_(new HowitzerLightsLayer(this));
    }

    public ResourceLocation getTextureLocation(Type entity) {
        return ((Howitzer)entity).isRadioactive() ? RADIATION : TEXTURE;
    }

    @Override
    public ResourceLocation eyeLayerTexture() {
        return EYE_TEXTURE;
    }

    static class HowitzerNeonGreenLayer<T extends Howitzer, M extends HowitzerModel<T>>
    extends RenderLayer<T, M> {
        public HowitzerNeonGreenLayer(RenderLayerParent<T, M> p_117346_) {
            super(p_117346_);
        }

        public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, T t, float v, float v1, float v2, float ageInTicks, float v4, float v5) {
            int ticksBoom = ((Howitzer)t).getSelfDetonation();
            if (!t.m_20145_() && ((Howitzer)t).isRadioactive() && ticksBoom > 0) {
                float omega = 0.5f + 0.5f * Mth.m_14031_((float)(ageInTicks * 0.1f));
                float alpha = 0.2f + omega / (float)(30 - ticksBoom);
                VertexConsumer vertexConsumer = multiBufferSource.m_6299_(SporeRenderTypes.glowingTranslucent(RADIATION));
                ((HowitzerModel)this.m_117386_()).m_7695_(poseStack, vertexConsumer, i, 0xF00000, 0.0f, 1.0f, 0.0f, alpha);
            }
        }
    }
}

