/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Models;

import com.Harbinger.Spore.Client.Special.BlockEntityModel;
import com.Harbinger.Spore.SBlockEntities.OutpostWatcherBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class OutpostWatcherModel<T extends OutpostWatcherBlockEntity>
extends BlockEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("spore", "outpost_watcher"), "main");
    private final List<ModelPart> segements = new ArrayList<ModelPart>();
    private final ModelPart OutpostCore;
    private final ModelPart Biomass;
    private final ModelPart Brain1;
    private final ModelPart Brain2;
    private final ModelPart Brain3;
    private final ModelPart Brain4;
    private final ModelPart Neck1;
    private final ModelPart Neck2;
    private final ModelPart Neck3;
    private final ModelPart Neck4;
    private final ModelPart Neck5;
    private final ModelPart Pupil;
    private final ModelPart Rib1;
    private final ModelPart Rib2;
    private final ModelPart Rib3;
    private final ModelPart Rib4;

    public OutpostWatcherModel() {
        ModelPart root = OutpostWatcherModel.createBodyLayer().m_171564_();
        this.OutpostCore = root.m_171324_("OutpostCore");
        this.Biomass = this.OutpostCore.m_171324_("Base").m_171324_("Biomass");
        this.Brain1 = this.OutpostCore.m_171324_("Base").m_171324_("Brains").m_171324_("Brain1");
        this.Brain2 = this.OutpostCore.m_171324_("Base").m_171324_("Brains").m_171324_("Brain2");
        this.Brain3 = this.OutpostCore.m_171324_("Base").m_171324_("Brains").m_171324_("Brain3");
        this.Brain4 = this.OutpostCore.m_171324_("Base").m_171324_("Brains").m_171324_("Brain4");
        this.Neck1 = this.OutpostCore.m_171324_("Stalk").m_171324_("Spine");
        this.Neck2 = this.Neck1.m_171324_("SpineSeg2");
        this.Neck3 = this.Neck2.m_171324_("SpineSeg3");
        this.Neck4 = this.Neck3.m_171324_("SpineSeg4");
        this.Neck5 = this.Neck4.m_171324_("SpineSeg5");
        this.Pupil = this.Neck5.m_171324_("Eye").m_171324_("Pupil");
        this.segements.add(this.Neck1);
        this.segements.add(this.Neck2);
        this.segements.add(this.Neck5);
        this.Rib1 = this.OutpostCore.m_171324_("Base").m_171324_("Ribs").m_171324_("Rib1");
        this.Rib2 = this.OutpostCore.m_171324_("Base").m_171324_("Ribs").m_171324_("Rib2");
        this.Rib3 = this.OutpostCore.m_171324_("Base").m_171324_("Ribs").m_171324_("Rib3");
        this.Rib4 = this.OutpostCore.m_171324_("Base").m_171324_("Ribs").m_171324_("Rib4");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition OutpostCore = partdefinition.m_171599_("OutpostCore", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-1.0f, (float)22.0f, (float)0.0f));
        PartDefinition Base = OutpostCore.m_171599_("Base", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Biomass2 = Base.m_171599_("Biomass", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)-0.4597f, (float)-1.0134f, (float)-0.332f));
        PartDefinition Biomass4_r1 = Biomass2.m_171599_("Biomass4_r1", CubeListBuilder.m_171558_().m_171514_(4, 4).m_171488_(-3.5f, -1.5f, -1.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.323f, (float)-2.1995f, (float)1.2635f, (float)-0.1987f, (float)0.4755f, (float)-0.1473f));
        PartDefinition Biomass3_r1 = Biomass2.m_171599_("Biomass3_r1", CubeListBuilder.m_171558_().m_171514_(2, 2).m_171488_(-4.5f, -2.5f, -2.5f, 7.0f, 7.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.5599f, (float)-1.0913f, (float)-2.9138f, (float)0.3699f, (float)-0.7124f, (float)-0.2154f));
        PartDefinition Biomass2_r1 = Biomass2.m_171599_("Biomass2_r1", CubeListBuilder.m_171558_().m_171514_(3, 3).m_171488_(-4.0f, -2.0f, -2.0f, 6.0f, 6.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-1.7154f, (float)-0.1518f, (float)-3.6794f, (float)0.0f, (float)-0.5236f, (float)-0.3491f));
        PartDefinition Biomass1_r1 = Biomass2.m_171599_("Biomass1_r1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.5f, -3.5f, -3.5f, 9.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.814f, (float)-1.2803f, (float)2.359f, (float)-0.1801f, (float)0.3913f, (float)-0.0164f));
        PartDefinition Brains = Base.m_171599_("Brains", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Brain1 = Brains.m_171599_("Brain1", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-2.6667f, -5.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 60).m_171488_(0.8333f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)).m_171514_(0, 60).m_171488_(-3.6667f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.m_171423_((float)-3.1973f, (float)-1.8588f, (float)-3.564f, (float)0.3054f, (float)0.7854f, (float)0.0f));
        PartDefinition Brain2 = Brains.m_171599_("Brain2", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-2.6667f, -5.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 60).m_171488_(0.8333f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)).m_171514_(0, 60).m_171488_(-3.6667f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.m_171423_((float)3.6996f, (float)-1.0907f, (float)-2.6466f, (float)0.549f, (float)-0.3252f, (float)0.4096f));
        PartDefinition Brain3 = Brains.m_171599_("Brain3", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-2.6667f, -5.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 60).m_171488_(0.8333f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)).m_171514_(0, 60).m_171488_(-3.6667f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.m_171423_((float)3.8157f, (float)-2.9002f, (float)3.9551f, (float)-0.549f, (float)0.3252f, (float)0.4096f));
        PartDefinition Brain4 = Brains.m_171599_("Brain4", CubeListBuilder.m_171558_().m_171514_(0, 34).m_171488_(-2.6667f, -5.0f, -4.0f, 6.0f, 5.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 60).m_171488_(0.8333f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)).m_171514_(0, 60).m_171488_(-3.6667f, -5.0f, -4.0f, 3.0f, 5.0f, 8.0f, new CubeDeformation(0.2f)), PartPose.m_171423_((float)-2.7248f, (float)-3.202f, (float)1.1037f, (float)-0.9961f, (float)-0.6061f, (float)0.0913f));
        PartDefinition Ribs = Base.m_171599_("Ribs", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Rib1 = Ribs.m_171599_("Rib1", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -6.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.2113f, (float)-3.6046f, (float)7.1676f, (float)-0.5633f, (float)-0.0702f, (float)-0.1106f));
        PartDefinition Rib1Seg = Rib1.m_171599_("Rib1Seg", CubeListBuilder.m_171558_().m_171514_(0, 73).m_171488_(-1.0013f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.5f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Rib2 = Ribs.m_171599_("Rib2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -6.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-5.1144f, (float)-2.2051f, (float)-1.07f, (float)-0.48f, (float)-1.1345f, (float)0.0f));
        PartDefinition Rib2Seg = Rib2.m_171599_("Rib2Seg", CubeListBuilder.m_171558_().m_171514_(0, 73).m_171488_(-1.0013f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.5f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Rib3 = Ribs.m_171599_("Rib3", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -6.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.2113f, (float)-4.6886f, (float)-3.4758f, (float)0.5899f, (float)-0.3135f, (float)0.0025f));
        PartDefinition Rib3Seg = Rib3.m_171599_("Rib3Seg", CubeListBuilder.m_171558_().m_171514_(0, 73).m_171488_(-1.0013f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.5f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Rib4 = Ribs.m_171599_("Rib4", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -6.5f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0942f, (float)-1.4646f, (float)-0.2558f, (float)-0.6545f, (float)1.3963f, (float)0.0f));
        PartDefinition Rib4Seg = Rib4.m_171599_("Rib4Seg", CubeListBuilder.m_171558_().m_171514_(0, 73).m_171488_(-1.0013f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-6.5f, (float)0.0f, (float)0.4363f, (float)0.0f, (float)0.0f));
        PartDefinition Stalk = OutpostCore.m_171599_("Stalk", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition Spine = Stalk.m_171599_("Spine", CubeListBuilder.m_171558_().m_171514_(27, 0).m_171488_(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-2.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(1.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 16).m_171488_(0.0f, -4.0f, 1.5f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-5.0f, (float)0.0f));
        PartDefinition SpineSeg2 = Spine.m_171599_("SpineSeg2", CubeListBuilder.m_171558_().m_171514_(27, 0).m_171488_(-1.49f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-2.49f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(1.51f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 16).m_171488_(0.01f, -4.0f, 1.5f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        PartDefinition SpineSeg3 = SpineSeg2.m_171599_("SpineSeg3", CubeListBuilder.m_171558_().m_171514_(27, 0).m_171488_(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(1.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-2.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 16).m_171488_(0.0f, -4.0f, 1.5f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition SpineSeg4 = SpineSeg3.m_171599_("SpineSeg4", CubeListBuilder.m_171558_().m_171514_(27, 0).m_171488_(-1.49f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(1.51f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-2.49f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 16).m_171480_().m_171488_(0.01f, -4.0f, 1.5f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.6981f, (float)0.0f, (float)0.0f));
        PartDefinition SpineSeg5 = SpineSeg4.m_171599_("SpineSeg5", CubeListBuilder.m_171558_().m_171514_(27, 0).m_171488_(-1.5f, -4.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(1.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 18).m_171488_(-2.5f, -4.0f, -1.5f, 1.0f, 2.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(24, 16).m_171488_(0.0f, -4.0f, 1.5f, 0.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)0.0f, (float)0.829f, (float)0.0f, (float)0.0f));
        PartDefinition Eye = SpineSeg5.m_171599_("Eye", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-4.0f, -4.0f, -8.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0975f, (float)0.8978f, (float)-0.5236f, (float)0.0f, (float)0.0f));
        PartDefinition Pupil = Eye.m_171599_("Pupil", CubeListBuilder.m_171558_().m_171514_(0, 47).m_171488_(-2.5f, -2.5f, -0.5f, 5.0f, 5.0f, 1.0f, new CubeDeformation(-0.2f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)-8.25f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    private void animateBiomass(ModelPart part, float value) {
        part.f_233553_ = 1.0f + Mth.m_14089_((float)(value / 6.0f)) / 6.0f;
        part.f_233554_ = 1.0f + Mth.m_14089_((float)(value / 6.0f)) / 6.0f;
        part.f_233555_ = 1.0f + Mth.m_14089_((float)(value / 6.0f)) / 6.0f;
    }

    private void animateBrain(ModelPart part, float value) {
        part.f_233553_ = 1.0f + Mth.m_14089_((float)(value / 8.0f)) / 8.0f;
        part.f_233554_ = 1.0f - Mth.m_14089_((float)(value / 8.0f)) / 8.0f;
        part.f_233555_ = 1.0f + Mth.m_14089_((float)(value / 8.0f)) / 8.0f;
    }

    private void RotateStalk(T thisEntity, Entity entity) {
        if (entity != null) {
            double d1 = entity.m_20185_() - (double)thisEntity.m_58899_().m_123341_();
            double d2 = entity.m_20189_() - (double)thisEntity.m_58899_().m_123343_();
            float value = -((float)Mth.m_14136_((double)(-d1), (double)(-d2))) * 57.295776f;
            this.segements.forEach(part -> {
                part.f_104204_ = value / 57.295776f / (float)this.segements.size();
            });
        }
    }

    private void animatePupil(T block, Entity entity, ModelPart part) {
        if (entity != null) {
            Vec3 vec3 = entity.m_20299_(0.0f);
            Vec3 vec31 = new Vec3((double)block.m_58899_().m_123341_() - 0.5, (double)block.m_58899_().m_123342_() + 0.75, (double)block.m_58899_().m_123343_() - 0.5);
            double d0 = vec3.f_82480_ - vec31.f_82480_;
            part.f_104201_ = d0 > 0.0 ? -0.5f : 0.5f;
            Vec3 vec32 = vec31;
            vec32 = new Vec3(vec32.f_82479_, 0.0, vec32.f_82481_);
            Vec3 vec33 = new Vec3(vec31.f_82479_ - vec3.f_82479_, 0.0, vec31.f_82481_ - vec3.f_82481_).m_82541_().m_82524_(1.5707964f);
            double d1 = vec32.m_82526_(vec33);
            part.f_104200_ = Mth.m_14116_((float)((float)Math.abs(d1))) * 0.01f * (float)Math.signum(d1);
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.OutpostCore.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public void setupAnim(T entity, float ageInTicks) {
        this.animateBiomass(this.Biomass, ageInTicks);
        this.animateBrain(this.Brain1, ageInTicks);
        this.animateBrain(this.Brain2, -ageInTicks);
        this.animateBrain(this.Brain3, ageInTicks);
        this.animateBrain(this.Brain4, -ageInTicks);
        this.RotateStalk(entity, Minecraft.m_91087_().f_91075_);
        this.animatePupil(entity, Minecraft.m_91087_().f_91075_, this.Pupil);
        this.Rib1.f_104203_ = -0.6f + Mth.m_14031_((float)(ageInTicks / 7.0f)) / 5.0f;
        this.Rib2.f_104203_ = -0.6f + Mth.m_14031_((float)(ageInTicks / 7.0f)) / 5.0f;
        this.Rib3.f_104203_ = 0.6f + Mth.m_14031_((float)(ageInTicks / 7.0f)) / 5.0f;
        this.Rib4.f_104203_ = -0.6f + Mth.m_14031_((float)(ageInTicks / 7.0f)) / 5.0f;
    }
}

