/*
 * Decompiled with CFR 0.152.
 */
package com.Harbinger.Spore.Client.Layers;

import com.Harbinger.Spore.Client.Models.HowitzerModel;
import com.Harbinger.Spore.Core.SConfig;
import com.Harbinger.Spore.Sentities.Calamities.Howitzer;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HowitzerLightsLayer<T extends Howitzer>
extends RenderLayer<T, HowitzerModel<T>> {
    private int currentTexture;
    public static final Map<activeLights, ResourceLocation> TEXTURE = (Map)Util.m_137469_((Object)Maps.newEnumMap(activeLights.class), p_114874_ -> {
        p_114874_.put(activeLights.RED, new ResourceLocation("spore", "textures/entity/howitzer_lights/red.png"));
        p_114874_.put(activeLights.BLUE, new ResourceLocation("spore", "textures/entity/howitzer_lights/blue.png"));
        p_114874_.put(activeLights.GREEN, new ResourceLocation("spore", "textures/entity/howitzer_lights/green.png"));
        p_114874_.put(activeLights.YELLOW, new ResourceLocation("spore", "textures/entity/howitzer_lights/yellow.png"));
    });

    public HowitzerLightsLayer(RenderLayerParent<T, HowitzerModel<T>> p_117346_) {
        super(p_117346_);
    }

    public void render(PoseStack stack, MultiBufferSource bufferSource, int p_117351_, T type, float p_117353_, float p_117354_, float p_117355_, float p_117356_, float p_117357_, float p_117358_) {
        LocalDate localdate;
        int j;
        if (((Boolean)SConfig.SERVER.costumes.get()).booleanValue() && ((j = (localdate = LocalDate.now()).get(ChronoField.MONTH_OF_YEAR)) == 12 || ((Boolean)SConfig.SERVER.costumes_active.get()).booleanValue())) {
            stack.m_85836_();
            this.renderActiveLight(bufferSource, stack);
            if (((Howitzer)type).f_19797_ % 40 == 0) {
                this.currentTexture = this.currentTexture == activeLights.values().length ? 0 : this.currentTexture + 1;
            }
            stack.m_85849_();
        }
    }

    public void renderActiveLight(MultiBufferSource bufferSource, PoseStack stack) {
        VertexConsumer vertexconsumer = bufferSource.m_6299_(RenderType.m_110488_((ResourceLocation)TEXTURE.get((Object)activeLights.byId(this.currentTexture & 0xFF))));
        ((HowitzerModel)this.m_117386_()).m_7695_(stack, vertexconsumer, 0xF00000, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    static enum activeLights {
        RED(0),
        BLUE(1),
        GREEN(2),
        YELLOW(3);

        private final int type;
        private static final activeLights[] BY_ID;

        private activeLights(int type) {
            this.type = type;
        }

        public int getType() {
            return this.type;
        }

        public static activeLights byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        static {
            BY_ID = (activeLights[])Arrays.stream(activeLights.values()).sorted(Comparator.comparingInt(activeLights::getType)).toArray(activeLights[]::new);
        }
    }
}

