/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.util.compat.jei.cloche;

import blusunrize.immersiveengineering.api.crafting.ClocheFertilizer;
import blusunrize.immersiveengineering.api.crafting.ClocheRecipe;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.compat.jei.IERecipeCategory;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIHelper;
import blusunrize.immersiveengineering.common.util.compat.jei.JEIRecipeTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

public class ClocheRecipeCategory
extends IERecipeCategory<ClocheRecipe> {
    private final IDrawableStatic tankOverlay;
    private final IDrawableAnimated arrow;

    public ClocheRecipeCategory(IGuiHelper helper) {
        super(helper, JEIRecipeTypes.CLOCHE, "block.immersiveengineering.cloche");
        ResourceLocation background = new ResourceLocation("immersiveengineering", "textures/gui/cloche.png");
        this.setBackground(helper.createDrawable(background, 0, 0, 176, 77));
        this.setIcon(new ItemStack(IEBlocks.MetalDevices.CLOCHE));
        this.tankOverlay = helper.createDrawable(background, 176, 30, 20, 51);
        this.arrow = helper.drawableBuilder(background, 181, 1, 13, 13).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ClocheRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 62, 34).addItemStacks(Arrays.asList(recipe.seed.m_43908_()));
        builder.addSlot(RecipeIngredientRole.INPUT, 62, 54).addItemStacks(Arrays.asList(recipe.soil.m_43908_()));
        for (int i = 0; i < recipe.outputs.size(); ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 116 + i % 2 * 18, 34 + i / 2 * 18).addItemStack((ItemStack)recipe.outputs.get(i).get());
        }
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 6, 6).setFluidRenderer(4000L, false, 20, 51).setOverlay((IDrawable)this.tankOverlay, 0, 0).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)new FluidStack((Fluid)Fluids.f_76193_, 4000))).addTooltipCallback(JEIHelper.fluidTooltipCallback);
        ArrayList<ItemStack> fertilizers = new ArrayList<ItemStack>(Collections.singleton(ItemStack.f_41583_));
        for (ClocheFertilizer fertilizerList : ClocheFertilizer.RECIPES.getRecipes((Level)Minecraft.m_91087_().f_91073_)) {
            fertilizers.addAll(Arrays.stream(fertilizerList.input.m_43908_()).toList());
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 8, 59).addItemStacks(fertilizers);
    }

    public void draw(ClocheRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.arrow.draw(graphics, 101, 35);
    }
}

