/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.crafting.BottlingMachineRecipe;
import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.common.register.IEMultiblockLogic;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.Lazy;

public class BottlingMachineRecipeSerializer
extends IERecipeSerializer<BottlingMachineRecipe> {
    @Override
    public ItemStack getIcon() {
        return IEMultiblockLogic.BOTTLING_MACHINE.iconStack();
    }

    @Override
    public BottlingMachineRecipe readFromJson(ResourceLocation recipeId, JsonObject json, ICondition.IContext context) {
        IngredientWithSize[] ingredients;
        JsonArray results = json.getAsJsonArray("results");
        ArrayList<Lazy<ItemStack>> outputs = new ArrayList<Lazy<ItemStack>>();
        for (int i = 0; i < results.size(); ++i) {
            outputs.add(BottlingMachineRecipeSerializer.readOutput(results.get(i)));
        }
        if (json.has("input")) {
            ingredients = new IngredientWithSize[]{IngredientWithSize.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"))};
        } else {
            JsonArray inputs = json.getAsJsonArray("inputs");
            ingredients = new IngredientWithSize[inputs.size()];
            for (int i = 0; i < ingredients.length; ++i) {
                ingredients[i] = IngredientWithSize.deserialize(inputs.get(i));
            }
        }
        FluidTagInput fluidInput = FluidTagInput.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"fluid"));
        return IEServerConfig.MACHINES.bottlingMachineConfig.apply(new BottlingMachineRecipe(recipeId, outputs, ingredients, fluidInput));
    }

    @Nullable
    public BottlingMachineRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        List<Lazy<ItemStack>> outputs = PacketUtils.readList(buffer, x$0 -> IERecipeSerializer.readLazyStack(x$0));
        int inputCount = buffer.readInt();
        IngredientWithSize[] ingredients = new IngredientWithSize[inputCount];
        for (int i = 0; i < ingredients.length; ++i) {
            ingredients[i] = IngredientWithSize.read(buffer);
        }
        FluidTagInput fluidInput = FluidTagInput.read(buffer);
        return new BottlingMachineRecipe(recipeId, outputs, ingredients, fluidInput);
    }

    public void toNetwork(FriendlyByteBuf buffer, BottlingMachineRecipe recipe) {
        PacketUtils.writeListReverse(buffer, (List)recipe.output.get(), FriendlyByteBuf::m_130055_);
        buffer.writeInt(recipe.inputs.length);
        for (IngredientWithSize ingredient : recipe.inputs) {
            ingredient.write(buffer);
        }
        recipe.fluidInput.write(buffer);
    }
}

