/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.blocks.generic;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WallmountBlock
extends IEBaseBlock {
    public static final EnumProperty<Orientation> ORIENTATION = EnumProperty.m_61587_((String)"orientation", Orientation.class);

    public WallmountBlock(BlockBehaviour.Properties blockProps) {
        super(blockProps);
        this.lightOpacity = 0;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{IEProperties.FACING_HORIZONTAL, ORIENTATION, BlockStateProperties.f_61362_});
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState ret = super.m_5573_(context);
        if (ret == null) {
            return null;
        }
        Direction side = context.m_43719_();
        Direction facing = Direction.m_122364_((double)context.m_7074_());
        if (side.m_122434_() == Direction.Axis.Y) {
            facing = facing.m_122424_();
        }
        ret = side == Direction.UP ? (BlockState)ret.m_61124_(ORIENTATION, (Comparable)((Object)Orientation.VERT_UP)) : (side == Direction.DOWN ? (BlockState)ret.m_61124_(ORIENTATION, (Comparable)((Object)Orientation.VERT_DOWN)) : (context.m_43720_().f_82480_ - (double)context.m_8083_().m_123342_() < 0.5 ? (BlockState)ret.m_61124_(ORIENTATION, (Comparable)((Object)Orientation.SIDE_DOWN)) : (BlockState)ret.m_61124_(ORIENTATION, (Comparable)((Object)Orientation.SIDE_UP))));
        ret = (BlockState)ret.m_61124_((Property)IEProperties.FACING_HORIZONTAL, (Comparable)facing);
        return ret;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        double maxX;
        double minX;
        Orientation orientation = (Orientation)((Object)state.m_61143_(ORIENTATION));
        Direction facing = (Direction)state.m_61143_((Property)IEProperties.FACING_HORIZONTAL);
        Direction towards = orientation.attachedToSide() ? facing : facing.m_122424_();
        double d = minX = towards == Direction.WEST ? 0.0 : 0.3125;
        double minY = orientation == Orientation.SIDE_UP ? 0.375 : (orientation == Orientation.VERT_DOWN ? 0.3125 : 0.0);
        double minZ = towards == Direction.NORTH ? 0.0 : 0.3125;
        double d2 = maxX = towards == Direction.EAST ? 1.0 : 0.6875;
        double maxY = orientation == Orientation.SIDE_DOWN ? 0.625 : (orientation == Orientation.VERT_UP ? 0.6875 : 1.0);
        double maxZ = towards == Direction.SOUTH ? 1.0 : 0.6875;
        return Shapes.m_83048_((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    @Override
    public InteractionResult hammerUseSide(Direction side, Player player, InteractionHand hand, Level w, BlockPos pos, BlockHitResult hit) {
        if (player.m_6144_()) {
            BlockState state = w.m_8055_(pos);
            Orientation old = (Orientation)((Object)state.m_61143_(ORIENTATION));
            Orientation newO = old.getDual();
            w.m_46597_(pos, (BlockState)state.m_61124_(ORIENTATION, (Comparable)((Object)newO)));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static enum Orientation implements StringRepresentable
    {
        SIDE_UP,
        SIDE_DOWN,
        VERT_DOWN,
        VERT_UP;


        public String m_7912_() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public boolean attachedToSide() {
            return this == SIDE_DOWN || this == SIDE_UP;
        }

        public boolean touchesTop() {
            return this == SIDE_UP || this == VERT_UP;
        }

        public Orientation getDual() {
            switch (this) {
                case SIDE_UP: {
                    return SIDE_DOWN;
                }
                case SIDE_DOWN: {
                    return SIDE_UP;
                }
                case VERT_UP: {
                    return VERT_DOWN;
                }
            }
            return VERT_UP;
        }

        public String modelSuffix() {
            switch (this) {
                case SIDE_UP: {
                    return "";
                }
                case SIDE_DOWN: {
                    return "_inverted";
                }
                case VERT_DOWN: {
                    return "_sideways";
                }
            }
            return "_sideways_inverted";
        }

        public String toString() {
            return this.m_7912_();
        }
    }
}

