/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.jadevs.component;

import com.github.litermc.jadevs.JadeVSPlugin;
import com.github.litermc.jadevs.component.ShipDetailsComponentProvider;
import com.github.litermc.jadevs.util.UnitFormatter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public final class ShipMassComponentProvider
extends ShipDetailsComponentProvider {
    public static final ShipMassComponentProvider INSTANCE = new ShipMassComponentProvider();

    private ShipMassComponentProvider() {
    }

    public ResourceLocation getUid() {
        return JadeVSPlugin.SHIP_MASS;
    }

    @Override
    public void appendServerDataOnShip(CompoundTag data, BlockAccessor accessor, LoadedServerShip ship) {
        Vector3dc scaling = ship.getTransform().getShipToWorldScaling();
        data.m_128356_("shipMass", (long)(ship.getInertiaData().getMass() * 1000.0 * scaling.x() * scaling.y() * scaling.z()));
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag compound = accessor.getServerData();
        if (!compound.m_128441_("shipMass")) {
            return;
        }
        long mass = compound.m_128454_("shipMass");
        tooltip.add((Component)Component.m_237115_((String)"jade_vs.tooltip.ship_mass").m_130946_(": "));
        tooltip.append((Component)IThemeHelper.get().info((Object)UnitFormatter.formatWeight(mass)));
    }
}

