/*
 * Decompiled with CFR 0.152.
 */
package com.github.litermc.jadevs.component;

import com.github.litermc.jadevs.JadeVSPlugin;
import com.github.litermc.jadevs.util.UnitFormatter;
import kotlin.Pair;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.valkyrienskies.mod.common.BlockStateInfo;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;

public final class BlockMassComponentProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor> {
    public static final BlockMassComponentProvider INSTANCE = new BlockMassComponentProvider();

    private BlockMassComponentProvider() {
    }

    public ResourceLocation getUid() {
        return JadeVSPlugin.BLOCK_MASS;
    }

    public boolean isRequired() {
        return false;
    }

    public void appendServerData(CompoundTag data, BlockAccessor accessor) {
        Pair pair = BlockStateInfo.INSTANCE.get(accessor.getBlockState());
        if (pair == null) {
            return;
        }
        Double mass = (Double)pair.getFirst();
        if (mass == null) {
            return;
        }
        data.m_128347_("mass", (double)((long)(mass * 1000.0)));
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag compound = accessor.getServerData();
        if (!compound.m_128441_("mass")) {
            return;
        }
        long mass = compound.m_128454_("mass");
        tooltip.add((Component)Component.m_237115_((String)"jade_vs.tooltip.standard_mass").m_130946_(": "));
        tooltip.append((Component)IThemeHelper.get().info((Object)UnitFormatter.formatWeight(mass)));
    }
}

