/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.tracking;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.MobProfile;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.config.SoundOverride;
import com.example.soundattract.data.DataDrivenTags;
import com.example.soundattract.quantified.QuantifiedCacheCompat;
import com.example.soundattract.worker.WorkSchedulerManager;
import com.example.soundattract.worker.WorkerScheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class SoundTracker {
    private static final AtomicLong SOUND_SEQUENCE = new AtomicLong(0L);
    private static final List<SoundRecord> RECENT_SOUNDS = new ArrayList<SoundRecord>();
    private static final Map<String, Map<GridKey3D, Map<String, SoundRecord>>> SPATIAL_SOUNDS = new ConcurrentHashMap<String, Map<GridKey3D, Map<String, SoundRecord>>>();
    private static final Map<String, SoundRecord> LARGE_RANGE_SOUNDS = new ConcurrentHashMap<String, SoundRecord>();
    private static final Map<String, SoundRecord> SOUND_RECORDS_BY_ID = new ConcurrentHashMap<String, SoundRecord>();
    private static final Set<String> DEDUP_SET_A = ConcurrentHashMap.newKeySet();
    private static final Set<String> DEDUP_SET_B = ConcurrentHashMap.newKeySet();
    private static Set<String> DEDUP_THIS_TICK = DEDUP_SET_A;
    private static Set<String> DEDUP_LAST_TICK = DEDUP_SET_B;
    private static final ReadWriteLock lock = new ReentrantReadWriteLock();
    private static final Lock readLock = lock.readLock();
    private static final Lock writeLock = lock.writeLock();
    private static final double LARGE_SOUND_RANGE_THRESHOLD = 64.0;
    private static final int MAX_SYNC_CANDIDATES = 24;
    private static final Map<RaycastCacheKey, RaycastEntry> RAYCAST_CACHE = new ConcurrentHashMap<RaycastCacheKey, RaycastEntry>();
    private static final double NO_MUFFLING_RANGE = 1.0;
    private static final double NO_MUFFLING_WEIGHT = 1.0;
    private static final ConcurrentHashMap<UUID, String> ASYNC_BEST_SOUND_BY_MOB = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Double> ASYNC_BEST_SOUND_RANGE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Double> ASYNC_BEST_SOUND_WEIGHT = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Long> ASYNC_RESULT_GAME_TIME = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Long> LAST_SUBMIT_GAME_TIME = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Integer> LAST_CANDIDATE_HASH = new ConcurrentHashMap();
    private static final ConcurrentHashMap<UUID, Map<String, MuffledResult>> ASYNC_MUFFLED_BY_MOB = new ConcurrentHashMap();

    public static long getSoundSequence() {
        return SOUND_SEQUENCE.get();
    }

    public static String buildIntegrationSoundId(ResourceLocation baseId, @Nullable String metadata) {
        if (baseId == null) {
            return metadata == null ? null : metadata.trim();
        }
        if (metadata == null || metadata.isBlank()) {
            return baseId.toString();
        }
        String trimmed = metadata.trim();
        StringBuilder sanitized = new StringBuilder(trimmed.length());
        for (int i = 0; i < trimmed.length(); ++i) {
            char ch = trimmed.charAt(i);
            if (Character.isWhitespace(ch)) {
                sanitized.append('_');
                continue;
            }
            if (ch == ';' || ch == '|' || ch == ',' || ch == '#') {
                sanitized.append('/');
                continue;
            }
            sanitized.append(Character.toLowerCase(ch));
        }
        return baseId + "#" + sanitized;
    }

    @Nullable
    public static ResourceLocation extractBaseSoundLocation(@Nullable String soundId) {
        if (soundId == null || soundId.isBlank()) {
            return null;
        }
        int idx = soundId.indexOf(35);
        String base = idx >= 0 ? soundId.substring(0, idx) : soundId;
        return ResourceLocation.m_135820_((String)base);
    }

    @Nullable
    public static String extractIntegrationMetadata(@Nullable String soundId) {
        if (soundId == null) {
            return null;
        }
        int idx = soundId.indexOf(35);
        if (idx < 0 || idx + 1 >= soundId.length()) {
            return null;
        }
        return soundId.substring(idx + 1);
    }

    private static GridKey3D gridKey(BlockPos pos) {
        int x = pos.m_123341_() >> 4;
        int y = pos.m_123342_() >> 4;
        int z = pos.m_123343_() >> 4;
        return new GridKey3D(x, y, z);
    }

    private static void addRecordToCollections(SoundRecord r) {
        if (r.range > 64.0) {
            LARGE_RANGE_SOUNDS.put(r.soundId, r);
        } else {
            SPATIAL_SOUNDS.computeIfAbsent(r.dimensionKey, k -> new ConcurrentHashMap()).computeIfAbsent(SoundTracker.gridKey(r.pos), k -> new ConcurrentHashMap()).put(r.soundId, r);
        }
        SOUND_RECORDS_BY_ID.put(r.soundId, r);
    }

    private static void removeRecordFromCollections(SoundRecord r) {
        if (r.range > 64.0) {
            LARGE_RANGE_SOUNDS.remove(r.soundId);
        } else {
            Map<GridKey3D, Map<String, SoundRecord>> dimMap = SPATIAL_SOUNDS.get(r.dimensionKey);
            if (dimMap != null) {
                Map<String, SoundRecord> gridCell = dimMap.get(SoundTracker.gridKey(r.pos));
                if (gridCell != null) {
                    if (gridCell.remove(r.soundId) != null) {
                        SOUND_RECORDS_BY_ID.remove(r.soundId);
                    }
                    if (gridCell.isEmpty()) {
                        dimMap.remove(SoundTracker.gridKey(r.pos));
                    }
                }
                if (dimMap.isEmpty()) {
                    SPATIAL_SOUNDS.remove(r.dimensionKey);
                }
            }
        }
    }

    private static List<SoundRecord> getNearbySounds(String dim, BlockPos pos) {
        ArrayList<SoundRecord> result = new ArrayList<SoundRecord>();
        Map<GridKey3D, Map<String, SoundRecord>> dimMap = SPATIAL_SOUNDS.get(dim);
        if (dimMap != null) {
            GridKey3D centerKey = SoundTracker.gridKey(pos);
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dx = -1; dx <= 1; ++dx) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        GridKey3D neighborKey = new GridKey3D(centerKey.x() + dx, centerKey.y() + dy, centerKey.z() + dz);
                        Map<String, SoundRecord> list = dimMap.get(neighborKey);
                        if (list == null) continue;
                        result.addAll(list.values());
                    }
                }
            }
        }
        for (SoundRecord r : LARGE_RANGE_SOUNDS.values()) {
            if (!r.dimensionKey.equals(dim)) continue;
            result.add(r);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSound(SoundEvent se, BlockPos pos, String dimensionKey, double range, double weight, int lifetime, String explicitSoundId) {
        if (pos == null || dimensionKey == null) {
            return;
        }
        String soundIdToUse = explicitSoundId;
        if (soundIdToUse == null && se != null && se.m_11660_() != null) {
            soundIdToUse = se.m_11660_().toString();
        }
        if (soundIdToUse == null || soundIdToUse.isBlank()) {
            return;
        }
        if (se == null && soundIdToUse.startsWith("pointblank:")) {
            weight *= 2.0;
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[SoundTracker] Boosting Point Blank fallback sound: {} weight -> {}", (Object)soundIdToUse, (Object)weight);
            }
        }
        ResourceLocation loc = SoundTracker.extractBaseSoundLocation(soundIdToUse);
        if (!(SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.isEmpty() || loc != null && SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.contains(loc))) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && !soundIdToUse.startsWith("pointblank:")) {
                SoundAttractMod.LOGGER.info("[SoundTracker] Sound {} not in whitelist, ignoring.", (Object)soundIdToUse);
            }
            return;
        }
        writeLock.lock();
        try {
            String dedupKey = null;
            if (soundIdToUse != null && pos != null && dimensionKey != null) {
                dedupKey = dimensionKey + "|" + soundIdToUse + "|" + pos.m_121878_();
                if (DEDUP_THIS_TICK.contains(dedupKey) || DEDUP_LAST_TICK.contains(dedupKey)) {
                    return;
                }
                DEDUP_THIS_TICK.add(dedupKey);
            }
            Iterator<SoundRecord> it = RECENT_SOUNDS.iterator();
            while (it.hasNext()) {
                SoundRecord existing = it.next();
                if (!existing.dimensionKey.equals(dimensionKey) || !existing.pos.equals((Object)pos) || !Objects.equals(existing.soundId, soundIdToUse)) continue;
                if (existing.weight >= weight) {
                    return;
                }
                it.remove();
                SoundTracker.removeRecordFromCollections(existing);
                break;
            }
            int cap = (Integer)SoundAttractConfig.COMMON.maxSoundsTracked.get();
            if (RECENT_SOUNDS.size() >= cap) {
                SoundRecord worstRecord = null;
                int worstRecordIndex = -1;
                double minMetric = Double.MAX_VALUE;
                for (int i = 0; i < RECENT_SOUNDS.size(); ++i) {
                    SoundRecord current = RECENT_SOUNDS.get(i);
                    double currentMetric = current.weight + current.range / 1000.0;
                    if (!(currentMetric < minMetric)) continue;
                    minMetric = currentMetric;
                    worstRecord = current;
                    worstRecordIndex = i;
                }
                double newMetric = weight + range / 1000.0;
                if (worstRecord != null && newMetric > minMetric) {
                    RECENT_SOUNDS.remove(worstRecordIndex);
                    SoundTracker.removeRecordFromCollections(worstRecord);
                } else {
                    return;
                }
            }
            SoundRecord record = new SoundRecord(se, soundIdToUse, pos, lifetime, dimensionKey, range, weight);
            RECENT_SOUNDS.add(record);
            SoundTracker.addRecordToCollections(record);
            SOUND_SEQUENCE.incrementAndGet();
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && !soundIdToUse.startsWith("pointblank:")) {
                SoundAttractMod.LOGGER.info("[SoundTracker] Successfully added sound: {} at {} (range={}, weight={}, lifetime={})", new Object[]{soundIdToUse, pos, range, weight, lifetime});
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    public static void tick() {
        writeLock.lock();
        try {
            Iterator<SoundRecord> iter = RECENT_SOUNDS.iterator();
            while (iter.hasNext()) {
                SoundRecord r = iter.next();
                --r.ticksRemaining;
                if (r.ticksRemaining > 0) continue;
                iter.remove();
                SoundTracker.removeRecordFromCollections(r);
            }
            Set<String> previous = DEDUP_THIS_TICK;
            DEDUP_THIS_TICK = DEDUP_LAST_TICK;
            DEDUP_LAST_TICK = previous;
            DEDUP_THIS_TICK.clear();
        }
        finally {
            writeLock.unlock();
        }
    }

    public static void addSound(SoundEvent se, BlockPos pos, String dimensionKey, double range, double weight, int lifetime) {
        SoundTracker.addSound(se, pos, dimensionKey, range, weight, lifetime, null);
    }

    public static void addSound(SoundEvent se, BlockPos pos, String dimensionKey) {
        int lifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
        SoundTracker.addSound(se, pos, dimensionKey, 16.0, 1.0, lifetime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVirtualSound(BlockPos pos, String dimensionKey, double range, double weight, int lifetime, UUID sourcePlayer, String animationClass) {
        if (pos == null || dimensionKey == null) {
            return;
        }
        writeLock.lock();
        try {
            RECENT_SOUNDS.removeIf(r -> {
                boolean shouldRemove;
                boolean bl = shouldRemove = r.pos.equals((Object)pos) && r.dimensionKey.equals(dimensionKey) && r.weight < weight;
                if (shouldRemove) {
                    SoundTracker.removeRecordFromCollections(r);
                }
                return shouldRemove;
            });
            boolean strongerOrEqualExists = RECENT_SOUNDS.stream().anyMatch(r -> r.pos.equals((Object)pos) && r.dimensionKey.equals(dimensionKey) && r.weight >= weight);
            if (!strongerOrEqualExists) {
                String virtualId = "soundattract:virtual#" + (sourcePlayer != null ? sourcePlayer.toString() : "unknown") + "/" + (animationClass != null ? animationClass : "unknown") + "/" + pos.m_121878_();
                VirtualSoundRecord record = new VirtualSoundRecord(virtualId, pos, lifetime, dimensionKey, range, weight, sourcePlayer, animationClass);
                RECENT_SOUNDS.add(record);
                SoundTracker.addRecordToCollections(record);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSoundAt(BlockPos pos, String dimensionKey) {
        writeLock.lock();
        try {
            Iterator<SoundRecord> iter = RECENT_SOUNDS.iterator();
            while (iter.hasNext()) {
                SoundRecord r = iter.next();
                if (!r.pos.equals((Object)pos) || !r.dimensionKey.equals(dimensionKey)) continue;
                iter.remove();
                SoundTracker.removeRecordFromCollections(r);
                break;
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    private static void drainAsyncSoundScores(Level level) {
        block4: {
            try {
                List<WorkerScheduler.SoundScoreResult> results = WorkSchedulerManager.get().drainSoundScoreResults();
                if (results == null || results.isEmpty()) {
                    return;
                }
                long nowGameTime = level == null ? 0L : level.m_46467_();
                for (WorkerScheduler.SoundScoreResult r : results) {
                    MuffledResult result;
                    if (r == null || r.mobUuid() == null || r.soundId() == null) continue;
                    ASYNC_BEST_SOUND_BY_MOB.put(r.mobUuid(), r.soundId());
                    ASYNC_RESULT_GAME_TIME.put(r.mobUuid(), nowGameTime);
                    Map<String, MuffledResult> muffled = ASYNC_MUFFLED_BY_MOB.get(r.mobUuid());
                    if (muffled == null || (result = muffled.get(r.soundId())) == null) continue;
                    ASYNC_BEST_SOUND_RANGE.put(r.mobUuid(), result.range());
                    ASYNC_BEST_SOUND_WEIGHT.put(r.mobUuid(), result.weight());
                }
            }
            catch (Throwable t) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block4;
                SoundAttractMod.LOGGER.error("[SoundTracker] drainAsyncSoundScores failed", t);
            }
        }
    }

    public static double[] applyBlockMuffling(Level level, BlockPos src, BlockPos dst, double origRange, double origWeight, String soundId) {
        RaycastEntry existing;
        if (level == null || src == null || dst == null) {
            return new double[]{origRange, origWeight};
        }
        if (!((Boolean)SoundAttractConfig.COMMON.enableBlockMuffling.get()).booleanValue()) {
            return new double[]{origRange, origWeight};
        }
        boolean useCache = (Boolean)SoundAttractConfig.COMMON.enableRaycastCache.get();
        long raycastTtl = ((Integer)SoundAttractConfig.COMMON.raycastCacheTtlTicks.get()).intValue();
        int raycastMax = (Integer)SoundAttractConfig.COMMON.raycastCacheMaxEntries.get();
        String dimensionKey = level.m_46472_().m_135782_().toString();
        if (useCache && QuantifiedCacheCompat.isUsable()) {
            String key = new StringBuilder(128).append(dimensionKey).append('|').append(soundId).append('|').append(dst.m_123341_()).append(',').append(dst.m_123342_()).append(',').append(dst.m_123343_()).append('|').append(src.m_123341_()).append(',').append(src.m_123342_()).append(',').append(src.m_123343_()).toString();
            return QuantifiedCacheCompat.getCached("soundattract_raycast_muffling", key, () -> SoundTracker.computeBlockMuffling(level, src, dst, origRange, origWeight, soundId), raycastTtl, raycastMax);
        }
        RaycastCacheKey cacheKey = new RaycastCacheKey(dst, src, soundId, dimensionKey);
        if (useCache && (existing = RAYCAST_CACHE.get(cacheKey)) != null) {
            long age = level.m_46467_() - existing.gameTime;
            if (age <= raycastTtl) {
                return existing.result;
            }
            RAYCAST_CACHE.remove(cacheKey);
        }
        double[] finalResult = SoundTracker.computeBlockMuffling(level, src, dst, origRange, origWeight, soundId);
        if (useCache) {
            RAYCAST_CACHE.put(cacheKey, new RaycastEntry(finalResult, level.m_46467_()));
            if (RAYCAST_CACHE.size() > raycastMax) {
                long now = level.m_46467_();
                Iterator<Map.Entry<RaycastCacheKey, RaycastEntry>> it = RAYCAST_CACHE.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<RaycastCacheKey, RaycastEntry> e = it.next();
                    if (now - e.getValue().gameTime <= raycastTtl) continue;
                    it.remove();
                }
                if (RAYCAST_CACHE.size() > raycastMax) {
                    int toRemove = RAYCAST_CACHE.size() - raycastMax;
                    Iterator<Map.Entry<RaycastCacheKey, RaycastEntry>> it2 = RAYCAST_CACHE.entrySet().iterator();
                    for (int i = 0; i < toRemove && it2.hasNext(); ++i) {
                        it2.next();
                        it2.remove();
                    }
                }
            }
        }
        return finalResult;
    }

    private static double[] computeBlockMuffling(Level level, BlockPos src, BlockPos dst, double origRange, double origWeight, String soundId) {
        Vec3 end;
        double currentRange = origRange;
        double currentWeight = origWeight;
        int blocksHit = 0;
        Vec3 start = Vec3.m_82512_((Vec3i)src);
        BlockHitResult result = level.m_45547_(new ClipContext(start, end = Vec3.m_82512_((Vec3i)dst), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos currentPos = result.m_82425_();
            Vec3 currentHitVec = result.m_82450_();
            int maxChecks = (Integer)SoundAttractConfig.COMMON.maxMufflingBlocksToCheck.get();
            for (int i = 0; i < maxChecks && currentRange > 0.1 && currentWeight > 0.01; ++i) {
                BlockState blockState = level.m_8055_(currentPos);
                Block block = blockState.m_60734_();
                double rangeMultiplier = 1.0;
                double weightMultiplier = 1.0;
                if (SoundTracker.isCustomWool(blockState, block, level, currentPos)) {
                    rangeMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorWool.get();
                    weightMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorWool.get();
                } else if (SoundTracker.isCustomLiquid(blockState, block, level, currentPos)) {
                    rangeMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorLiquid.get();
                    weightMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorLiquid.get();
                } else if (SoundTracker.isCustomThin(blockState, block, level, currentPos)) {
                    rangeMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorThin.get();
                    weightMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorThin.get();
                } else if (SoundTracker.isCustomSolid(blockState, block, level, currentPos)) {
                    rangeMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorSolid.get();
                    weightMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorSolid.get();
                } else if (SoundTracker.isCustomNonSolid(blockState, block, level, currentPos)) {
                    rangeMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorNonSolid.get();
                    weightMultiplier = (Double)SoundAttractConfig.COMMON.mufflingFactorNonSolid.get();
                } else if (blockState.m_60795_()) {
                    // empty if block
                }
                currentRange *= rangeMultiplier;
                currentWeight *= weightMultiplier;
                ++blocksHit;
                Vec3 direction = end.m_82546_(start).m_82541_();
                currentHitVec = currentHitVec.m_82549_(direction.m_82490_(0.1));
                BlockHitResult nextResult = level.m_45547_(new ClipContext(currentHitVec, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null));
                if (nextResult.m_6662_() != HitResult.Type.BLOCK || nextResult.m_82425_().equals((Object)currentPos)) break;
                currentPos = nextResult.m_82425_();
                currentHitVec = nextResult.m_82450_();
            }
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && blocksHit > 0) {
            SoundAttractMod.LOGGER.debug("Muffling for sound {} from {} to {}: {} blocks hit. Range: {} -> {}, Weight: {} -> {}", new Object[]{soundId, src, dst, blocksHit, origRange, currentRange, origWeight, currentWeight});
        }
        return new double[]{Math.max(0.0, currentRange), Math.max(0.0, currentWeight)};
    }

    private static boolean isCustomWool(BlockState state, Block block, Level level, BlockPos pos) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        boolean inConfig = id != null && SoundAttractConfig.CUSTOM_WOOL_BLOCKS_CACHE.contains(id);
        boolean enableDataDriven = (Boolean)SoundAttractConfig.COMMON.enableDataDriven.get();
        boolean inTag = false;
        if (enableDataDriven) {
            try {
                inTag = state.m_204336_(DataDrivenTags.MUFFLING_WOOL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!enableDataDriven) {
            if (inConfig) {
                return true;
            }
        } else {
            String priority = (String)SoundAttractConfig.COMMON.datapackPriority.get();
            boolean datapackOverConfig = "datapack_over_config".equalsIgnoreCase(priority);
            if (datapackOverConfig) {
                if (inTag) {
                    return true;
                }
                if (inConfig) {
                    return true;
                }
            } else {
                if (inConfig) {
                    return true;
                }
                if (inTag) {
                    return true;
                }
            }
        }
        try {
            return state.m_204336_(BlockTags.f_13089_);
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.warn("Exception checking BlockTags.WOOL for block {} at {}. Defaulting to false.", new Object[]{ForgeRegistries.BLOCKS.getKey((Object)block), pos, e});
            return false;
        }
    }

    private static boolean isCustomSolid(BlockState state, Block block, Level level, BlockPos pos) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        boolean inConfig = id != null && SoundAttractConfig.CUSTOM_SOLID_BLOCKS_CACHE.contains(id);
        boolean enableDataDriven = (Boolean)SoundAttractConfig.COMMON.enableDataDriven.get();
        boolean inTag = false;
        if (enableDataDriven) {
            try {
                inTag = state.m_204336_(DataDrivenTags.MUFFLING_SOLID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!enableDataDriven) {
            if (inConfig) {
                return true;
            }
        } else {
            String priority = (String)SoundAttractConfig.COMMON.datapackPriority.get();
            boolean datapackOverConfig = "datapack_over_config".equalsIgnoreCase(priority);
            if (datapackOverConfig) {
                if (inTag) {
                    return true;
                }
                if (inConfig) {
                    return true;
                }
            } else {
                if (inConfig) {
                    return true;
                }
                if (inTag) {
                    return true;
                }
            }
        }
        try {
            return state.m_60804_((BlockGetter)level, pos);
        }
        catch (NullPointerException npe) {
            SoundAttractMod.LOGGER.warn("NPE in state.isSolidRender() for block {} at {}. Defaulting to solid.", new Object[]{ForgeRegistries.BLOCKS.getKey((Object)block), pos, npe});
            return true;
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("Error in state.isSolidRender() for block {} at {}. Defaulting to solid.", new Object[]{ForgeRegistries.BLOCKS.getKey((Object)block), pos, e});
            return true;
        }
    }

    private static boolean isCustomNonSolid(BlockState state, Block block, Level level, BlockPos pos) {
        boolean isNormallySolid;
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        boolean inConfig = id != null && SoundAttractConfig.CUSTOM_NON_SOLID_BLOCKS_CACHE.contains(id);
        boolean enableDataDriven = (Boolean)SoundAttractConfig.COMMON.enableDataDriven.get();
        boolean inTag = false;
        if (enableDataDriven) {
            try {
                inTag = state.m_204336_(DataDrivenTags.MUFFLING_NON_SOLID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!enableDataDriven) {
            if (inConfig) {
                return true;
            }
        } else {
            String priority = (String)SoundAttractConfig.COMMON.datapackPriority.get();
            boolean datapackOverConfig = "datapack_over_config".equalsIgnoreCase(priority);
            if (datapackOverConfig) {
                if (inTag) {
                    return true;
                }
                if (inConfig) {
                    return true;
                }
            } else {
                if (inConfig) {
                    return true;
                }
                if (inTag) {
                    return true;
                }
            }
        }
        try {
            isNormallySolid = state.m_60804_((BlockGetter)level, pos);
        }
        catch (NullPointerException npe) {
            SoundAttractMod.LOGGER.warn("NPE in state.isSolidRender() for block {} at {}. Defaulting to solid (meaning not 'non-solid').", new Object[]{ForgeRegistries.BLOCKS.getKey((Object)block), pos, npe});
            isNormallySolid = true;
        }
        catch (Exception e) {
            SoundAttractMod.LOGGER.error("Error in state.isSolidRender() for block {} at {}. Defaulting to solid.", new Object[]{ForgeRegistries.BLOCKS.getKey((Object)block), pos, e});
            isNormallySolid = true;
        }
        return !isNormallySolid;
    }

    private static boolean isCustomThin(BlockState state, Block block, Level level, BlockPos pos) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        boolean inConfig = id != null && SoundAttractConfig.CUSTOM_THIN_BLOCKS_CACHE.contains(id);
        boolean enableDataDriven = (Boolean)SoundAttractConfig.COMMON.enableDataDriven.get();
        boolean inTag = false;
        if (enableDataDriven) {
            try {
                inTag = state.m_204336_(DataDrivenTags.MUFFLING_THIN);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!enableDataDriven) {
            if (inConfig) {
                return true;
            }
        } else {
            String priority = (String)SoundAttractConfig.COMMON.datapackPriority.get();
            boolean datapackOverConfig = "datapack_over_config".equalsIgnoreCase(priority);
            if (datapackOverConfig) {
                if (inTag) {
                    return true;
                }
                if (inConfig) {
                    return true;
                }
            } else {
                if (inConfig) {
                    return true;
                }
                if (inTag) {
                    return true;
                }
            }
        }
        if (id == null) {
            return false;
        }
        String path = id.m_135815_();
        return path.contains("pane") || path.contains("iron_bars") || path.contains("painting") || path.contains("fence") || path.contains("trapdoor") || path.contains("door") || path.contains("ladder") || path.contains("scaffolding") || path.contains("rail");
    }

    private static boolean isCustomLiquid(BlockState state, Block block, Level level, BlockPos pos) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        boolean inConfig = id != null && SoundAttractConfig.CUSTOM_LIQUID_BLOCKS_CACHE.contains(id);
        boolean enableDataDriven = (Boolean)SoundAttractConfig.COMMON.enableDataDriven.get();
        boolean inTag = false;
        if (enableDataDriven) {
            try {
                inTag = state.m_204336_(DataDrivenTags.MUFFLING_LIQUID);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!enableDataDriven) {
            return inConfig;
        }
        String priority = (String)SoundAttractConfig.COMMON.datapackPriority.get();
        boolean datapackOverConfig = "datapack_over_config".equalsIgnoreCase(priority);
        if (datapackOverConfig) {
            return inTag || inConfig;
        }
        return inConfig || inTag;
    }

    public static SoundRecord findNearestSound(Mob mob, Level level, BlockPos mobPos, Vec3 mobEyePos) {
        return SoundTracker.findNearestSound(mob, level, mobPos, mobEyePos, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SoundRecord findNearestSound(Mob mob, Level level, BlockPos mobPos, Vec3 eyePos, @Nullable String currentTargetSoundId) {
        double bestSoundEffectiveWeight;
        double bestSoundEffectiveRange;
        SoundSnapshot bestSound;
        block49: {
            int i;
            double noveltyBonus;
            String dimensionKey;
            List<SoundRecord> nearbySounds;
            block48: {
                long asyncTtl;
                Long when;
                if (mob == null) return null;
                if (level == null) return null;
                if (mobPos == null) {
                    return null;
                }
                readLock.lock();
                try {
                    String asyncBestId = ASYNC_BEST_SOUND_BY_MOB.get(mob.m_20148_());
                    when = ASYNC_RESULT_GAME_TIME.get(mob.m_20148_());
                    asyncTtl = ((Integer)SoundAttractConfig.COMMON.asyncResultTtlTicks.get()).intValue();
                    if (asyncBestId != null && when != null && level.m_46467_() - when <= asyncTtl) {
                        SoundRecord asyncPick = SOUND_RECORDS_BY_ID.get(asyncBestId);
                        if (asyncPick != null && asyncPick.pos != null) {
                            Double asyncRange = ASYNC_BEST_SOUND_RANGE.get(mob.m_20148_());
                            Double asyncWeight = ASYNC_BEST_SOUND_WEIGHT.get(mob.m_20148_());
                            double effectiveRange = asyncRange != null ? asyncRange : asyncPick.range;
                            double distanceSq = asyncPick.pos.m_123331_((Vec3i)mobPos);
                            if (distanceSq <= effectiveRange * effectiveRange) {
                                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                                    SoundAttractMod.LOGGER.info("[findNearest] using async-picked sound {} at {}", (Object)asyncBestId, (Object)asyncPick.pos);
                                }
                                double effectiveWeight = asyncWeight != null ? asyncWeight : asyncPick.weight;
                                SoundRecord soundRecord = new SoundRecord(asyncPick.sound, asyncPick.soundId, asyncPick.pos, asyncPick.ticksRemaining, asyncPick.dimensionKey, effectiveRange, effectiveWeight);
                                readLock.unlock();
                                return soundRecord;
                            }
                        }
                        break block48;
                    }
                }
                catch (Throwable t) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.error("[findNearest] reading async result failed, falling back to sync", t);
                    }
                    break block48;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                {
                    if (when == null || level.m_46467_() - when <= asyncTtl) break block48;
                    ASYNC_BEST_SOUND_BY_MOB.remove(mob.m_20148_());
                    ASYNC_BEST_SOUND_RANGE.remove(mob.m_20148_());
                    ASYNC_BEST_SOUND_WEIGHT.remove(mob.m_20148_());
                    ASYNC_MUFFLED_BY_MOB.remove(mob.m_20148_());
                }
            }
            if ((nearbySounds = SoundTracker.getNearbySounds(dimensionKey = level.m_46472_().m_135782_().toString(), mobPos)).isEmpty()) {
                return null;
            }
            ArrayList<SoundSnapshot> snapshotSounds = new ArrayList<SoundSnapshot>(nearbySounds.size());
            for (SoundRecord r : nearbySounds) {
                if (r == null || r.pos == null) continue;
                snapshotSounds.add(new SoundSnapshot(r.sound, r.soundId, r.pos, r.ticksRemaining, r.dimensionKey, r.range, r.weight));
            }
            SoundTracker.drainAsyncSoundScores(level);
            if (snapshotSounds.isEmpty()) {
                return null;
            }
            MobProfile profile = SoundAttractConfig.getMatchingProfile(mob);
            bestSound = null;
            double highestWeight = -1.0;
            double closestDistSqr = Double.MAX_VALUE;
            bestSoundEffectiveRange = 0.0;
            bestSoundEffectiveWeight = 0.0;
            double noveltyBonusValue = (Double)SoundAttractConfig.COMMON.soundNoveltyBonusWeight.get();
            int noveltyTicks = (Integer)SoundAttractConfig.COMMON.soundNoveltyTimeTicks.get();
            int maxLifetime = (Integer)SoundAttractConfig.COMMON.soundLifetimeTicks.get();
            ArrayList<WorkerScheduler.SoundCandidate> asyncCandidates = new ArrayList<WorkerScheduler.SoundCandidate>(Math.min(snapshotSounds.size(), 64));
            HashMap<String, SoundSnapshot> candidateRecordById = new HashMap<String, SoundSnapshot>(Math.min(snapshotSounds.size(), 128));
            SoundSnapshot[] shortlist = new SoundSnapshot[24];
            double[] shortlistRange = new double[24];
            double[] shortlistWeight = new double[24];
            double[] shortlistNovelty = new double[24];
            double[] shortlistScore = new double[24];
            double[] shortlistDistSqr = new double[24];
            int shortlistCount = 0;
            for (SoundSnapshot r : snapshotSounds) {
                boolean better;
                double rangeSqrQuick;
                double distSqr;
                Optional<SoundOverride> ov;
                String soundIdStr = r.soundId;
                ResourceLocation rl = SoundTracker.extractBaseSoundLocation(soundIdStr);
                String integrationMeta = SoundTracker.extractIntegrationMetadata(soundIdStr);
                if (!SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.isEmpty() && (rl == null || !SoundAttractConfig.SOUND_ID_WHITELIST_CACHE.contains(rl))) continue;
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[findNearest] considering {} (meta={})", (Object)rl, (Object)integrationMeta);
                }
                double effectiveInitialRange = r.range;
                double effectiveInitialWeight = r.weight;
                if (profile != null && soundIdStr != null && (ov = profile.getSoundOverride(rl)).isPresent()) {
                    effectiveInitialRange = ov.get().getRange();
                    effectiveInitialWeight = ov.get().getWeight();
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[findNearest] initial {}: range={}, weight={}", new Object[]{rl, effectiveInitialRange, effectiveInitialWeight});
                }
                if ((distSqr = mobPos.m_123331_((Vec3i)r.pos)) > (rangeSqrQuick = effectiveInitialRange * effectiveInitialRange)) continue;
                noveltyBonus = 0.0;
                if (r.ticksRemaining > maxLifetime - noveltyTicks) {
                    noveltyBonus = noveltyBonusValue;
                }
                double approxScore = effectiveInitialWeight + noveltyBonus;
                if (shortlistCount < 24) {
                    shortlist[shortlistCount] = r;
                    shortlistRange[shortlistCount] = effectiveInitialRange;
                    shortlistWeight[shortlistCount] = effectiveInitialWeight;
                    shortlistNovelty[shortlistCount] = noveltyBonus;
                    shortlistScore[shortlistCount] = approxScore;
                    shortlistDistSqr[shortlistCount] = distSqr;
                    ++shortlistCount;
                } else {
                    int worstIdx = 0;
                    double worstScore = shortlistScore[0];
                    double worstDist = shortlistDistSqr[0];
                    for (int i2 = 1; i2 < shortlistCount; ++i2) {
                        double sc = shortlistScore[i2];
                        if (!(sc < worstScore) && (!(Math.abs(sc - worstScore) < 0.001) || !(shortlistDistSqr[i2] > worstDist))) continue;
                        worstIdx = i2;
                        worstScore = sc;
                        worstDist = shortlistDistSqr[i2];
                    }
                    if (approxScore > worstScore || Math.abs(approxScore - worstScore) < 0.001 && distSqr < worstDist) {
                        shortlist[worstIdx] = r;
                        shortlistRange[worstIdx] = effectiveInitialRange;
                        shortlistWeight[worstIdx] = effectiveInitialWeight;
                        shortlistNovelty[worstIdx] = noveltyBonus;
                        shortlistScore[worstIdx] = approxScore;
                        shortlistDistSqr[worstIdx] = distSqr;
                    }
                }
                if (soundIdStr == null) continue;
                long ageTicks = Math.max(0L, (long)(maxLifetime - r.ticksRemaining));
                long occurredAt = Math.max(0L, level.m_46467_() - ageTicks);
                WorkerScheduler.SoundCandidate cand = new WorkerScheduler.SoundCandidate(soundIdStr, (double)r.pos.m_123341_() + 0.5, (double)r.pos.m_123342_() + 0.5, (double)r.pos.m_123343_() + 0.5, occurredAt, effectiveInitialRange, effectiveInitialWeight, 1.0);
                asyncCandidates.add(cand);
                SoundSnapshot newRec = new SoundSnapshot(r.sound, r.soundId, r.pos, r.ticksRemaining, r.dimensionKey, effectiveInitialRange, effectiveInitialWeight);
                SoundSnapshot prev = (SoundSnapshot)candidateRecordById.get(soundIdStr);
                if (prev == null) {
                    candidateRecordById.put(soundIdStr, newRec);
                    continue;
                }
                boolean bl = better = newRec.weight > prev.weight;
                if (!better && Math.abs(newRec.weight - prev.weight) < 1.0E-6) {
                    double prevDistSq;
                    double newDistSq = newRec.pos.m_123331_((Vec3i)mobPos);
                    boolean bl2 = better = newDistSq < (prevDistSq = prev.pos.m_123331_((Vec3i)mobPos));
                }
                if (!better) continue;
                candidateRecordById.put(soundIdStr, newRec);
            }
            int MAX_ASYNC_CANDIDATES = 64;
            ArrayList<SoundSnapshot> asyncFiltered = new ArrayList<SoundSnapshot>();
            if (!candidateRecordById.isEmpty()) {
                ArrayList uniques = new ArrayList(candidateRecordById.values());
                uniques.sort((a, b) -> {
                    double aNovelty;
                    double aScore;
                    double bNovelty = b.ticksRemaining > maxLifetime - noveltyTicks ? noveltyBonusValue : 0.0;
                    double bScore = b.weight + bNovelty;
                    int cmp = Double.compare(bScore, aScore = a.weight + (aNovelty = a.ticksRemaining > maxLifetime - noveltyTicks ? noveltyBonusValue : 0.0));
                    if (cmp != 0) {
                        return cmp;
                    }
                    double aDist = mobPos.m_123331_((Vec3i)a.pos);
                    double bDist = mobPos.m_123331_((Vec3i)b.pos);
                    return Double.compare(aDist, bDist);
                });
                long now = level.m_46467_();
                int limit = Math.min(64, uniques.size());
                for (i = 0; i < limit; ++i) {
                    SoundSnapshot rec = (SoundSnapshot)uniques.get(i);
                    asyncFiltered.add(rec);
                }
            }
            HashMap<String, MuffledResult> muffledBySoundId = new HashMap<String, MuffledResult>();
            HashMap<String, Long> muffledPosBySoundId = new HashMap<String, Long>();
            ArrayList<WorkerScheduler.SoundCandidate> asyncScoringCandidates = new ArrayList<WorkerScheduler.SoundCandidate>(asyncFiltered.size());
            if (!asyncFiltered.isEmpty()) {
                long now = level.m_46467_();
                for (SoundSnapshot rec : asyncFiltered) {
                    String soundIdStr = rec.soundId;
                    double[] muffled = SoundTracker.applyBlockMuffling(level, rec.pos, mobPos, rec.range, rec.weight, soundIdStr != null ? soundIdStr : "unknown");
                    double muffledRange = muffled[0];
                    double muffledWeight = muffled[1];
                    if (soundIdStr != null) {
                        muffledBySoundId.put(soundIdStr, new MuffledResult(muffledRange, muffledWeight));
                        muffledPosBySoundId.put(soundIdStr, rec.pos.m_121878_());
                    }
                    long ageTicks = Math.max(0L, (long)(maxLifetime - rec.ticksRemaining));
                    long occurredAt = Math.max(0L, now - ageTicks);
                    asyncScoringCandidates.add(new WorkerScheduler.SoundCandidate(soundIdStr, (double)rec.pos.m_123341_() + 0.5, (double)rec.pos.m_123342_() + 0.5, (double)rec.pos.m_123343_() + 0.5, occurredAt, muffledRange, muffledWeight, 1.0));
                }
            }
            int[] order = new int[shortlistCount];
            for (i = 0; i < shortlistCount; ++i) {
                order[i] = i;
            }
            for (i = 0; i < shortlistCount - 1; ++i) {
                int best = i;
                for (int j = i + 1; j < shortlistCount; ++j) {
                    double bestDist;
                    double candidateDist;
                    double candidateScore = shortlistScore[order[j]];
                    double bestScore = shortlistScore[order[best]];
                    if (candidateScore > bestScore) {
                        best = j;
                        continue;
                    }
                    if (!(Math.abs(candidateScore - bestScore) < 0.001) || !((candidateDist = shortlistDistSqr[order[j]]) < (bestDist = shortlistDistSqr[order[best]]))) continue;
                    best = j;
                }
                int tmp = order[i];
                order[i] = order[best];
                order[best] = tmp;
            }
            for (i = 0; i < shortlistCount; ++i) {
                double finalComparisonWeight;
                double muffledWeight;
                double muffledRange;
                Long cachedPos;
                int idx = order[i];
                SoundSnapshot r = shortlist[idx];
                double initialRange = shortlistRange[idx];
                double initialWeight = shortlistWeight[idx];
                noveltyBonus = shortlistNovelty[idx];
                if (highestWeight >= 0.0 && initialWeight + noveltyBonus <= highestWeight - 1.0E-6) continue;
                String soundIdStr = r.soundId;
                MuffledResult cachedMuffled = soundIdStr != null ? (MuffledResult)muffledBySoundId.get(soundIdStr) : null;
                Long l = cachedPos = soundIdStr != null ? (Long)muffledPosBySoundId.get(soundIdStr) : null;
                if (cachedMuffled != null && cachedPos != null && cachedPos.longValue() == r.pos.m_121878_()) {
                    muffledRange = cachedMuffled.range();
                    muffledWeight = cachedMuffled.weight();
                } else {
                    double[] muffled = SoundTracker.applyBlockMuffling(level, r.pos, mobPos, initialRange, initialWeight, soundIdStr != null ? soundIdStr : "unknown");
                    muffledRange = muffled[0];
                    muffledWeight = muffled[1];
                }
                double distSqr = mobPos.m_123331_((Vec3i)r.pos);
                double rangeSqr = muffledRange * muffledRange;
                if (distSqr > rangeSqr || !((finalComparisonWeight = muffledWeight + noveltyBonus) > highestWeight) && (!(Math.abs(finalComparisonWeight - highestWeight) < 0.001) || !(distSqr < closestDistSqr))) continue;
                highestWeight = finalComparisonWeight;
                closestDistSqr = distSqr;
                bestSound = r;
                bestSoundEffectiveRange = muffledRange;
                bestSoundEffectiveWeight = finalComparisonWeight;
            }
            ArrayList<WorkerScheduler.SoundCandidate> toSubmit = !asyncScoringCandidates.isEmpty() ? asyncScoringCandidates : asyncCandidates;
            int candidateHash = 1;
            for (WorkerScheduler.SoundCandidate c : toSubmit) {
                int h = 17;
                h = 31 * h + (c.soundId == null ? 0 : c.soundId.hashCode());
                h = 31 * h + (int)Math.round(c.x * 10.0);
                h = 31 * h + (int)Math.round(c.z * 10.0);
                h = 31 * h + (int)Math.round(c.range * 100.0);
                h = 31 * h + (int)Math.round(c.weight * 100.0);
                candidateHash = 31 * candidateHash + h;
            }
            if (currentTargetSoundId != null) {
                candidateHash = 31 * candidateHash + currentTargetSoundId.hashCode();
            }
            try {
                boolean unchanged;
                if (asyncCandidates.isEmpty()) break block49;
                long now = level.m_46467_();
                Long lastSubmit = LAST_SUBMIT_GAME_TIME.get(mob.m_20148_());
                Integer lastHash = LAST_CANDIDATE_HASH.get(mob.m_20148_());
                Long lastAsyncWhen = ASYNC_RESULT_GAME_TIME.get(mob.m_20148_());
                long asyncTtl = ((Integer)SoundAttractConfig.COMMON.asyncResultTtlTicks.get()).intValue();
                long submitCooldown = ((Integer)SoundAttractConfig.COMMON.soundScoringSubmitCooldownTicks.get()).intValue();
                boolean hasFreshAsync = lastAsyncWhen != null && now - lastAsyncWhen <= asyncTtl;
                boolean withinCooldown = lastSubmit != null && now - lastSubmit < submitCooldown;
                boolean bl = unchanged = lastHash != null && lastHash == candidateHash;
                if (withinCooldown && hasFreshAsync && unchanged) {
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                        SoundAttractMod.LOGGER.debug("[findNearest] skip submit for {} due to cooldown; last={} now={} hashUnchanged", new Object[]{mob.m_20148_(), lastSubmit, now});
                    }
                    break block49;
                }
                double switchRatio = (Double)SoundAttractConfig.COMMON.soundSwitchRatio.get();
                List<WorkerScheduler.SoundScoreRequest> batch = Collections.singletonList(new WorkerScheduler.SoundScoreRequest(mob.m_20148_(), (double)mobPos.m_123341_() + 0.5, (double)mobPos.m_123342_() + 0.5, (double)mobPos.m_123343_() + 0.5, level.m_46467_(), currentTargetSoundId, toSubmit, switchRatio, noveltyBonusValue, noveltyTicks));
                if (!muffledBySoundId.isEmpty()) {
                    ASYNC_MUFFLED_BY_MOB.put(mob.m_20148_(), muffledBySoundId);
                } else {
                    ASYNC_MUFFLED_BY_MOB.remove(mob.m_20148_());
                }
                WorkSchedulerManager.get().submitSoundScore(batch);
                LAST_SUBMIT_GAME_TIME.put(mob.m_20148_(), now);
                LAST_CANDIDATE_HASH.put(mob.m_20148_(), candidateHash);
            }
            catch (Throwable t) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block49;
                SoundAttractMod.LOGGER.error("[findNearest] submitSoundScore failed", t);
            }
        }
        if (bestSound == null) return null;
        if (bestSound.pos == null) {
            return null;
        }
        if ((Boolean)SoundAttractConfig.COMMON.debugLogging.get() == false) return new SoundRecord(bestSound.sound, bestSound.soundId, bestSound.pos, bestSound.ticksRemaining, bestSound.dimensionKey, bestSoundEffectiveRange, bestSoundEffectiveWeight);
        SoundAttractMod.LOGGER.info("[findNearest] final pick {} at {} with range={} weight={}", new Object[]{bestSound.soundId, bestSound.pos, bestSoundEffectiveRange, bestSoundEffectiveWeight});
        return new SoundRecord(bestSound.sound, bestSound.soundId, bestSound.pos, bestSound.ticksRemaining, bestSound.dimensionKey, bestSoundEffectiveRange, bestSoundEffectiveWeight);
    }

    private record GridKey3D(int x, int y, int z) {
    }

    public static class SoundRecord {
        public final SoundEvent sound;
        public final String soundId;
        public final BlockPos pos;
        public int ticksRemaining;
        public final String dimensionKey;
        public final double range;
        public final double weight;

        public SoundRecord(SoundEvent sound, String soundId, BlockPos pos, int lifetime, String dimensionKey, double range, double weight) {
            this.sound = sound;
            this.soundId = soundId;
            this.pos = pos;
            this.ticksRemaining = lifetime;
            this.dimensionKey = dimensionKey;
            this.range = range;
            this.weight = weight;
        }

        public SoundRecord(SoundEvent sound, BlockPos pos, int lifetime, String dimensionKey, double range, double weight) {
            this(sound, sound != null && sound.m_11660_() != null ? sound.m_11660_().toString() : null, pos, lifetime, dimensionKey, range, weight);
        }
    }

    public static class VirtualSoundRecord
    extends SoundRecord {
        public final UUID sourcePlayer;
        public final String animationClass;

        public VirtualSoundRecord(String soundId, BlockPos pos, int lifetime, String dimensionKey, double range, double weight, UUID sourcePlayer, String animationClass) {
            super(null, soundId, pos, lifetime, dimensionKey, range, weight);
            this.sourcePlayer = sourcePlayer;
            this.animationClass = animationClass;
        }
    }

    private record MuffledResult(double range, double weight) {
    }

    private static class RaycastCacheKey {
        public final BlockPos mobPos;
        public final BlockPos soundPos;
        public final String soundId;
        public final String dimensionKey;

        public RaycastCacheKey(BlockPos mobPos, BlockPos soundPos, String soundId, String dimensionKey) {
            this.mobPos = mobPos;
            this.soundPos = soundPos;
            this.soundId = soundId;
            this.dimensionKey = dimensionKey;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RaycastCacheKey)) {
                return false;
            }
            RaycastCacheKey other = (RaycastCacheKey)o;
            return Objects.equals(this.mobPos, other.mobPos) && Objects.equals(this.soundPos, other.soundPos) && Objects.equals(this.soundId, other.soundId) && Objects.equals(this.dimensionKey, other.dimensionKey);
        }

        public int hashCode() {
            return Objects.hash(this.mobPos, this.soundPos, this.soundId, this.dimensionKey);
        }
    }

    private static final class RaycastEntry {
        final double[] result;
        final long gameTime;

        RaycastEntry(double[] result, long gameTime) {
            this.result = result;
            this.gameTime = gameTime;
        }
    }

    private static final class SoundSnapshot {
        final SoundEvent sound;
        final String soundId;
        final BlockPos pos;
        final int ticksRemaining;
        final String dimensionKey;
        final double range;
        final double weight;

        SoundSnapshot(SoundEvent sound, String soundId, BlockPos pos, int ticksRemaining, String dimensionKey, double range, double weight) {
            this.sound = sound;
            this.soundId = soundId;
            this.pos = pos;
            this.ticksRemaining = ticksRemaining;
            this.dimensionKey = dimensionKey;
            this.range = range;
            this.weight = weight;
        }
    }
}

