/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.runtime;

import com.example.soundattract.config.SoundAttractConfig;

public class DynamicScanCooldownManager {
    public static int currentScanCooldownTicks = 20;
    private static final int MIN_COOLDOWN = 10;
    private static final int MAX_COOLDOWN = 120;
    private static long lastCheckTime = 0L;
    private static long lastTickCount = 0L;

    private static double map(double value, double fromLow, double fromHigh, double toLow, double toHigh) {
        value = Math.max(fromLow, Math.min(value, fromHigh));
        return toLow + (value - fromLow) * (toHigh - toLow) / (fromHigh - fromLow);
    }

    public static void update(long totalTickCount, int mobCount) {
        double ticksPerMob = (Double)SoundAttractConfig.COMMON.cooldownTicksPerMob.get();
        double baseCooldown = 10.0 + (double)mobCount * ticksPerMob;
        double tpsMultiplier = 1.0;
        long now = System.currentTimeMillis();
        if (lastCheckTime > 0L) {
            long ticksElapsed = totalTickCount - lastTickCount;
            long timeElapsedMs = now - lastCheckTime;
            if (ticksElapsed > 0L && timeElapsedMs > 0L) {
                double tps = (double)ticksElapsed * 1000.0 / (double)timeElapsedMs;
                double lowTpsThreshold = (Double)SoundAttractConfig.COMMON.minTpsForScanCooldown.get();
                double highTpsThreshold = (Double)SoundAttractConfig.COMMON.maxTpsForScanCooldown.get();
                double maxMultiplier = 2.0;
                double minMultiplier = 0.8;
                tpsMultiplier = tps < highTpsThreshold ? DynamicScanCooldownManager.map(tps, lowTpsThreshold, highTpsThreshold, maxMultiplier, minMultiplier) : minMultiplier;
            }
        }
        lastCheckTime = now;
        lastTickCount = totalTickCount;
        double targetCooldown = baseCooldown * tpsMultiplier;
        int clampedTarget = (int)Math.round(Math.max(10.0, Math.min(targetCooldown, 120.0)));
        if (currentScanCooldownTicks < clampedTarget) {
            ++currentScanCooldownTicks;
        } else if (currentScanCooldownTicks > clampedTarget) {
            --currentScanCooldownTicks;
        }
    }

    public static boolean shouldScanThisTick(long mobId, long totalTickCount) {
        int effectiveCooldown = Math.max(1, currentScanCooldownTicks);
        return (mobId + totalTickCount) % (long)effectiveCooldown == 0L;
    }
}

