/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.reload;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.lang3.tuple.Pair;

public class TaczGunsReloadListener
extends SimpleJsonResourceReloadListener {
    public TaczGunsReloadListener() {
        super(new Gson(), "guns/tacz");
    }

    protected void apply(Map<ResourceLocation, JsonElement> elements, ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, Pair> guns = new HashMap<ResourceLocation, Pair>();
        HashMap<String, Double> attachments = new HashMap<String, Double>();
        HashMap<ResourceLocation, Double> muzzle = new HashMap<ResourceLocation, Double>();
        for (Map.Entry<ResourceLocation, JsonElement> entry : elements.entrySet()) {
            double db;
            String idStr;
            ResourceLocation id;
            JsonArray arr;
            boolean replace;
            JsonElement element = entry.getValue();
            if (!element.isJsonObject()) continue;
            JsonObject root = element.getAsJsonObject();
            boolean bl = replace = root.has("replace") && root.get("replace").isJsonPrimitive() && root.get("replace").getAsJsonPrimitive().isBoolean() && root.get("replace").getAsBoolean();
            if (replace) {
                guns.clear();
                attachments.clear();
                muzzle.clear();
            }
            if (root.has("guns") && root.get("guns").isJsonArray()) {
                arr = root.getAsJsonArray("guns");
                for (JsonElement gunEl : arr) {
                    JsonObject gObj;
                    if (!gunEl.isJsonObject() || !(gObj = gunEl.getAsJsonObject()).has("item") || !gObj.get("item").isJsonPrimitive() || (id = ResourceLocation.m_135820_((String)(idStr = gObj.get("item").getAsString().trim()))) == null || !gObj.has("db")) continue;
                    try {
                        db = gObj.get("db").getAsDouble();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    double weight = gObj.has("weight") ? gObj.get("weight").getAsDouble() : db / 10.0;
                    guns.put(id, Pair.of((Object)db, (Object)weight));
                }
            }
            if (root.has("attachments") && root.get("attachments").isJsonArray()) {
                arr = root.getAsJsonArray("attachments");
                for (JsonElement attEl : arr) {
                    JsonObject aObj;
                    if (!attEl.isJsonObject() || !(aObj = attEl.getAsJsonObject()).has("item") || !aObj.get("item").isJsonPrimitive() || (id = ResourceLocation.m_135820_((String)(idStr = aObj.get("item").getAsString().trim()))) == null || !aObj.has("db")) continue;
                    try {
                        db = aObj.get("db").getAsDouble();
                    }
                    catch (Exception e) {
                        continue;
                    }
                    attachments.put(id.toString(), db);
                }
            }
            if (!root.has("muzzle_flash") || !root.get("muzzle_flash").isJsonArray()) continue;
            arr = root.getAsJsonArray("muzzle_flash");
            for (JsonElement mfEl : arr) {
                double reduction;
                JsonObject mObj;
                if (!mfEl.isJsonObject() || !(mObj = mfEl.getAsJsonObject()).has("item") || !mObj.get("item").isJsonPrimitive() || (id = ResourceLocation.m_135820_((String)(idStr = mObj.get("item").getAsString().trim()))) == null || !mObj.has("reduction")) continue;
                try {
                    reduction = mObj.get("reduction").getAsDouble();
                }
                catch (Exception e) {
                    continue;
                }
                muzzle.put(id, reduction);
            }
        }
        SoundAttractConfig.DP_TACZ_GUN_SHOOT_DB_CACHE.clear();
        SoundAttractConfig.DP_TACZ_GUN_SHOOT_DB_CACHE.putAll(guns);
        SoundAttractConfig.DP_TACZ_ATTACHMENT_REDUCTION_DB_CACHE.clear();
        SoundAttractConfig.DP_TACZ_ATTACHMENT_REDUCTION_DB_CACHE.putAll(attachments);
        SoundAttractConfig.DP_TACZ_MUZZLE_FLASH_REDUCTION_CACHE.clear();
        SoundAttractConfig.DP_TACZ_MUZZLE_FLASH_REDUCTION_CACHE.putAll(muzzle);
        try {
            SoundAttractConfig.bakeConfig();
        }
        catch (Throwable t) {
            SoundAttractMod.LOGGER.warn("[TaczGunsReloadListener] Failed to re-bake config after datapack reload", t);
        }
    }
}

