/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.quantified;

import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.worker.LocalWorkScheduler;
import com.example.soundattract.worker.SoundAttractWorkScheduler;
import com.example.soundattract.worker.WorkerComputations;
import com.example.soundattract.worker.WorkerScheduler;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;

public final class QuantifiedWorkScheduler
implements SoundAttractWorkScheduler {
    private final BlockingQueue<WorkerScheduler.GroupComputeResult> groupResults = new LinkedBlockingQueue<WorkerScheduler.GroupComputeResult>();
    private final BlockingQueue<WorkerScheduler.SoundScoreResult> soundResults = new LinkedBlockingQueue<WorkerScheduler.SoundScoreResult>();
    private final LocalWorkScheduler fallback = new LocalWorkScheduler();
    private final Method register;
    private final Method submit;

    public QuantifiedWorkScheduler() {
        try {
            Class<?> api = Class.forName("org.admany.quantified.api.QuantifiedAPI");
            this.register = api.getMethod("register", String.class);
            this.submit = api.getMethod("submit", Class.forName("org.admany.quantified.api.model.QuantifiedTask$Builder"));
            this.register.invoke(null, "soundattract");
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize QuantifiedWorkScheduler", e);
        }
    }

    @Override
    public Future<?> submitGroupCompute(List<WorkerScheduler.MobSnapshot> mobs, WorkerScheduler.ConfigSnapshot cfg, ResourceLocation dimension) {
        long deadlineMs = this.computeDeadlineMs();
        Duration timeout = this.computeTimeout();
        CompletableFuture<?> future = this.submitFuture("soundattract_group_compute", () -> WorkerComputations.computeGroups(mobs, cfg, deadlineMs, dimension), timeout);
        return future.handle((result, throwable) -> {
            WorkerScheduler.GroupComputeResult r;
            if (throwable != null || result == null) {
                return this.fallback.submitGroupCompute(mobs, cfg, dimension);
            }
            if (result instanceof WorkerScheduler.GroupComputeResult && (r = (WorkerScheduler.GroupComputeResult)result).dimension() != null) {
                this.groupResults.offer(r);
            }
            return null;
        });
    }

    @Override
    public Future<?> submitSoundScore(List<WorkerScheduler.SoundScoreRequest> batch) {
        Duration timeout;
        if (batch == null || batch.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        long deadlineMs = this.computeDeadlineMs();
        CompletableFuture<List<WorkerScheduler.SoundScoreResult>> parallel = ParallelComputeBridge.trySubmitSoundScores(batch, deadlineMs, timeout = this.computeTimeout());
        CompletableFuture<List<WorkerScheduler.SoundScoreResult>> future = parallel != null ? parallel : this.submitFuture("soundattract_sound_score", () -> WorkerComputations.computeSoundScores(batch, deadlineMs), timeout);
        return future.handle((result, throwable) -> {
            if (throwable != null) {
                return this.fallback.submitSoundScore(batch);
            }
            if (result == null) {
                return this.fallback.submitSoundScore(batch);
            }
            if (result instanceof List) {
                List list = (List)result;
                for (Object o : list) {
                    if (!(o instanceof WorkerScheduler.SoundScoreResult)) continue;
                    WorkerScheduler.SoundScoreResult r = (WorkerScheduler.SoundScoreResult)o;
                    this.soundResults.offer(r);
                }
            }
            return null;
        });
    }

    @Override
    public List<WorkerScheduler.GroupComputeResult> drainGroupResults() {
        ArrayList<WorkerScheduler.GroupComputeResult> out = new ArrayList<WorkerScheduler.GroupComputeResult>();
        this.groupResults.drainTo(out);
        out.addAll(WorkerScheduler.drainGroupResults());
        return out;
    }

    @Override
    public List<WorkerScheduler.SoundScoreResult> drainSoundScoreResults() {
        ArrayList<WorkerScheduler.SoundScoreResult> out = new ArrayList<WorkerScheduler.SoundScoreResult>();
        this.soundResults.drainTo(out);
        out.addAll(WorkerScheduler.drainSoundScoreResults());
        return out;
    }

    private CompletableFuture<?> submitFuture(String taskName, Supplier<?> work, Duration timeout) {
        try {
            Class<?> taskClass = Class.forName("org.admany.quantified.api.model.QuantifiedTask");
            Object builder = taskClass.getMethod("builder", String.class, String.class, Supplier.class).invoke(null, "soundattract", taskName, work);
            builder.getClass().getMethod("priorityBackground", new Class[0]).invoke(builder, new Object[0]);
            builder.getClass().getMethod("threadSafe", Boolean.TYPE).invoke(builder, true);
            if (timeout != null) {
                builder.getClass().getMethod("timeout", Duration.class).invoke(builder, timeout);
            }
            return (CompletableFuture)this.submit.invoke(null, builder);
        }
        catch (Throwable t) {
            CompletableFuture failed = new CompletableFuture();
            failed.completeExceptionally(t);
            return failed;
        }
    }

    private long computeDeadlineMs() {
        long computed = System.currentTimeMillis() + 10L;
        try {
            Integer budget = (Integer)SoundAttractConfig.COMMON.workerTaskBudgetMs.get();
            if (budget != null) {
                long cfgBudget = budget.longValue();
                computed = System.currentTimeMillis() + Math.max(5L, cfgBudget);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return computed;
    }

    private Duration computeTimeout() {
        try {
            Integer budget = (Integer)SoundAttractConfig.COMMON.workerTaskBudgetMs.get();
            if (budget != null) {
                long cfgBudget = Math.max(5L, budget.longValue());
                return Duration.ofMillis(cfgBudget);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static final class ParallelComputeBridge {
        private static final Object INIT_LOCK = new Object();
        private static boolean initialized = false;
        private static Method parallelBuilderFactory;
        private static Method slicesMethod;
        private static Method sliceExecutorMethod;
        private static Method maxParallelismMethod;
        private static Method failurePolicyMethod;
        private static Object failurePolicyBestEffort;
        private static Method submitParallelMethod;

        private ParallelComputeBridge() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean ensureInit() {
            if (initialized) {
                return submitParallelMethod != null;
            }
            Object object = INIT_LOCK;
            synchronized (object) {
                if (initialized) {
                    return submitParallelMethod != null;
                }
                try {
                    Class<?> parallelComputeClass = Class.forName("org.admany.quantified.api.parallel.ParallelCompute");
                    parallelBuilderFactory = parallelComputeClass.getMethod("builder", String.class, String.class, Long.TYPE);
                    Class<?> builderClass = Class.forName("org.admany.quantified.api.parallel.ParallelCompute$Builder");
                    slicesMethod = builderClass.getMethod("slices", Supplier.class);
                    sliceExecutorMethod = builderClass.getMethod("sliceExecutor", Function.class);
                    maxParallelismMethod = builderClass.getMethod("maxParallelism", Integer.TYPE);
                    try {
                        Class<?> failurePolicyClass = Class.forName("org.admany.quantified.core.common.parallel.policy.ParallelFailurePolicy");
                        failurePolicyBestEffort = Enum.valueOf(failurePolicyClass.asSubclass(Enum.class), "BEST_EFFORT");
                        failurePolicyMethod = builderClass.getMethod("failurePolicy", failurePolicyClass);
                    }
                    catch (Throwable ignored) {
                        failurePolicyBestEffort = null;
                        failurePolicyMethod = null;
                    }
                    submitParallelMethod = builderClass.getMethod("submit", new Class[0]);
                }
                catch (Throwable t) {
                    submitParallelMethod = null;
                }
                initialized = true;
                return submitParallelMethod != null;
            }
        }

        private static CompletableFuture<List<WorkerScheduler.SoundScoreResult>> trySubmitSoundScores(List<WorkerScheduler.SoundScoreRequest> batch, long deadlineMs, Duration timeout) {
            if (batch == null || batch.isEmpty()) {
                return CompletableFuture.completedFuture(Collections.emptyList());
            }
            if (!ParallelComputeBridge.ensureInit()) {
                return null;
            }
            try {
                CompletableFuture future;
                long taskKey = System.nanoTime();
                Object builder = parallelBuilderFactory.invoke(null, "soundattract", "soundattract_sound_score_parallel", taskKey);
                Supplier<List> supplier = () -> batch;
                slicesMethod.invoke(builder, supplier);
                Function<WorkerScheduler.SoundScoreRequest, WorkerScheduler.SoundScoreResult> scorer = req -> {
                    try {
                        return WorkerComputations.computeSoundScore(req, deadlineMs);
                    }
                    catch (Throwable t) {
                        return new WorkerScheduler.SoundScoreResult(req == null ? null : req.mobUuid, null, 0.0);
                    }
                };
                sliceExecutorMethod.invoke(builder, scorer);
                int maxParallelism = 0;
                try {
                    maxParallelism = (Integer)SoundAttractConfig.COMMON.workerThreads.get();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (maxParallelism > 0) {
                    maxParallelismMethod.invoke(builder, maxParallelism);
                }
                if (failurePolicyMethod != null && failurePolicyBestEffort != null) {
                    failurePolicyMethod.invoke(builder, failurePolicyBestEffort);
                }
                if ((future = (CompletableFuture)submitParallelMethod.invoke(builder, new Object[0])) == null) {
                    return null;
                }
                if (timeout != null) {
                    long ms = Math.max(1L, timeout.toMillis());
                    return future.orTimeout(ms, TimeUnit.MILLISECONDS);
                }
                return future;
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

