/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.quantified;

import com.example.soundattract.config.SoundAttractConfig;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.server.ServerLifecycleHooks;

public final class QuantifiedCacheCompat {
    private static final AtomicBoolean INIT_ATTEMPTED = new AtomicBoolean(false);
    private static volatile Object cacheManager;
    private static volatile long lastAppliedLimitMb;
    private static volatile long lastCleanupTick;

    private QuantifiedCacheCompat() {
    }

    public static boolean isUsable() {
        if (!ModList.get().isLoaded("quantified")) {
            return false;
        }
        try {
            if (!((Boolean)SoundAttractConfig.COMMON.enableQuantifiedIntegration.get()).booleanValue()) {
                return false;
            }
            if (!((Boolean)SoundAttractConfig.COMMON.enableQuantifiedCacheIntegration.get()).booleanValue()) {
                return false;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!QuantifiedCacheCompat.ensureInit()) {
            return false;
        }
        QuantifiedCacheCompat.configureCacheManager();
        return !QuantifiedCacheCompat.isMemoryPressureHigh();
    }

    public static <T> T getCached(String cacheName, String key, Supplier<T> loader, long ttlTicks, long maxSize) {
        return QuantifiedCacheCompat.getCachedInternal(cacheName, key, loader, ttlTicks, maxSize, false);
    }

    public static <T> T getCachedDisk(String cacheName, String key, Supplier<T> loader, long ttlTicks, long maxSize) {
        return QuantifiedCacheCompat.getCachedInternal(cacheName, key, loader, ttlTicks, maxSize, true);
    }

    private static <T> T getCachedInternal(String cacheName, String key, Supplier<T> loader, long ttlTicks, long maxSize, boolean useDisk) {
        long clampedMax;
        if (loader == null) {
            return null;
        }
        if (!QuantifiedCacheCompat.isUsable()) {
            return loader.get();
        }
        long clampedTtlTicks = Math.max(1L, ttlTicks);
        Duration ttl = Duration.ofMillis(clampedTtlTicks * QuantifiedCacheCompat.estimateMillisPerTick());
        T value = CacheBridge.invokeGetCached(cacheName, key, loader, ttl, clampedMax = Math.max(0L, maxSize), useDisk);
        if (value != null) {
            return value;
        }
        return loader.get();
    }

    private static boolean ensureInit() {
        if (cacheManager != null) {
            return true;
        }
        if (!INIT_ATTEMPTED.compareAndSet(false, true)) {
            return cacheManager != null;
        }
        cacheManager = CacheBridge.fetchManager();
        return cacheManager != null;
    }

    private static void configureCacheManager() {
        Object manager = cacheManager;
        if (manager == null) {
            return;
        }
        long limitMb = 0L;
        try {
            limitMb = ((Integer)SoundAttractConfig.COMMON.quantifiedCacheMemoryLimitMB.get()).intValue();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        limitMb = Math.max(0L, limitMb);
        if (limitMb != lastAppliedLimitMb && CacheBridge.setMemoryLimit(manager, limitMb)) {
            lastAppliedLimitMb = limitMb;
        }
        boolean triggerCleanup = true;
        try {
            triggerCleanup = (Boolean)SoundAttractConfig.COMMON.triggerQuantifiedCacheCleanupOnMemoryPressure.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!triggerCleanup) {
            return;
        }
        if (!CacheBridge.isMemoryPressureHigh(manager)) {
            return;
        }
        long tick = System.currentTimeMillis() / 50L;
        if (tick - lastCleanupTick < 20L) {
            return;
        }
        lastCleanupTick = tick;
        CacheBridge.triggerCleanup(manager);
    }

    private static boolean isMemoryPressureHigh() {
        boolean bypass = true;
        try {
            bypass = (Boolean)SoundAttractConfig.COMMON.disableQuantifiedCacheOnMemoryPressure.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!bypass) {
            return false;
        }
        Object manager = cacheManager;
        if (manager == null) {
            return false;
        }
        return CacheBridge.isMemoryPressureHigh(manager);
    }

    private static long estimateMillisPerTick() {
        long fallback = 50L;
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server == null) {
                return fallback;
            }
            float avg = server.m_129903_();
            if (Float.isNaN(avg) || avg <= 0.0f) {
                return fallback;
            }
            long ms = (long)avg;
            if (ms < 1L) {
                return fallback;
            }
            return Math.max(20L, Math.min(250L, ms));
        }
        catch (Throwable ignored) {
            return fallback;
        }
    }

    static {
        lastAppliedLimitMb = Long.MIN_VALUE;
        lastCleanupTick = Long.MIN_VALUE;
    }

    private static final class CacheBridge {
        private static final Object LOCK = new Object();
        private static boolean initialized = false;
        private static Class<?> apiClass;
        private static Class<?> managerInterface;
        private static Method registerMethod;
        private static Method getCacheManagerMethod;
        private static Method getCachedMethod;
        private static Method setMemoryLimitMethod;
        private static Method isMemoryPressureHighMethod;
        private static Method triggerCleanupMethod;

        private CacheBridge() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static boolean ensureInit() {
            if (initialized) {
                return getCacheManagerMethod != null;
            }
            Object object = LOCK;
            synchronized (object) {
                if (initialized) {
                    return getCacheManagerMethod != null;
                }
                try {
                    apiClass = Class.forName("org.admany.quantified.api.QuantifiedAPI");
                    managerInterface = Class.forName("org.admany.quantified.api.interfaces.ModCacheManager");
                    registerMethod = apiClass.getMethod("register", String.class);
                    getCacheManagerMethod = apiClass.getMethod("getCacheManager", new Class[0]);
                    getCachedMethod = apiClass.getMethod("getCached", String.class, String.class, Supplier.class, Duration.class, Long.TYPE, Boolean.TYPE);
                    setMemoryLimitMethod = managerInterface.getMethod("setMemoryLimitMB", Long.TYPE);
                    isMemoryPressureHighMethod = managerInterface.getMethod("isMemoryPressureHigh", new Class[0]);
                    triggerCleanupMethod = managerInterface.getMethod("triggerMemoryPressureCleanup", new Class[0]);
                }
                catch (Throwable t) {
                    getCacheManagerMethod = null;
                }
                initialized = true;
                return getCacheManagerMethod != null;
            }
        }

        private static Object fetchManager() {
            if (!CacheBridge.ensureInit()) {
                return null;
            }
            try {
                registerMethod.invoke(null, "soundattract");
                return getCacheManagerMethod.invoke(null, new Object[0]);
            }
            catch (Throwable ignored) {
                return null;
            }
        }

        private static <T> T invokeGetCached(String cacheName, String key, Supplier<T> loader, Duration ttl, long maxSize, boolean useDisk) {
            if (!CacheBridge.ensureInit()) {
                return null;
            }
            try {
                return (T)getCachedMethod.invoke(null, cacheName, key, loader, ttl, maxSize, useDisk);
            }
            catch (Throwable ignored) {
                return null;
            }
        }

        private static boolean setMemoryLimit(Object manager, long limitMb) {
            if (!CacheBridge.ensureInit()) {
                return false;
            }
            try {
                setMemoryLimitMethod.invoke(manager, limitMb);
                return true;
            }
            catch (Throwable ignored) {
                return false;
            }
        }

        private static boolean isMemoryPressureHigh(Object manager) {
            if (!CacheBridge.ensureInit()) {
                return false;
            }
            try {
                return (Boolean)isMemoryPressureHighMethod.invoke(manager, new Object[0]);
            }
            catch (Throwable ignored) {
                return false;
            }
        }

        private static void triggerCleanup(Object manager) {
            if (!CacheBridge.ensureInit()) {
                return;
            }
            try {
                triggerCleanupMethod.invoke(manager, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

