/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.mixin;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.FollowLeaderGoal;
import com.example.soundattract.ai.FollowerEdgeRelayGoal;
import com.example.soundattract.ai.LeaderAttractionGoal;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.SoundAttractionEvents;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"noppes.npcs.entity.EntityNPCInterface"}, remap=false)
public abstract class CustomNpcsUpdateTasksMixin {
    @Inject(method={"updateTasks()V"}, at={@At(value="TAIL")})
    private void soundattract$afterUpdateTasks(CallbackInfo ci) {
        block6: {
            if (SoundAttractConfig.COMMON == null || !((Boolean)SoundAttractConfig.COMMON.enableCustomNpcsIntegration.get()).booleanValue()) {
                return;
            }
            try {
                Mob mob = (Mob)this;
                if (mob.m_9236_() == null || mob.m_9236_().m_5776_()) {
                    return;
                }
                if (!SoundAttractionEvents.isCustomNpcsMob(mob)) {
                    return;
                }
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[CustomNPCs] updateTasks() completed, re-adding sound attraction goals for {}", (Object)mob.m_7755_().getString());
                }
                this.addCustomNpcsGoalsAfterUpdate(mob);
            }
            catch (Throwable t) {
                if (!((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) break block6;
                SoundAttractMod.LOGGER.error("[CustomNPCs] Error in updateTasks mixin", t);
            }
        }
    }

    private void addCustomNpcsGoalsAfterUpdate(final Mob mob) {
        double moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
        int attractionPriority = 0;
        boolean hasAttractionGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof AttractionGoal);
        boolean hasLeaderAttractionGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof LeaderAttractionGoal);
        boolean hasFollowerEdgeRelayGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof FollowerEdgeRelayGoal);
        boolean hasFollowLeaderGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof FollowLeaderGoal);
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        if (smartEdge) {
            if (!hasFollowerEdgeRelayGoal) {
                mob.f_21345_.m_25352_(attractionPriority, (Goal)new FollowerEdgeRelayGoal(mob, moveSpeed));
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[CustomNPCs] Re-added FollowerEdgeRelayGoal to {}", (Object)mob.m_7755_().getString());
                }
            }
            if (!hasLeaderAttractionGoal) {
                mob.f_21345_.m_25352_(attractionPriority + 1, (Goal)new LeaderAttractionGoal(mob, moveSpeed));
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[CustomNPCs] Re-added LeaderAttractionGoal to {}", (Object)mob.m_7755_().getString());
                }
            }
        } else if (!hasAttractionGoal) {
            mob.f_21345_.m_25352_(attractionPriority, (Goal)new AttractionGoal(mob, moveSpeed){

                @Override
                public boolean m_8036_() {
                    boolean result;
                    boolean bl = result = (mob.m_5448_() == null || !mob.m_5448_().m_6084_()) && super.m_8036_();
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && result) {
                        SoundAttractMod.LOGGER.info("[CustomNPCs] AttractionGoal.canUse() returning true for {}", (Object)mob.m_7755_().getString());
                    }
                    return result;
                }

                @Override
                public boolean m_8045_() {
                    boolean result;
                    boolean bl = result = (mob.m_5448_() == null || !mob.m_5448_().m_6084_()) && super.m_8045_();
                    if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && result) {
                        SoundAttractMod.LOGGER.info("[CustomNPCs] AttractionGoal.canContinueToUse() returning true for {}", (Object)mob.m_7755_().getString());
                    }
                    return result;
                }
            });
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[CustomNPCs] Re-added AttractionGoal to {}", (Object)mob.m_7755_().getString());
            }
        }
        if (!hasFollowLeaderGoal) {
            mob.f_21345_.m_25352_(attractionPriority + 2, (Goal)new FollowLeaderGoal(mob, moveSpeed));
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[CustomNPCs] Re-added FollowLeaderGoal to {}", (Object)mob.m_7755_().getString());
            }
        }
    }
}

