/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.mixin;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.FollowLeaderGoal;
import com.example.soundattract.ai.FollowerEdgeRelayGoal;
import com.example.soundattract.ai.LeaderAttractionGoal;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.SoundAttractionEvents;
import java.util.Set;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Pseudo
@Mixin(targets={"noppes.npcs.entity.EntityNPCInterface"}, remap=false)
public abstract class CustomNpcsEntityNPCInterfaceMixin {
    @Inject(method={"updateTasks()V"}, at={@At(value="TAIL")})
    private void soundattract$afterUpdateTasks(CallbackInfo ci) {
        Set<EntityType<?>> blacklisted;
        Mob mob;
        if (SoundAttractConfig.COMMON == null || !((Boolean)SoundAttractConfig.COMMON.enableCustomNpcsIntegration.get()).booleanValue()) {
            return;
        }
        try {
            mob = (Mob)this;
        }
        catch (Throwable t) {
            return;
        }
        if (mob.m_9236_() == null || mob.m_9236_().m_5776_()) {
            return;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[CustomNPCs] updateTasks called for {}, checking goals", (Object)mob.m_7755_().getString());
        }
        if ((blacklisted = SoundAttractionEvents.getCachedBlacklistedEntityTypes()).contains(mob.m_6095_())) {
            return;
        }
        if (!SoundAttractionEvents.isCustomNpcsMob(mob)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[CustomNPCs] {} is not detected as CustomNPCs mob", (Object)mob.m_7755_().getString());
            }
            return;
        }
        if (mob.f_21345_ == null) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[CustomNPCs] {} has null goalSelector", (Object)mob.m_7755_().getString());
            }
            return;
        }
        double moveSpeed = (Double)SoundAttractConfig.COMMON.mobMoveSpeed.get();
        boolean hasAttractionGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof AttractionGoal);
        boolean hasLeaderAttractionGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof LeaderAttractionGoal);
        boolean hasFollowerEdgeRelayGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof FollowerEdgeRelayGoal);
        boolean hasFollowLeaderGoal = mob.f_21345_.m_148105_().stream().anyMatch(wrappedGoal -> wrappedGoal.m_26015_() instanceof FollowLeaderGoal);
        boolean smartEdge = (Boolean)SoundAttractConfig.COMMON.edgeMobSmartBehavior.get();
        int attractionPriority = 0;
        if (smartEdge) {
            if (!hasFollowerEdgeRelayGoal) {
                mob.f_21345_.m_25352_(attractionPriority, (Goal)new FollowerEdgeRelayGoal(mob, moveSpeed));
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[CustomNPCs] Re-added FollowerEdgeRelayGoal to {}", (Object)mob.m_7755_().getString());
                }
            }
            if (!hasLeaderAttractionGoal) {
                mob.f_21345_.m_25352_(attractionPriority + 1, (Goal)new LeaderAttractionGoal(mob, moveSpeed));
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("[CustomNPCs] Re-added LeaderAttractionGoal to {}", (Object)mob.m_7755_().getString());
                }
            }
        } else if (!hasAttractionGoal) {
            mob.f_21345_.m_25352_(attractionPriority, (Goal)new AttractionGoal(mob, moveSpeed){

                @Override
                public boolean m_8036_() {
                    return (mob.m_5448_() == null || !mob.m_5448_().m_6084_()) && super.m_8036_();
                }

                @Override
                public boolean m_8045_() {
                    return (mob.m_5448_() == null || !mob.m_5448_().m_6084_()) && super.m_8045_();
                }
            });
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[CustomNPCs] Re-added AttractionGoal to {}", (Object)mob.m_7755_().getString());
            }
        }
        if (!hasFollowLeaderGoal) {
            mob.f_21345_.m_25352_(attractionPriority + 2, (Goal)new FollowLeaderGoal(mob, moveSpeed));
        }
    }

    @Inject(method={"readSpawnData(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="TAIL")})
    private void soundattract$onReadSpawnData(CallbackInfo ci) {
        Mob mob;
        if (SoundAttractConfig.COMMON == null || !((Boolean)SoundAttractConfig.COMMON.enableCustomNpcsIntegration.get()).booleanValue()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[CustomNPCs] Integration disabled, skipping readSpawnData");
            }
            return;
        }
        try {
            mob = (Mob)this;
        }
        catch (Throwable t) {
            return;
        }
        if (mob.m_9236_() == null || mob.m_9236_().m_5776_()) {
            return;
        }
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[CustomNPCs] readSpawnData called for {}, checking if CustomNPCs", (Object)mob.m_7755_().getString());
        }
        if (!SoundAttractionEvents.isCustomNpcsMob(mob)) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[CustomNPCs] {} is not detected as CustomNPCs mob", (Object)mob.m_7755_().getString());
            }
            return;
        }
        SoundAttractionEvents.invalidateCachedEntityTypes();
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[CustomNPCs] Spawn data read for {}, forcing goal registration", (Object)mob.m_7755_().getString());
        }
        this.soundattract$afterUpdateTasks(ci);
    }
}

