/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.mixin;

import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.SoundAttractionEvents;
import com.example.soundattract.tracking.SoundTracker;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"noppes.npcs.ai.EntityAIWander"}, remap=false)
public abstract class CustomNpcsEntityAIWanderMixin
extends Goal {
    private static final Map<Mob, Long> SOUND_YIELD_TICK = Collections.synchronizedMap(new WeakHashMap());
    private static final Map<Mob, Boolean> SOUND_YIELD_RESULT = Collections.synchronizedMap(new WeakHashMap());

    private static Mob soundattract$getNpcMob(Object self) {
        Object npc;
        Field f2;
        try {
            f2 = self.getClass().getDeclaredField("entity");
            f2.setAccessible(true);
            npc = f2.get(self);
            if (npc instanceof Mob) {
                Mob mob = (Mob)npc;
                return mob;
            }
        }
        catch (Throwable f2) {
            // empty catch block
        }
        try {
            f2 = self.getClass().getDeclaredField("npc");
            f2.setAccessible(true);
            npc = f2.get(self);
            if (npc instanceof Mob) {
                Mob mob = (Mob)npc;
                return mob;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean soundattract$isEligible(Mob mob) {
        if (mob == null) {
            return false;
        }
        if (SoundAttractConfig.COMMON == null || !((Boolean)SoundAttractConfig.COMMON.enableCustomNpcsIntegration.get()).booleanValue()) {
            return false;
        }
        Set<EntityType<?>> blacklisted = SoundAttractionEvents.getCachedBlacklistedEntityTypes();
        if (blacklisted.contains(mob.m_6095_())) {
            return false;
        }
        if (SoundAttractionEvents.isCustomNpcsMob(mob)) {
            return true;
        }
        Set<EntityType<?>> attracted = SoundAttractionEvents.getCachedAttractedEntityTypes();
        boolean isAttractedByType = attracted.contains(mob.m_6095_());
        boolean hasMatchingProfile = SoundAttractConfig.getMatchingProfile(mob) != null;
        return isAttractedByType || hasMatchingProfile;
    }

    private static boolean soundattract$isPursuingSound(Mob mob) {
        if (mob == null || mob.f_21345_ == null) {
            return false;
        }
        try {
            return mob.f_21345_.m_148105_().stream().map(w -> w.m_26015_()).filter(g -> g instanceof AttractionGoal).map(g -> (AttractionGoal)((Object)g)).anyMatch(AttractionGoal::isPursuingSound);
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    private static boolean soundattract$shouldYieldToSound(Mob mob) {
        if (mob == null || mob.m_9236_() == null || mob.m_9236_().m_5776_()) {
            return false;
        }
        if (mob.m_5448_() != null && mob.m_5448_().m_6084_()) {
            return false;
        }
        long tick = mob.m_9236_().m_46467_();
        Long lastTick = SOUND_YIELD_TICK.get(mob);
        if (lastTick != null && lastTick == tick) {
            Boolean cached = SOUND_YIELD_RESULT.get(mob);
            return cached != null && cached != false;
        }
        boolean result = CustomNpcsEntityAIWanderMixin.soundattract$isPursuingSound(mob);
        if (!result) {
            try {
                SoundTracker.SoundRecord sr = SoundTracker.findNearestSound(mob, mob.m_9236_(), mob.m_20183_(), mob.m_146892_());
                result = sr != null;
            }
            catch (Throwable ignored) {
                result = false;
            }
        }
        SOUND_YIELD_TICK.put(mob, tick);
        SOUND_YIELD_RESULT.put(mob, result);
        return result;
    }

    @Inject(method={"m_8036_()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void soundattract$canUse(CallbackInfoReturnable<Boolean> cir) {
        Mob mob = CustomNpcsEntityAIWanderMixin.soundattract$getNpcMob((Object)this);
        if (!CustomNpcsEntityAIWanderMixin.soundattract$isEligible(mob)) {
            return;
        }
        if (CustomNpcsEntityAIWanderMixin.soundattract$shouldYieldToSound(mob)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"m_8045_()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void soundattract$canContinue(CallbackInfoReturnable<Boolean> cir) {
        Mob mob = CustomNpcsEntityAIWanderMixin.soundattract$getNpcMob((Object)this);
        if (!CustomNpcsEntityAIWanderMixin.soundattract$isEligible(mob)) {
            return;
        }
        if (CustomNpcsEntityAIWanderMixin.soundattract$shouldYieldToSound(mob)) {
            cir.setReturnValue((Object)false);
        }
    }
}

