/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration.voicechat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class VoiceChatThresholds {
    private static volatile List<Threshold> cached = Collections.emptyList();
    private static volatile int cachedHash = 0;

    private VoiceChatThresholds() {
    }

    static List<Threshold> getThresholds(List<? extends String> rawMap) {
        if (rawMap == null || rawMap.isEmpty()) {
            cached = Collections.emptyList();
            cachedHash = 0;
            return cached;
        }
        int hash = rawMap.hashCode();
        List<Threshold> local = cached;
        if (hash == cachedHash && local != null) {
            return local;
        }
        ArrayList<Threshold> parsed = new ArrayList<Threshold>();
        for (String string : rawMap) {
            String[] parts;
            if (string == null || string.isEmpty() || (parts = string.split(":", 2)).length != 2) continue;
            try {
                double th = Double.parseDouble(parts[0].trim());
                double mul = Double.parseDouble(parts[1].trim());
                parsed.add(new Threshold(th, mul));
            }
            catch (Exception exception) {}
        }
        parsed.sort(Comparator.comparingDouble(t -> t.threshold).reversed());
        List<Threshold> unmodifiable = Collections.unmodifiableList(parsed);
        cached = unmodifiable;
        cachedHash = hash;
        return unmodifiable;
    }

    static final class Threshold {
        final double threshold;
        final double multiplier;

        Threshold(double threshold, double multiplier) {
            this.threshold = threshold;
            this.multiplier = multiplier;
        }
    }
}

