/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration.tacz;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.StealthDetectionEvents;
import com.example.soundattract.network.SoundMessage;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.event.common.GunShootEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.apache.commons.lang3.tuple.Pair;

public class TaczIntegration {
    private static final ResourceLocation TACZ_SOUND_ID = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"gun");

    @SubscribeEvent
    public static void onGunShoot(GunShootEvent event) {
        if (event.getLogicalSide() != LogicalSide.SERVER) {
            return;
        }
        LivingEntity shooter = event.getShooter();
        if (!(shooter instanceof Player)) {
            return;
        }
        Player player = (Player)shooter;
        IGun iGun = IGun.getIGunOrNull((ItemStack)event.getGunItemStack());
        if (iGun != null) {
            double flashRange = (Double)SoundAttractConfig.COMMON.gunshotBaseDetectionRange.get();
            double reduction = 0.0;
            ResourceLocation muzzleId = iGun.getAttachmentId(event.getGunItemStack(), AttachmentType.MUZZLE);
            if (muzzleId != null) {
                reduction = SoundAttractConfig.TACZ_MUZZLE_FLASH_REDUCTION_CACHE.getOrDefault(muzzleId, SoundAttractConfig.TACZ_ATTACHMENT_FLASH_REDUCTION_DEFAULT_CACHE);
            }
            double finalDetectionRange = Math.max(0.0, flashRange - reduction);
            StealthDetectionEvents.recordPlayerGunshot(player, finalDetectionRange);
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[TaczIntegration] Gunshot Flash: BaseRange={}, Muzzle='{}', Reduction={}, FinalRange={}", new Object[]{String.format("%.2f", flashRange), muzzleId != null ? muzzleId.toString() : "None", String.format("%.2f", reduction), String.format("%.2f", finalDetectionRange)});
            }
        }
        double[] rangeAndWeight = TaczIntegration.calculateShootRangeWeight(event.getGunItemStack());
        double range = rangeAndWeight[0];
        double weight = rangeAndWeight[1];
        String soundType = "shoot";
        SoundMessage msg = new SoundMessage(TACZ_SOUND_ID, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_9236_().m_46472_().m_135782_(), Optional.of(player.m_20148_()), (int)range, weight, null, soundType, null);
        SoundMessage.handle(msg, () -> null);
    }

    @SubscribeEvent
    public static void onGunReload(GunReloadEvent event) {
        if (event.getLogicalSide() != LogicalSide.SERVER) {
            return;
        }
        LivingEntity reloader = event.getEntity();
        if (!(reloader instanceof Player)) {
            return;
        }
        Player player = (Player)reloader;
        double[] rangeAndWeight = TaczIntegration.calculateReloadRangeWeight(event.getGunItemStack());
        double range = rangeAndWeight[0];
        double weight = rangeAndWeight[1];
        String soundType = "reload";
        SoundMessage msg = new SoundMessage(TACZ_SOUND_ID, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_9236_().m_46472_().m_135782_(), Optional.of(player.m_20148_()), (int)range, weight, null, soundType, null);
        SoundMessage.handle(msg, () -> null);
    }

    private static double[] calculateShootRangeWeight(ItemStack gunStack) {
        IGun iGun = IGun.getIGunOrNull((ItemStack)gunStack);
        double finalRange = SoundAttractConfig.TACZ_SHOOT_RANGE_CACHE;
        if (iGun != null) {
            String attKey;
            Double configured;
            ResourceLocation gunId = iGun.getGunId(gunStack);
            ResourceLocation attId = iGun.getAttachmentId(gunStack, AttachmentType.MUZZLE);
            Pair<Double, Double> gunStats = SoundAttractConfig.TACZ_GUN_SHOOT_DB_CACHE.get(gunId);
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                SoundAttractMod.LOGGER.info("[TaczIntegration][DEBUG] gunId={}, statsInCache={}", (Object)gunId, gunStats);
            }
            double gunRange = gunStats != null ? (Double)gunStats.getLeft() : SoundAttractConfig.TACZ_SHOOT_RANGE_CACHE;
            double reduction = 0.0;
            if (attId != null && (configured = SoundAttractConfig.TACZ_ATTACHMENT_REDUCTION_DB_CACHE.get(attKey = attId.toString())) != null) {
                reduction = configured;
            }
            finalRange = Math.max(0.0, gunRange - reduction);
        }
        double weight = finalRange / 10.0;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[TaczIntegration] Shot: range={}, weight={}", (Object)finalRange, (Object)weight);
        }
        return new double[]{finalRange, weight};
    }

    private static double[] calculateReloadRangeWeight(ItemStack gunStack) {
        double range = SoundAttractConfig.TACZ_RELOAD_RANGE_CACHE;
        double weight = SoundAttractConfig.TACZ_RELOAD_WEIGHT_CACHE;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[TaczIntegration] Reload: range={}, weight={}", (Object)range, (Object)weight);
        }
        return new double[]{range, weight};
    }
}

