/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration.sbl;

import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.StealthDetectionEvents;
import com.example.soundattract.tracking.SoundTracker;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.util.BrainUtils;

public class SoundAttractSblBehaviour<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED)});
    private SoundTracker.SoundRecord picked;

    public SoundAttractSblBehaviour() {
        this.runFor(e -> 1);
        this.startCondition(e -> e != null && !e.m_20160_() && !e.m_5803_() && ((Boolean)SoundAttractConfig.COMMON.enableStealthMechanics.get() == false || !StealthDetectionEvents.shouldSuppressTargeting((Mob)e)));
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (BrainUtils.getMemory(entity, (MemoryModuleType)MemoryModuleType.f_26372_) != null) {
            return false;
        }
        SoundTracker.SoundRecord best = SoundTracker.findNearestSound(entity, entity.m_9236_(), entity.m_20183_(), entity.m_146892_(), null);
        if (best == null || best.pos == null) {
            return false;
        }
        this.picked = best;
        return true;
    }

    protected void start(E entity) {
        SoundTracker.SoundRecord best = this.picked;
        this.picked = null;
        if (best == null || best.pos == null) {
            return;
        }
        BlockPos pos = best.pos;
        float speed = (float)((Double)SoundAttractConfig.COMMON.mobMoveSpeed.get()).doubleValue();
        int closeEnough = Math.max(1, (int)Math.round((Double)SoundAttractConfig.COMMON.arrivalDistance.get()));
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26371_, (Object)new BlockPosTracker(pos));
        BrainUtils.setMemory(entity, (MemoryModuleType)MemoryModuleType.f_26370_, (Object)new WalkTarget(Vec3.m_82512_((Vec3i)pos), speed, closeEnough));
        entity.m_6274_().m_21889_(Activity.f_37979_);
    }
}

