/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration.pointblank;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.event.StealthDetectionEvents;
import com.example.soundattract.network.SoundMessage;
import com.vicmatskiv.pointblank.attachment.Attachment;
import com.vicmatskiv.pointblank.attachment.AttachmentCategory;
import com.vicmatskiv.pointblank.attachment.Attachments;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;

public class PointBlankIntegration {
    public static void onGunShoot(ServerPlayer player, ItemStack gunStack) {
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[PointBlankIntegration] onGunShoot called for player: {}", (Object)player.m_7755_().getString());
        }
        double flashRange = (Double)SoundAttractConfig.COMMON.gunshotBaseDetectionRange.get();
        double reduction = 0.0;
        for (ItemStack attachmentStack : Attachments.getAttachments((ItemStack)gunStack)) {
            ResourceLocation muzzleId;
            Attachment attachment;
            Item item = attachmentStack.m_41720_();
            if (!(item instanceof Attachment) || (attachment = (Attachment)item).getCategory() != AttachmentCategory.MUZZLE || (muzzleId = ForgeRegistries.ITEMS.getKey((Object)attachmentStack.m_41720_())) == null) continue;
            reduction += SoundAttractConfig.POINT_BLANK_MUZZLE_FLASH_REDUCTION_CACHE.getOrDefault(muzzleId, 0.0).doubleValue();
        }
        double finalDetectionRange = Math.max(0.0, flashRange - reduction);
        StealthDetectionEvents.recordPlayerGunshot((Player)player, finalDetectionRange);
        double[] rangeAndWeight = PointBlankIntegration.calculateShootRangeWeight(gunStack);
        SoundMessage msg = new SoundMessage(SoundMessage.POINT_BLANK_SOUND_ID, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_9236_().m_46472_().m_135782_(), Optional.of(player.m_20148_()), (int)rangeAndWeight[0], rangeAndWeight[1], null, null, "shoot");
        SoundMessage.handle(msg, () -> null);
    }

    public static void onGunReload(ServerPlayer player, ItemStack gunStack) {
        double[] rangeAndWeight = PointBlankIntegration.calculateReloadRangeWeight(gunStack);
        SoundMessage msg = new SoundMessage(SoundMessage.POINT_BLANK_SOUND_ID, player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_9236_().m_46472_().m_135782_(), Optional.of(player.m_20148_()), (int)rangeAndWeight[0], rangeAndWeight[1], null, null, "reload");
        SoundMessage.handle(msg, () -> null);
    }

    private static double[] calculateShootRangeWeight(ItemStack gunStack) {
        ResourceLocation gunId = ForgeRegistries.ITEMS.getKey((Object)gunStack.m_41720_());
        double finalRange = SoundAttractConfig.POINT_BLANK_GUN_RANGE_CACHE.getOrDefault(gunId, SoundAttractConfig.POINT_BLANK_SHOOT_RANGE_CACHE);
        double soundReduction = 0.0;
        for (ItemStack attachmentStack : Attachments.getAttachments((ItemStack)gunStack)) {
            ResourceLocation attachmentId = ForgeRegistries.ITEMS.getKey((Object)attachmentStack.m_41720_());
            soundReduction += SoundAttractConfig.POINT_BLANK_ATTACHMENT_REDUCTION_CACHE.getOrDefault(attachmentId, SoundAttractConfig.POINT_BLANK_ATTACHMENT_REDUCTION_DEFAULT_CACHE).doubleValue();
        }
        finalRange = Math.max(0.0, finalRange - soundReduction);
        double weight = finalRange / 10.0;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[PointBlankIntegration] Shoot: Gun='{}', BaseRange={}, Reduction={}, FinalRange={}, Weight={}", new Object[]{gunId, String.format("%.2f", finalRange + soundReduction), String.format("%.2f", soundReduction), String.format("%.2f", finalRange), String.format("%.2f", weight)});
        }
        return new double[]{finalRange, weight};
    }

    private static double[] calculateReloadRangeWeight(ItemStack gunStack) {
        double range = SoundAttractConfig.POINT_BLANK_RELOAD_RANGE_CACHE;
        double weight = SoundAttractConfig.POINT_BLANK_RELOAD_WEIGHT_CACHE;
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("[PointBlankIntegration] Reload: range={}, weight={}", (Object)range, (Object)weight);
        }
        return new double[]{range, weight};
    }
}

