/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.integration;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.config.SoundAttractConfig;
import com.raiiiden.relentlessundead.common.config.RelentlessUndeadConfig;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

public class RelentlessUndeadIntegration {
    public static boolean isLoaded() {
        return ModList.get().isLoaded("relentlessundead");
    }

    public static boolean getEffectiveZombiesIgnoreHeight() {
        if (RelentlessUndeadIntegration.isLoaded()) {
            try {
                return Inner.getZombiesIgnoreHeight();
            }
            catch (Throwable t) {
                SoundAttractMod.LOGGER.error("Failed to get Relentless Undead config", t);
            }
        }
        return (Boolean)SoundAttractConfig.COMMON.zombiesIgnoreHeight.get();
    }

    public static boolean getEffectiveZombiesCanStack() {
        if (RelentlessUndeadIntegration.isLoaded()) {
            try {
                return Inner.getZombiesCanStack();
            }
            catch (Throwable t) {
                SoundAttractMod.LOGGER.error("Failed to get Relentless Undead config", t);
            }
        }
        return (Boolean)SoundAttractConfig.COMMON.zombiesCanStack.get();
    }

    public static double getEffectiveZombieFallDamageMultiplier() {
        if (RelentlessUndeadIntegration.isLoaded()) {
            try {
                return Inner.getZombieFallDamageMultiplier();
            }
            catch (Throwable t) {
                SoundAttractMod.LOGGER.error("Failed to get Relentless Undead config", t);
            }
        }
        return (Double)SoundAttractConfig.COMMON.zombieFallDamageMultiplier.get();
    }

    public static boolean isMobEligibleForClimbing(Mob mob) {
        if (((Boolean)SoundAttractConfig.COMMON.enableRelentlessClimbing.get()).booleanValue()) {
            if (RelentlessUndeadIntegration.isLoaded()) {
                try {
                    return Inner.isMobEligible(mob);
                }
                catch (Throwable t) {
                    SoundAttractMod.LOGGER.error("Failed to check Relentless Undead eligibility", t);
                }
            } else {
                List list = (List)SoundAttractConfig.COMMON.relentlessEligibleMobs.get();
                ResourceLocation mobId = ForgeRegistries.ENTITY_TYPES.getKey((Object)mob.m_6095_());
                return mobId != null && list.contains(mobId.toString());
            }
        }
        return false;
    }

    private static class Inner {
        private Inner() {
        }

        static boolean getZombiesIgnoreHeight() {
            return (Boolean)RelentlessUndeadConfig.COMMON.zombiesIgnoreHeight.get();
        }

        static boolean getZombiesCanStack() {
            return (Boolean)RelentlessUndeadConfig.COMMON.zombiesCanStack.get();
        }

        static double getZombieFallDamageMultiplier() {
            return (Double)RelentlessUndeadConfig.COMMON.zombieFallDamageMultiplier.get();
        }

        static boolean isMobEligible(Mob mob) {
            TagKey hordeTag = TagKey.m_203882_((ResourceKey)Registries.f_256939_, (ResourceLocation)new ResourceLocation("forge", "hordes"));
            return mob.m_6095_().m_204039_(hordeTag);
        }
    }
}

