/*
 * Decompiled with CFR 0.152.
 */
package com.example.soundattract.ai;

import com.example.soundattract.SoundAttractMod;
import com.example.soundattract.ai.AttractionGoal;
import com.example.soundattract.ai.FollowLeaderGoal;
import com.example.soundattract.ai.LeaderAttractionGoal;
import com.example.soundattract.config.SoundAttractConfig;
import com.example.soundattract.integration.RelentlessUndeadIntegration;
import com.example.soundattract.quantified.QuantifiedCacheCompat;
import com.example.soundattract.tracking.SoundTracker;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SoundClimbGoal
extends Goal {
    private final Mob mob;
    private static final double BASE_SEARCH_RADIUS = 1.5;
    private static final double ON_ZOMBIE_HORIZONTAL_TOLERANCE = 0.4;
    private static final double MIN_VERTICAL_DIFFERENCE = 2.0;
    private static final double HORIZONTAL_STOP_DISTANCE_SQ = 2.25;
    private BlockPos targetSoundPos;
    private BlockPos lastKnownTargetPos = null;
    private double initialTargetY = 0.0;
    private long nextPathCheckTick = 0L;
    private int checkBestSoundTicker = 0;
    private boolean forceStop = false;

    public SoundClimbGoal(Mob mob) {
        this.mob = mob;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    private boolean isMobEligible(Entity entity) {
        if (!(entity instanceof Mob)) {
            return false;
        }
        return RelentlessUndeadIntegration.isMobEligibleForClimbing((Mob)entity);
    }

    private boolean isStandingOnHorde() {
        Level world = this.mob.m_9236_();
        Vec3 selfPos = this.mob.m_20182_();
        AABB searchBoxUnder = new AABB(selfPos.f_82479_, selfPos.f_82480_ - 0.6, selfPos.f_82481_, selfPos.f_82479_, selfPos.f_82480_ - 0.2, selfPos.f_82481_).m_82377_(0.4, 0.05, 0.4);
        List mobsUnder = QuantifiedCacheCompat.isUsable() ? QuantifiedCacheCompat.getCached("SoundClimbGoal", "standing_on_" + this.mob.m_19879_(), () -> world.m_6443_(Entity.class, searchBoxUnder, this::isMobEligible), 1L, 10L) : world.m_6443_(Entity.class, searchBoxUnder, this::isMobEligible);
        return mobsUnder.stream().anyMatch(e -> e != this.mob);
    }

    private boolean isStuckHorizontally(BlockPos targetPos) {
        if (targetPos == null) {
            return false;
        }
        Path path = this.mob.m_21573_().m_7864_(targetPos, 0);
        if (path == null) {
            return true;
        }
        if (!path.m_77403_()) {
            return true;
        }
        BlockPos endPos = path.m_77406_();
        double pathEndToTargetDist = endPos != null ? endPos.m_123331_((Vec3i)targetPos) : Double.MAX_VALUE;
        return pathEndToTargetDist > 1.0;
    }

    public boolean m_8036_() {
        boolean isTargetElevated;
        if (this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_()) {
            return false;
        }
        if (!RelentlessUndeadIntegration.isMobEligibleForClimbing(this.mob)) {
            return false;
        }
        long currentTick = this.mob.m_9236_().m_46467_();
        if (currentTick < this.nextPathCheckTick && !this.isStandingOnHorde()) {
            return false;
        }
        BlockPos foundTarget = null;
        for (WrappedGoal wrapped : this.mob.f_21345_.m_148105_()) {
            FollowLeaderGoal flg;
            Goal goal = wrapped.m_26015_();
            if (goal instanceof AttractionGoal) {
                AttractionGoal ag = (AttractionGoal)goal;
                if (ag.getTargetSoundPos() != null) {
                    foundTarget = ag.getTargetSoundPos();
                }
            } else if (goal instanceof LeaderAttractionGoal) {
                LeaderAttractionGoal lag = (LeaderAttractionGoal)goal;
                if (lag.getTargetSoundPos() != null) {
                    foundTarget = lag.getTargetSoundPos();
                }
            } else if (goal instanceof FollowLeaderGoal && (flg = (FollowLeaderGoal)goal).getTargetSoundPos() != null) {
                foundTarget = flg.getTargetSoundPos();
            }
            if (foundTarget == null) continue;
            break;
        }
        if (foundTarget == null) {
            return false;
        }
        if (this.isStandingOnHorde()) {
            this.targetSoundPos = foundTarget;
            this.lastKnownTargetPos = foundTarget;
            this.initialTargetY = foundTarget.m_123342_();
            return true;
        }
        boolean ignoreHeight = RelentlessUndeadIntegration.getEffectiveZombiesIgnoreHeight();
        double distY = (double)foundTarget.m_123342_() - this.mob.m_20186_();
        boolean bl = isTargetElevated = distY >= 2.0;
        if (!ignoreHeight && !isTargetElevated) {
            if (!this.isStuckHorizontally(foundTarget) && !this.mob.f_19862_) {
                return false;
            }
            this.nextPathCheckTick = currentTick + 15L + (long)this.mob.m_217043_().m_188503_(15);
            return false;
        }
        if (!this.isStuckHorizontally(foundTarget) && !this.mob.f_19862_) {
            this.nextPathCheckTick = currentTick + 15L + (long)this.mob.m_217043_().m_188503_(15);
            return false;
        }
        this.nextPathCheckTick = currentTick + 15L + (long)this.mob.m_217043_().m_188503_(15);
        Level world = this.mob.m_9236_();
        Vec3 selfPos = this.mob.m_20182_();
        AABB searchBoxBase = new AABB(selfPos.f_82479_, selfPos.f_82480_ - 0.5, selfPos.f_82481_, selfPos.f_82479_, selfPos.f_82480_, selfPos.f_82481_).m_82400_(1.5);
        List nearbyBase = QuantifiedCacheCompat.isUsable() ? QuantifiedCacheCompat.getCached("SoundClimbGoal", "nearby_base_" + this.mob.m_19879_(), () -> world.m_6443_(Entity.class, searchBoxBase, e -> e != this.mob && this.isMobEligible((Entity)e) && e.m_20096_()), 5L, 20L) : world.m_6443_(Entity.class, searchBoxBase, e -> e != this.mob && this.isMobEligible((Entity)e) && e.m_20096_());
        if (nearbyBase.size() < 1) {
            return false;
        }
        this.targetSoundPos = foundTarget;
        this.lastKnownTargetPos = foundTarget;
        this.initialTargetY = foundTarget.m_123342_();
        if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
            SoundAttractMod.LOGGER.info("SoundClimbGoal starting for {} at {} with target {}", new Object[]{this.mob, this.mob.m_20183_(), foundTarget});
        }
        return true;
    }

    public void m_8056_() {
        this.forceStop = false;
        this.checkBestSoundTicker = 0;
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_8045_() {
        Path path;
        if (this.forceStop) {
            return false;
        }
        if (this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_()) {
            return false;
        }
        if (this.targetSoundPos == null) {
            return false;
        }
        if (this.mob.m_20186_() - this.initialTargetY > -0.2) {
            return false;
        }
        return this.isStandingOnHorde() || (path = this.mob.m_21573_().m_7864_(this.targetSoundPos, 0)) == null || !path.m_77403_() || !(path.m_77406_().m_123331_((Vec3i)this.targetSoundPos) <= 1.0);
    }

    public void m_8037_() {
        if (this.targetSoundPos == null) {
            return;
        }
        if (this.checkBestSoundTicker++ > 10) {
            this.checkBestSoundTicker = 0;
            SoundTracker.SoundRecord best = SoundTracker.findNearestSound(this.mob, this.mob.m_9236_(), this.mob.m_20183_(), this.mob.m_146892_());
            if (best != null && !best.pos.equals((Object)this.targetSoundPos)) {
                if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue()) {
                    SoundAttractMod.LOGGER.info("SoundClimbGoal aborting: found better sound at {}", (Object)best.pos);
                }
                this.forceStop = true;
                return;
            }
        }
        Vec3 climbTargetPos = Vec3.m_82512_((Vec3i)this.targetSoundPos);
        double dx_horiz = climbTargetPos.f_82479_ - this.mob.m_20185_();
        double dz_horiz = climbTargetPos.f_82481_ - this.mob.m_20189_();
        double horizontalDistanceSq = dx_horiz * dx_horiz + dz_horiz * dz_horiz;
        float yaw = (float)(Math.atan2(dz_horiz, dx_horiz) * 180.0 / Math.PI) - 90.0f;
        this.mob.m_146922_(yaw);
        this.mob.f_20883_ = yaw;
        if (this.isStandingOnHorde()) {
            if (((Boolean)SoundAttractConfig.COMMON.debugLogging.get()).booleanValue() && this.mob.f_19797_ % 20 == 0) {
                SoundAttractMod.LOGGER.info("SoundClimbGoal: {} standing on horde, climbing...", (Object)this.mob);
            }
            this.mob.m_21573_().m_26573_();
            double xzVel = 0.05;
            double yVel = this.mob.m_20069_() ? 0.2 : 0.08;
            Vec3 selfPos = this.mob.m_20182_();
            Vec3 direction = climbTargetPos.m_82546_(selfPos).m_82541_();
            double forwardX = direction.f_82479_ * xzVel;
            double forwardZ = direction.f_82481_ * xzVel;
            this.mob.m_20334_(this.mob.m_20184_().f_82479_ + forwardX, yVel, this.mob.m_20184_().f_82481_ + forwardZ);
            this.mob.f_19789_ = 0.0f;
            if (!this.mob.m_20069_() && !this.mob.m_21023_(MobEffects.f_19603_)) {
                this.mob.m_7292_(new MobEffectInstance(MobEffects.f_19603_, 2, 0, false, false));
            }
        } else {
            if (this.mob.f_19862_ && !this.mob.m_20069_()) {
                Level world = this.mob.m_9236_();
                Vec3 selfPos = this.mob.m_20182_();
                AABB searchBoxBase = new AABB(selfPos.f_82479_, selfPos.f_82480_ - 0.5, selfPos.f_82481_, selfPos.f_82479_, selfPos.f_82480_, selfPos.f_82481_).m_82400_(1.5);
                List nearby = QuantifiedCacheCompat.isUsable() ? QuantifiedCacheCompat.getCached("SoundClimbGoal_JumpCheck", "nearby_" + this.mob.m_19879_(), () -> world.m_6443_(Entity.class, searchBoxBase, e -> e != this.mob && this.isMobEligible((Entity)e)), 5L, 20L) : world.m_6443_(Entity.class, searchBoxBase, e -> e != this.mob && this.isMobEligible((Entity)e));
                if (nearby.size() >= 2 && this.mob.m_217043_().m_188501_() < 0.15f) {
                    this.mob.m_21569_().m_24901_();
                }
            }
            if (horizontalDistanceSq > 2.25) {
                this.mob.m_21573_().m_26519_(climbTargetPos.f_82479_, climbTargetPos.f_82480_, climbTargetPos.f_82481_, ((Double)SoundAttractConfig.COMMON.mobMoveSpeed.get()).doubleValue());
            } else if (this.mob.m_217043_().m_188501_() < 0.2f) {
                this.mob.m_21573_().m_26573_();
            }
        }
    }
}

