/*
 * Decompiled with CFR 0.152.
 */
package sguest.jeimultiblocks.emi;

import blusunrize.immersiveengineering.api.multiblocks.ClientMultiblocks;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import sguest.jeimultiblocks.ContentHelper;
import sguest.jeimultiblocks.emi.EmiModPlugin;
import sguest.jeimultiblocks.emi.MultiblockWidget;

public class EmiMultiblockRecipe
implements EmiRecipe {
    private final ResourceLocation id;
    private final List<EmiIngredient> inputs;
    private final List<EmiStack> output;
    private final MultiblockHandler.IMultiblock multiblock;

    public EmiMultiblockRecipe(MultiblockHandler.IMultiblock multiblock) {
        this.id = new ResourceLocation("jeimultiblocks", "/" + multiblock.getUniqueName().m_135815_());
        ClientMultiblocks.MultiblockManualData manualData = ClientMultiblocks.get((MultiblockHandler.IMultiblock)multiblock);
        this.inputs = manualData.getTotalMaterials().stream().map(ingredient -> EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{ingredient}))).collect(Collectors.toList());
        this.output = List.of(EmiStack.of((ItemLike)multiblock.getBlock()));
        this.multiblock = multiblock;
    }

    public EmiRecipeCategory getCategory() {
        return EmiModPlugin.MULTIBLOCK_CATEGORY;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiIngredient> getCatalysts() {
        return List.of(EmiIngredient.of((Ingredient)Ingredient.m_43927_((ItemStack[])new ItemStack[]{ContentHelper.getHammer()})));
    }

    public List<EmiStack> getOutputs() {
        return this.output;
    }

    public int getDisplayWidth() {
        return 176;
    }

    public int getDisplayHeight() {
        return 108;
    }

    public void addWidgets(WidgetHolder widgetHolder) {
        widgetHolder.addSlot((EmiIngredient)this.getOutputs().get(0), 2, 2).drawBack(false).recipeContext((EmiRecipe)this);
        int y = 2;
        int x = this.getDisplayWidth() - 22;
        widgetHolder.add((Widget)new MultiblockWidget(this.multiblock, 30, 20));
        for (EmiIngredient input : this.getInputs()) {
            widgetHolder.addSlot(input, x, y).drawBack(false);
            if ((y += 20) <= this.getDisplayHeight() - 8) continue;
            y = 2;
            x -= 20;
        }
    }
}

