/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.oculus_for_simpleclouds.dh;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import dev.nonamecrackers2.simpleclouds.client.dh.pipeline.DhSupportPipeline;
import dev.nonamecrackers2.simpleclouds.client.framebuffer.FrameBufferUtils;
import dev.nonamecrackers2.simpleclouds.client.framebuffer.WeightedBlendingTarget;
import dev.nonamecrackers2.simpleclouds.client.mesh.generator.CloudMeshGenerator;
import dev.nonamecrackers2.simpleclouds.client.renderer.SimpleCloudsRenderer;
import dev.nonamecrackers2.simpleclouds.client.renderer.WorldEffects;
import dev.nonamecrackers2.simpleclouds.client.renderer.pipeline.CloudsRenderPipeline;
import dev.nonamecrackers2.simpleclouds.common.config.SimpleCloudsConfig;
import dev.nonamecrackers2.simpleclouds.mixin.MixinRenderTargetAccessor;
import java.nio.IntBuffer;
import net.Gabou.oculus_for_simpleclouds.client.FinalCloudCompositeHandler;
import net.Gabou.oculus_for_simpleclouds.dh.ShaderAwareDhSupportPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.util.profiling.ProfilerFiller;
import nonamecrackers2.crackerslib.common.compat.CompatHelper;
import org.joml.Matrix4f;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;

public class ShaderAwareDhPipeline
implements CloudsRenderPipeline,
ShaderAwareDhSupportPipeline {
    public static final ShaderAwareDhPipeline INSTANCE = new ShaderAwareDhPipeline();
    private static final long DEBUG_INTERVAL_MS = 1000L;
    private static long lastDebugMs = 0L;
    private static String lastDebugMsg = "";
    private static boolean warnedZeroVerts = false;
    public static final boolean DEBUG_BLIT_CLOUD_TARGET = Boolean.getBoolean("ofsc.debug.blitClouds");
    public static boolean skipDepthCopy = false;
    private final CloudsRenderPipeline vanilla = DhSupportPipeline.INSTANCE;
    private static int depthMergeProgram = -1;
    private static int depthMergeVao = -1;
    private static int depthMergeVbo = -1;
    private static int depthMergeSamplerLoc = -1;

    private ShaderAwareDhPipeline() {
    }

    public void prepare(Minecraft mc, SimpleCloudsRenderer renderer, PoseStack stack, Matrix4f projMat, float partialTick, double camX, double camY, double camZ, Frustum frustum) {
        this.vanilla.prepare(mc, renderer, stack, projMat, partialTick, camX, camY, camZ, frustum);
    }

    public void beforeWeather(Minecraft mc, SimpleCloudsRenderer renderer, PoseStack stack, Matrix4f projMat, float partialTick, double camX, double camY, double camZ, Frustum frustum) {
        this.vanilla.beforeWeather(mc, renderer, stack, projMat, partialTick, camX, camY, camZ, frustum);
    }

    public void afterLevel(Minecraft mc, SimpleCloudsRenderer renderer, PoseStack stack, Matrix4f projMat, float partialTick, double camX, double camY, double camZ, Frustum frustum) {
        this.vanilla.afterLevel(mc, renderer, stack, projMat, partialTick, camX, camY, camZ, frustum);
    }

    public void afterSky(Minecraft mc, SimpleCloudsRenderer renderer, PoseStack stack, Matrix4f projMat, float partialTick, double camX, double camY, double camZ, Frustum frustum) {
        this.vanilla.afterSky(mc, renderer, stack, projMat, partialTick, camX, camY, camZ, frustum);
        if (((Boolean)SimpleCloudsConfig.CLIENT.atmosphericClouds.get()).booleanValue()) {
            ProfilerFiller p = mc.m_91307_();
            float[] cloudCol = renderer.getCloudColor(partialTick);
            p.m_6180_("atmospheric_clouds");
            renderer.getAtmosphericCloudRenderer().render(stack, projMat, partialTick, camX, camY, camZ, cloudCol[0], cloudCol[1], cloudCol[2]);
            mc.m_91385_().m_83947_(false);
            p.m_7238_();
        }
    }

    public void beforeDistantHorizonsApplyShader(Minecraft mc, SimpleCloudsRenderer renderer, PoseStack stack, Matrix4f projMat, float partialTick, double camX, double camY, double camZ, Frustum frustum, int dhFbo) {
        if (!CompatHelper.areShadersRunning()) {
            this.vanilla.beforeDistantHorizonsApplyShader(mc, renderer, stack, projMat, partialTick, camX, camY, camZ, frustum, dhFbo);
            return;
        }
        RenderTarget cloudTarget = renderer.getCloudTarget();
        if (cloudTarget == null) {
            return;
        }
        cloudTarget.m_83954_(Minecraft.f_91002_);
        WeightedBlendingTarget transparencyTarget = renderer.getCloudTransparencyTarget();
        transparencyTarget.m_83954_(Minecraft.f_91002_);
        RenderTarget mainTarget = mc.m_91385_();
        FinalCloudCompositeHandler.captureDepth(mainTarget);
        boolean copiedVanillaDepth = ShaderAwareDhPipeline.copyVanillaDepthToCloudTarget(cloudTarget, mainTarget);
        int dhDepthTex = ShaderAwareDhPipeline.resolveDepthTextureId(dhFbo);
        boolean mergedDh = dhDepthTex > 0 && ShaderAwareDhPipeline.mergeDhDepthIntoCloudDepth(cloudTarget, dhFbo);
        ShaderAwareDhPipeline.debug(String.format("DH shader pass: copiedVanilla=%s dhDepthTex=%d mergedDh=%s cloudDepth=%d cloudSize=%dx%d mainDepth=%d", copiedVanillaDepth, dhDepthTex, mergedDh, cloudTarget.m_83980_(), cloudTarget.f_83915_, cloudTarget.f_83916_, mainTarget == null ? -1 : mainTarget.m_83980_()));
        if (!copiedVanillaDepth && !mergedDh) {
            System.out.println("[OFSC WARN] Could not copy vanilla depth and DH merge failed; clouds may render incorrectly this frame.");
        } else if (!mergedDh) {
            System.out.println("[OFSC WARN] DH depth merge unavailable; using vanilla depth only.");
        } else if (!copiedVanillaDepth) {
            System.out.println("[OFSC WARN] Vanilla depth copy failed; relying on DH depth only.");
        }
        GL30.glBindFramebuffer((int)36160, (int)dhFbo);
    }

    public void afterDistantHorizonsRender(Minecraft mc, SimpleCloudsRenderer renderer, PoseStack stack, Matrix4f projMat, float partialTick, double camX, double camY, double camZ, Frustum frustum, int dhFbo) {
        if (!CompatHelper.areShadersRunning()) {
            this.vanilla.afterDistantHorizonsRender(mc, renderer, stack, projMat, partialTick, camX, camY, camZ, frustum, dhFbo);
            return;
        }
        RenderTarget cloudTarget = renderer.getCloudTarget();
        ShaderAwareDhPipeline.debug(String.format("DH clouds render: cloudDepth=%d color=%d size=%dx%d", cloudTarget.m_83980_(), cloudTarget.m_83975_(), cloudTarget.f_83915_, cloudTarget.f_83916_));
        CloudMeshGenerator generator = renderer.getMeshGenerator();
        int opaqueVerts = generator != null ? generator.getOpaqueBufferBytesUsed() / 24 : -1;
        int transparentVerts = generator != null ? generator.getTransparentBufferBytesUsed() / 24 : -1;
        ShaderAwareDhPipeline.debug(String.format("DH clouds render: generator=%s transparency=%s fogStart=%.1f fogEnd=%.1f opaqueVerts=%d transparentVerts=%d", generator, generator != null && generator.transparencyEnabled(), Float.valueOf(renderer.getFogStart()), Float.valueOf(renderer.getFogEnd()), opaqueVerts, transparentVerts));
        if (opaqueVerts == 0 && transparentVerts == 0) {
            System.out.println("[OFSC WARN] Cloud mesh generator produced zero vertices (opaque and transparent). Status=" + String.valueOf(generator == null ? "null" : generator.getMeshGenStatus()));
            warnedZeroVerts = true;
        } else if (warnedZeroVerts) {
            warnedZeroVerts = false;
        }
        float[] cloudCol = renderer.getCloudColor(partialTick);
        float cloudR = cloudCol[0];
        float cloudG = cloudCol[1];
        float cloudB = cloudCol[2];
        ProfilerFiller p = mc.m_91307_();
        p.m_6180_("clouds");
        boolean depthEnabled = GL11.glIsEnabled((int)2929);
        int prevDepthFunc = GL11.glGetInteger((int)2932);
        boolean prevDepthMask = GL11.glGetBoolean((int)2930);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)515);
        GL11.glDepthMask((boolean)true);
        if (DEBUG_BLIT_CLOUD_TARGET) {
            cloudTarget.m_83947_(false);
            GL11.glClearColor((float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glClear((int)16384);
        }
        stack.m_85836_();
        renderer.translateClouds(stack, camX, camY, camZ);
        p.m_6180_("clouds_opaque");
        cloudTarget.m_83947_(false);
        SimpleCloudsRenderer.renderCloudsOpaque((CloudMeshGenerator)generator, (PoseStack)stack, (Matrix4f)projMat, (float)renderer.getFogStart(), (float)renderer.getFogEnd(), (float)partialTick, (float)cloudR, (float)cloudG, (float)cloudB, (Frustum)((Boolean)SimpleCloudsConfig.CLIENT.frustumCulling.get() != false ? frustum : null));
        p.m_6182_("clouds_transparent");
        WeightedBlendingTarget transparencyTarget = renderer.getCloudTransparencyTarget();
        if (generator.transparencyEnabled()) {
            renderer.copyDepthFromCloudsToTransparency();
            transparencyTarget.m_83947_(false);
            SimpleCloudsRenderer.renderCloudsTransparency((CloudMeshGenerator)generator, (PoseStack)stack, (Matrix4f)projMat, (float)renderer.getFogStart(), (float)renderer.getFogEnd(), (float)partialTick, (float)cloudR, (float)cloudG, (float)cloudB, (Frustum)((Boolean)SimpleCloudsConfig.CLIENT.frustumCulling.get() != false ? frustum : null));
        }
        p.m_7238_();
        stack.m_85849_();
        if (!depthEnabled) {
            GL11.glDisable((int)2929);
        }
        GL11.glDepthFunc((int)prevDepthFunc);
        GL11.glDepthMask((boolean)prevDepthMask);
        p.m_6180_("cloud_shadows");
        renderer.doCloudShadowProcessing(stack, partialTick, projMat, camX, camY, camZ, cloudTarget.m_83980_());
        p.m_7238_();
        p.m_6180_("clouds_composite");
        renderer.doFinalCompositePass(stack, partialTick, projMat);
        p.m_7238_();
        p.m_7238_();
        Matrix4f oldMcProjMat = RenderSystem.getProjectionMatrix();
        if (((Boolean)SimpleCloudsConfig.CLIENT.renderStormFog.get()).booleanValue()) {
            p.m_6180_("storm_fog");
            renderer.doStormPostProcessing(stack, partialTick, projMat, camX, camY, camZ, cloudR, cloudG, cloudB);
            RenderTarget target = renderer.getBlurTarget();
            target.m_83954_(Minecraft.f_91002_);
            target.m_83947_(true);
            FrameBufferUtils.blitTargetPreservingAlpha((RenderTarget)renderer.getStormFogTarget(), (int)mc.m_91268_().m_85441_(), (int)mc.m_91268_().m_85442_());
            renderer.doBlurPostProcessing(partialTick);
            mc.m_91385_().m_83947_(false);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ZERO, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            renderer.getBlurTarget().m_83957_(mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_(), false);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
            p.m_7238_();
        }
        mc.m_91385_().m_83947_(false);
        GlStateManager._glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)cloudTarget.m_83975_(), (int)0);
        RenderSystem.setProjectionMatrix((Matrix4f)projMat, (VertexSorting)VertexSorting.f_276450_);
        stack.m_85836_();
        stack.m_85837_(-camX, -camY, -camZ);
        ShaderAwareDhPipeline.renderLightning(renderer.getWorldEffectsManager(), renderer, mc, stack, partialTick, camX, camY, camZ);
        stack.m_85849_();
        if (DEBUG_BLIT_CLOUD_TARGET) {
            ShaderAwareDhPipeline.debug("DEBUG_BLIT_CLOUD_TARGET active; blitting cloud target to screen");
            mc.m_91385_().m_83947_(false);
            cloudTarget.m_83957_(mc.m_91268_().m_85441_(), mc.m_91268_().m_85442_(), false);
            GL30.glBindFramebuffer((int)36008, (int)((MixinRenderTargetAccessor)cloudTarget).simpleclouds$getFrameBufferId());
            GL30.glBindFramebuffer((int)36009, (int)0);
            GL30.glBlitFramebuffer((int)0, (int)0, (int)cloudTarget.f_83915_, (int)cloudTarget.f_83916_, (int)0, (int)0, (int)mc.m_91268_().m_85441_(), (int)mc.m_91268_().m_85442_(), (int)16384, (int)9729);
            GL30.glBindFramebuffer((int)36160, (int)mc.m_91385_().f_83920_);
        }
        RenderSystem.setProjectionMatrix((Matrix4f)oldMcProjMat, (VertexSorting)VertexSorting.f_276450_);
        GlStateManager._glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)mc.m_91385_().m_83975_(), (int)0);
    }

    private static void renderLightning(WorldEffects effects, SimpleCloudsRenderer renderer, Minecraft mc, PoseStack stack, float partialTick, double camX, double camY, double camZ) {
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder builder = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        if (effects.hasLightningToRender()) {
            float cachedFogStart = RenderSystem.getShaderFogStart();
            RenderSystem.setShaderFogStart((float)Float.MAX_VALUE);
            builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            RenderSystem.setShader(GameRenderer::m_172753_);
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            effects.forLightning(bolt -> {
                if (bolt.getPosition().distance((float)camX, (float)camY, (float)camZ) <= 2000.0f && bolt.getFade(partialTick) > 0.5f) {
                    mc.f_91073_.m_6580_(2);
                }
                float dist = bolt.getPosition().distance((float)camX, (float)camY, (float)camZ);
                bolt.render(stack, (VertexConsumer)builder, partialTick, 1.0f, 1.0f, 1.0f, renderer.getFadeFactorForDistance(dist));
            });
            tesselator.m_85914_();
            RenderSystem.setShaderFogStart((float)cachedFogStart);
            RenderSystem.defaultBlendFunc();
        }
        RenderSystem.disableBlend();
    }

    @Override
    public boolean oculus_for_simpleclouds$isShaderAware() {
        return true;
    }

    private static boolean mergeDhDepthIntoCloudDepth(RenderTarget cloudTarget, int dhFbo) {
        int dhDepthTex = ShaderAwareDhPipeline.resolveDepthTextureId(dhFbo);
        if (dhDepthTex <= 0) {
            return false;
        }
        if (!ShaderAwareDhPipeline.ensureDepthMergeProgram()) {
            return false;
        }
        GlStateManager._getError();
        int previousFbo = GL11.glGetInteger((int)36006);
        IntBuffer viewport = BufferUtils.createIntBuffer((int)4);
        GL11.glGetIntegerv((int)2978, (IntBuffer)viewport);
        boolean blendEnabled = GL11.glIsEnabled((int)3042);
        boolean depthEnabled = GL11.glIsEnabled((int)2929);
        GL30.glBindFramebuffer((int)36160, (int)((MixinRenderTargetAccessor)cloudTarget).simpleclouds$getFrameBufferId());
        GL11.glViewport((int)0, (int)0, (int)cloudTarget.f_83915_, (int)cloudTarget.f_83916_);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2929);
        GL11.glDepthMask((boolean)true);
        GL11.glDepthFunc((int)515);
        GL11.glColorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GL20.glUseProgram((int)depthMergeProgram);
        GL13.glActiveTexture((int)33984);
        GL11.glBindTexture((int)3553, (int)dhDepthTex);
        if (depthMergeSamplerLoc >= 0) {
            GL20.glUniform1i((int)depthMergeSamplerLoc, (int)0);
        }
        GL30.glBindVertexArray((int)depthMergeVao);
        GL11.glDrawArrays((int)4, (int)0, (int)3);
        GL30.glBindVertexArray((int)0);
        GL20.glUseProgram((int)0);
        GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GL11.glDepthFunc((int)515);
        if (!depthEnabled) {
            GL11.glDisable((int)2929);
        }
        if (blendEnabled) {
            GL11.glEnable((int)3042);
        } else {
            GL11.glDisable((int)3042);
        }
        GL30.glBindFramebuffer((int)36160, (int)previousFbo);
        GL11.glViewport((int)viewport.get(0), (int)viewport.get(1), (int)viewport.get(2), (int)viewport.get(3));
        return GlStateManager._getError() == 0;
    }

    private static int resolveDepthTextureId(int fbo) {
        int previousFbo = GL11.glGetInteger((int)36006);
        GL30.glBindFramebuffer((int)36160, (int)fbo);
        int attachmentType = GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)36096, (int)36048);
        int depthName = attachmentType == 5890 ? GL30.glGetFramebufferAttachmentParameteri((int)36160, (int)36096, (int)36049) : -1;
        GL30.glBindFramebuffer((int)36160, (int)previousFbo);
        return depthName;
    }

    private static boolean ensureDepthMergeProgram() {
        if (depthMergeProgram != -1 && depthMergeVao != -1 && depthMergeVbo != -1) {
            return true;
        }
        String vertexSrc = "#version 150\nin vec2 aPos;out vec2 vUv;void main(){vUv=aPos*0.5+0.5;gl_Position=vec4(aPos,0.0,1.0);}";
        String fragmentSrc = "#version 150\nin vec2 vUv;uniform sampler2D uDepth;void main(){float d=texture(uDepth,vUv).r;gl_FragDepth=d;}";
        int vert = GL20.glCreateShader((int)35633);
        GL20.glShaderSource((int)vert, (CharSequence)vertexSrc);
        GL20.glCompileShader((int)vert);
        if (GL20.glGetShaderi((int)vert, (int)35713) != 1) {
            System.out.println("[OFSC WARN] Depth merge vertex shader compile failed: " + GL20.glGetShaderInfoLog((int)vert));
            GL20.glDeleteShader((int)vert);
            return false;
        }
        int frag = GL20.glCreateShader((int)35632);
        GL20.glShaderSource((int)frag, (CharSequence)fragmentSrc);
        GL20.glCompileShader((int)frag);
        if (GL20.glGetShaderi((int)frag, (int)35713) != 1) {
            System.out.println("[OFSC WARN] Depth merge fragment shader compile failed: " + GL20.glGetShaderInfoLog((int)frag));
            GL20.glDeleteShader((int)vert);
            GL20.glDeleteShader((int)frag);
            return false;
        }
        depthMergeProgram = GL20.glCreateProgram();
        GL20.glAttachShader((int)depthMergeProgram, (int)vert);
        GL20.glAttachShader((int)depthMergeProgram, (int)frag);
        GL20.glLinkProgram((int)depthMergeProgram);
        GL20.glDeleteShader((int)vert);
        GL20.glDeleteShader((int)frag);
        if (GL20.glGetProgrami((int)depthMergeProgram, (int)35714) != 1) {
            System.out.println("[OFSC WARN] Depth merge program link failed: " + GL20.glGetProgramInfoLog((int)depthMergeProgram));
            GL20.glDeleteProgram((int)depthMergeProgram);
            depthMergeProgram = -1;
            return false;
        }
        depthMergeSamplerLoc = GL20.glGetUniformLocation((int)depthMergeProgram, (CharSequence)"uDepth");
        depthMergeVao = GL30.glGenVertexArrays();
        depthMergeVbo = GL15.glGenBuffers();
        GL30.glBindVertexArray((int)depthMergeVao);
        GL15.glBindBuffer((int)34962, (int)depthMergeVbo);
        GL15.glBufferData((int)34962, (float[])new float[]{-1.0f, -1.0f, 3.0f, -1.0f, -1.0f, 3.0f}, (int)35044);
        int posLoc = GL20.glGetAttribLocation((int)depthMergeProgram, (CharSequence)"aPos");
        GL20.glEnableVertexAttribArray((int)posLoc);
        GL20.glVertexAttribPointer((int)posLoc, (int)2, (int)5126, (boolean)false, (int)8, (long)0L);
        GL30.glBindVertexArray((int)0);
        return true;
    }

    private static boolean copyVanillaDepthToCloudTarget(RenderTarget cloudTarget, RenderTarget source) {
        if (cloudTarget == null || source == null) {
            return false;
        }
        int cloudDepthTex = cloudTarget.m_83980_();
        if (cloudDepthTex <= 0) {
            return false;
        }
        int sourceFbo = ((MixinRenderTargetAccessor)source).simpleclouds$getFrameBufferId();
        if (sourceFbo <= 0) {
            return false;
        }
        GlStateManager._getError();
        int prevReadFbo = GL11.glGetInteger((int)36010);
        int prevTexture = GL11.glGetInteger((int)32873);
        IntBuffer viewport = BufferUtils.createIntBuffer((int)4);
        GL11.glGetIntegerv((int)2978, (IntBuffer)viewport);
        GL30.glBindFramebuffer((int)36008, (int)sourceFbo);
        int copyW = Math.min(cloudTarget.f_83915_, source.f_83915_);
        int copyH = Math.min(cloudTarget.f_83916_, source.f_83916_);
        GL11.glViewport((int)0, (int)0, (int)copyW, (int)copyH);
        GL11.glBindTexture((int)3553, (int)cloudDepthTex);
        GL11.glReadBuffer((int)0);
        GL11.glCopyTexSubImage2D((int)3553, (int)0, (int)0, (int)0, (int)0, (int)0, (int)copyW, (int)copyH);
        GL11.glBindTexture((int)3553, (int)prevTexture);
        GL30.glBindFramebuffer((int)36008, (int)prevReadFbo);
        GL11.glViewport((int)viewport.get(0), (int)viewport.get(1), (int)viewport.get(2), (int)viewport.get(3));
        return GlStateManager._getError() == 0;
    }

    private static void debug(String msg) {
    }
}

