/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.math3.optim.univariate;

import com.happysg.radar.math3.analysis.UnivariateFunction;
import com.happysg.radar.math3.exception.TooManyEvaluationsException;
import com.happysg.radar.math3.optim.BaseOptimizer;
import com.happysg.radar.math3.optim.ConvergenceChecker;
import com.happysg.radar.math3.optim.OptimizationData;
import com.happysg.radar.math3.optim.nonlinear.scalar.GoalType;
import com.happysg.radar.math3.optim.univariate.SearchInterval;
import com.happysg.radar.math3.optim.univariate.UnivariateObjectiveFunction;
import com.happysg.radar.math3.optim.univariate.UnivariatePointValuePair;

public abstract class UnivariateOptimizer
extends BaseOptimizer<UnivariatePointValuePair> {
    private UnivariateFunction function;
    private GoalType goal;
    private double start;
    private double min;
    private double max;

    protected UnivariateOptimizer(ConvergenceChecker<UnivariatePointValuePair> checker) {
        super(checker);
    }

    @Override
    public UnivariatePointValuePair optimize(OptimizationData ... optData) throws TooManyEvaluationsException {
        return (UnivariatePointValuePair)super.optimize(optData);
    }

    public GoalType getGoalType() {
        return this.goal;
    }

    @Override
    protected void parseOptimizationData(OptimizationData ... optData) {
        super.parseOptimizationData(optData);
        for (OptimizationData data : optData) {
            if (data instanceof SearchInterval) {
                SearchInterval interval = (SearchInterval)data;
                this.min = interval.getMin();
                this.max = interval.getMax();
                this.start = interval.getStartValue();
                continue;
            }
            if (data instanceof UnivariateObjectiveFunction) {
                this.function = ((UnivariateObjectiveFunction)data).getObjectiveFunction();
                continue;
            }
            if (!(data instanceof GoalType)) continue;
            this.goal = (GoalType)data;
        }
    }

    public double getStartValue() {
        return this.start;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    protected double computeObjectiveValue(double x) {
        super.incrementEvaluationCount();
        return this.function.value(x);
    }
}

