/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.math3.fitting;

import com.happysg.radar.math3.analysis.MultivariateMatrixFunction;
import com.happysg.radar.math3.analysis.MultivariateVectorFunction;
import com.happysg.radar.math3.analysis.ParametricUnivariateFunction;
import com.happysg.radar.math3.fitting.WeightedObservedPoint;
import com.happysg.radar.math3.optim.InitialGuess;
import com.happysg.radar.math3.optim.MaxEval;
import com.happysg.radar.math3.optim.PointVectorValuePair;
import com.happysg.radar.math3.optim.nonlinear.vector.ModelFunction;
import com.happysg.radar.math3.optim.nonlinear.vector.ModelFunctionJacobian;
import com.happysg.radar.math3.optim.nonlinear.vector.MultivariateVectorOptimizer;
import com.happysg.radar.math3.optim.nonlinear.vector.Target;
import com.happysg.radar.math3.optim.nonlinear.vector.Weight;
import java.util.ArrayList;
import java.util.List;

@Deprecated
public class CurveFitter<T extends ParametricUnivariateFunction> {
    private final MultivariateVectorOptimizer optimizer;
    private final List<WeightedObservedPoint> observations;

    public CurveFitter(MultivariateVectorOptimizer optimizer) {
        this.optimizer = optimizer;
        this.observations = new ArrayList<WeightedObservedPoint>();
    }

    public void addObservedPoint(double x, double y) {
        this.addObservedPoint(1.0, x, y);
    }

    public void addObservedPoint(double weight, double x, double y) {
        this.observations.add(new WeightedObservedPoint(weight, x, y));
    }

    public void addObservedPoint(WeightedObservedPoint observed) {
        this.observations.add(observed);
    }

    public WeightedObservedPoint[] getObservations() {
        return this.observations.toArray(new WeightedObservedPoint[this.observations.size()]);
    }

    public void clearObservations() {
        this.observations.clear();
    }

    public double[] fit(T f, double[] initialGuess) {
        return this.fit(Integer.MAX_VALUE, f, initialGuess);
    }

    public double[] fit(int maxEval, T f, double[] initialGuess) {
        double[] target = new double[this.observations.size()];
        double[] weights = new double[this.observations.size()];
        int i = 0;
        for (WeightedObservedPoint point : this.observations) {
            target[i] = point.getY();
            weights[i] = point.getWeight();
            ++i;
        }
        TheoreticalValuesFunction model = new TheoreticalValuesFunction((ParametricUnivariateFunction)f);
        PointVectorValuePair optimum = this.optimizer.optimize(new MaxEval(maxEval), model.getModelFunction(), model.getModelFunctionJacobian(), new Target(target), new Weight(weights), new InitialGuess(initialGuess));
        return optimum.getPointRef();
    }

    private class TheoreticalValuesFunction {
        private final ParametricUnivariateFunction f;

        TheoreticalValuesFunction(ParametricUnivariateFunction f) {
            this.f = f;
        }

        public ModelFunction getModelFunction() {
            return new ModelFunction(new MultivariateVectorFunction(){

                @Override
                public double[] value(double[] point) {
                    double[] values = new double[CurveFitter.this.observations.size()];
                    int i = 0;
                    for (WeightedObservedPoint observed : CurveFitter.this.observations) {
                        values[i++] = TheoreticalValuesFunction.this.f.value(observed.getX(), point);
                    }
                    return values;
                }
            });
        }

        public ModelFunctionJacobian getModelFunctionJacobian() {
            return new ModelFunctionJacobian(new MultivariateMatrixFunction(){

                @Override
                public double[][] value(double[] point) {
                    double[][] jacobian = new double[CurveFitter.this.observations.size()][];
                    int i = 0;
                    for (WeightedObservedPoint observed : CurveFitter.this.observations) {
                        jacobian[i++] = TheoreticalValuesFunction.this.f.gradient(observed.getX(), point);
                    }
                    return jacobian;
                }
            });
        }
    }
}

