/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.controller.id;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import org.valkyrienskies.core.api.ships.Ship;

public class IDManager
extends SavedData {
    public static final IDManager INSTANCE = new IDManager();
    public static final Map<String, IDRecord> ID_RECORDS = new HashMap<String, IDRecord>();

    public static void addIDRecord(String shipSlug, String secretID, String name) {
        ID_RECORDS.put(shipSlug, new IDRecord(name, secretID));
    }

    public static void registerIDRecord(Ship ship, String name, String secretID) {
        ID_RECORDS.put(ship.getSlug(), new IDRecord(name, secretID));
    }

    public static void removeIDRecord(Ship ship) {
        ID_RECORDS.remove(ship.getSlug());
    }

    public static IDRecord getIDRecordByShip(Ship ship) {
        return ID_RECORDS.get(ship.getSlug());
    }

    public static IDRecord getIDRecordByShipSlug(String shipSlug) {
        return ID_RECORDS.get(shipSlug);
    }

    public static IDManager load(CompoundTag pCompoundTag) {
        if (!pCompoundTag.m_128441_("idRecords")) {
            return INSTANCE;
        }
        ListTag listTag = pCompoundTag.m_128437_("idRecords", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            CompoundTag compoundTag = listTag.m_128728_(i);
            String shipSlug = compoundTag.m_128461_("shipSlug");
            String name = compoundTag.m_128461_("name");
            String secretID = compoundTag.m_128461_("secretID");
            ID_RECORDS.put(shipSlug, new IDRecord(name, secretID));
        }
        return INSTANCE;
    }

    public CompoundTag m_7176_(CompoundTag pCompoundTag) {
        ListTag listTag = new ListTag();
        for (Map.Entry<String, IDRecord> entry : ID_RECORDS.entrySet()) {
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.m_128359_("name", entry.getValue().name());
            compoundTag.m_128359_("secretID", entry.getValue().secretID());
            compoundTag.m_128359_("shipSlug", entry.getKey());
            listTag.add((Object)compoundTag);
        }
        pCompoundTag.m_128365_("idRecords", (Tag)listTag);
        return pCompoundTag;
    }

    public static void load(MinecraftServer server) {
        server.m_129783_().m_8895_().m_164861_(IDManager::load, () -> INSTANCE, "create_radar_vs2_ids");
    }

    public record IDRecord(String name, String secretID) {
    }
}

