/*
 * Decompiled with CFR 0.152.
 */
package com.happysg.radar.block.Test;

import com.happysg.radar.block.Test.TestBlock;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TestBlockEntity
extends SplitShaftBlockEntity {
    private boolean outputAttached = true;
    private float outputMultiplier = 1.0f;

    public TestBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        if (state.m_61138_((Property)TestBlock.OUTPUT_ATTACHED)) {
            this.outputAttached = (Boolean)state.m_61143_((Property)TestBlock.OUTPUT_ATTACHED);
        }
    }

    public float getRotationSpeedModifier(Direction face) {
        if (face == Direction.UP) {
            if (!this.outputAttached) {
                return 0.0f;
            }
            return this.outputMultiplier;
        }
        return 1.0f;
    }

    public boolean isOutputAttached() {
        return this.outputAttached;
    }

    public void setOutputAttached(boolean attached) {
        if (this.outputAttached == attached) {
            return;
        }
        this.outputAttached = attached;
        if (this.f_58857_ == null) {
            return;
        }
        BlockPos pos = this.m_58899_();
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)TestBlock.OUTPUT_ATTACHED)) {
            this.f_58857_.m_7731_(pos, (BlockState)state.m_61124_((Property)TestBlock.OUTPUT_ATTACHED, (Comparable)Boolean.valueOf(attached)), 3);
        }
        this.f_58857_.m_7260_(pos, state, this.m_58900_(), 3);
        this.f_58857_.m_46672_(pos, this.m_58900_().m_60734_());
        this.notifyUpdate();
        this.m_6596_();
    }

    public float getOutputMultiplier() {
        return this.outputMultiplier;
    }

    public void setOutputMultiplier(float mult) {
        if (Float.isNaN(mult) || Float.isInfinite(mult)) {
            return;
        }
        if (this.outputMultiplier == mult) {
            return;
        }
        this.outputMultiplier = mult;
        if (this.f_58857_ != null) {
            this.notifyUpdate();
            this.m_6596_();
        }
    }

    public void onLoad() {
        if (this.outputAttached) {
            this.attachKinetics();
        } else {
            this.detachKinetics();
        }
    }

    public void setOutputTargetRPM(float targetRpm) {
        float inputRpm = this.getSpeed();
        if (Math.abs(inputRpm) < 1.0E-4f) {
            this.setOutputMultiplier(0.0f);
            return;
        }
        this.setOutputMultiplier(targetRpm / inputRpm);
    }

    public void toggleOutputAttached() {
        if (!this.outputAttached) {
            this.setOutputAttached(true);
            this.attachKinetics();
        } else {
            this.setOutputAttached(false);
            this.detachKinetics();
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128379_("OutputAttached", this.outputAttached);
        tag.m_128350_("OutputMultiplier", this.outputMultiplier);
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (tag.m_128441_("OutputAttached")) {
            this.outputAttached = tag.m_128471_("OutputAttached");
        }
        if (tag.m_128441_("OutputMultiplier")) {
            this.outputMultiplier = tag.m_128457_("OutputMultiplier");
        }
    }
}

