/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.createbigcannons.effects.particles.explosions;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.foundation.particle.ICustomParticleData;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import rbasamoyai.createbigcannons.effects.particles.explosions.ShellExplosionCloudParticle;
import rbasamoyai.createbigcannons.index.CBCParticleTypes;

public record ShellExplosionCloudParticleData(float scale, boolean isPlume) implements ParticleOptions,
ICustomParticleData<ShellExplosionCloudParticleData>
{
    private static final ParticleOptions.Deserializer<ShellExplosionCloudParticleData> DESERIALIZER = new ParticleOptions.Deserializer<ShellExplosionCloudParticleData>(){

        public ShellExplosionCloudParticleData fromCommand(ParticleType<ShellExplosionCloudParticleData> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float scale = reader.readFloat();
            reader.expect(' ');
            boolean isPlume = reader.readBoolean();
            return new ShellExplosionCloudParticleData(scale, isPlume);
        }

        public ShellExplosionCloudParticleData fromNetwork(ParticleType<ShellExplosionCloudParticleData> particleType, FriendlyByteBuf buffer) {
            return new ShellExplosionCloudParticleData(buffer.readFloat(), buffer.readBoolean());
        }
    };
    private static final Codec<ShellExplosionCloudParticleData> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.FLOAT.fieldOf("scale").forGetter(ShellExplosionCloudParticleData::scale), (App)Codec.BOOL.fieldOf("isPlume").forGetter(ShellExplosionCloudParticleData::isPlume)).apply((Applicative)i, ShellExplosionCloudParticleData::new));

    public ShellExplosionCloudParticleData() {
        this(0.0f, false);
    }

    public ParticleOptions.Deserializer<ShellExplosionCloudParticleData> getDeserializer() {
        return DESERIALIZER;
    }

    public Codec<ShellExplosionCloudParticleData> getCodec(ParticleType<ShellExplosionCloudParticleData> type) {
        return CODEC;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ParticleProvider<ShellExplosionCloudParticleData> getFactory() {
        return new ShellExplosionCloudParticle.Provider();
    }

    public ParticleType<?> m_6012_() {
        return CBCParticleTypes.SHELL_EXPLOSION_CLOUD.get();
    }

    public void m_7711_(FriendlyByteBuf buffer) {
        buffer.writeFloat(this.scale).writeBoolean(this.isPlume);
    }

    public String m_5942_() {
        return String.format("%f %b", Float.valueOf(this.scale), this.isPlume);
    }
}

