/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.ClockworkRenderTypes;
import org.valkyrienskies.clockwork.util.arc.ArcBias;
import org.valkyrienskies.clockwork.util.arc.LightningBolt;
import org.valkyrienskies.clockwork.util.render.TransformData;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\be\u0010fJ=\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\u000fJ5\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0010\u0010\u0011JU\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u001a\u0010\u001bJU\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u000b\u00a2\u0006\u0004\b\u000e\u0010\"J/\u0010\u001a\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020#2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001a\u0010&J\u0015\u0010)\u001a\u00020'2\u0006\u0010(\u001a\u00020'\u00a2\u0006\u0004\b)\u0010*J\u0015\u0010-\u001a\u00020,2\u0006\u0010+\u001a\u00020'\u00a2\u0006\u0004\b-\u0010.J\u0017\u0010/\u001a\u00020,2\u0006\u0010+\u001a\u00020'H\u0002\u00a2\u0006\u0004\b/\u0010.J3\u00105\u001a\b\u0012\u0004\u0012\u000201002\f\u00102\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00103\u001a\u00020,2\u0006\u00104\u001a\u00020'H\u0002\u00a2\u0006\u0004\b5\u00106JK\u0010;\u001a\b\u0012\u0004\u0012\u000201002\f\u00102\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00107\u001a\u0002012\u0006\u00108\u001a\u0002012\u0006\u00104\u001a\u00020'2\u0006\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020,H\u0002\u00a2\u0006\u0004\b;\u0010<J;\u0010=\u001a\b\u0012\u0004\u0012\u000201002\f\u00102\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00104\u001a\u00020'2\u0006\u00109\u001a\u00020,2\u0006\u0010:\u001a\u00020,H\u0002\u00a2\u0006\u0004\b=\u0010>J1\u0010C\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020100002\u0006\u0010@\u001a\u00020?2\u0006\u0010A\u001a\u00020'2\u0006\u0010B\u001a\u00020\t\u00a2\u0006\u0004\bC\u0010DJU\u0010P\u001a\u00020\r2\u0006\u0010F\u001a\u00020E2\u0006\u0010H\u001a\u00020G2\u0006\u0010I\u001a\u0002012\u0006\u0010J\u001a\u0002012\u0006\u0010K\u001a\u00020\t2\u0006\u0010L\u001a\u00020\t2\u0006\u0010M\u001a\u00020\t2\u0006\u0010N\u001a\u00020\t2\u0006\u0010O\u001a\u00020\t\u00a2\u0006\u0004\bP\u0010QJ\u0017\u0010S\u001a\u0002012\u0006\u0010R\u001a\u000201H\u0002\u00a2\u0006\u0004\bS\u0010TJ#\u0010W\u001a\u000e\u0012\u0004\u0012\u000201\u0012\u0004\u0012\u0002010V2\u0006\u0010U\u001a\u000201H\u0002\u00a2\u0006\u0004\bW\u0010XJ5\u0010\\\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00107\u001a\u0002012\u0006\u00108\u001a\u0002012\u0006\u0010Z\u001a\u00020Y2\u0006\u0010[\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\\\u0010]R\u0017\u0010_\u001a\u00020^8\u0006\u00a2\u0006\f\n\u0004\b_\u0010`\u001a\u0004\ba\u0010bR\u0017\u0010c\u001a\u00020^8\u0006\u00a2\u0006\f\n\u0004\bc\u0010`\u001a\u0004\bd\u0010b\u00a8\u0006g"}, d2={"Lorg/valkyrienskies/clockwork/util/render/RenderUtil;", "", "Lcom/mojang/blaze3d/vertex/PoseStack;", "matrices", "Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;", "renderer", "Lorg/valkyrienskies/clockwork/util/render/TransformData;", "innerData", "data", "", "scale", "", "light", "", "renderCubeMatrix", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;Lorg/valkyrienskies/clockwork/util/render/TransformData;Lorg/valkyrienskies/clockwork/util/render/TransformData;FI)V", "renderCube", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;Lorg/valkyrienskies/clockwork/util/render/TransformData;FI)V", "Ldev/engine_room/flywheel/lib/model/baked/PartialModel;", "model", "Lnet/minecraft/client/renderer/RenderType;", "renderType", "Lorg/joml/Vector3f;", "modelCorrection", "offset", "rotationVec", "renderAndTransform", "(Lcom/mojang/blaze3d/vertex/PoseStack;Ldev/engine_room/flywheel/lib/model/baked/PartialModel;Lnet/minecraft/client/renderer/RenderType;Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;Lorg/joml/Vector3f;Lorg/joml/Vector3f;Lorg/joml/Vector3f;FI)V", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "Lnet/minecraft/world/level/block/state/BlockState;", "blockState", "outerData", "overlay", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;Lnet/minecraft/world/level/block/state/BlockState;Lorg/valkyrienskies/clockwork/util/render/TransformData;Lorg/valkyrienskies/clockwork/util/render/TransformData;Lorg/valkyrienskies/clockwork/util/render/TransformData;FII)V", "Lnet/createmod/catnip/render/SuperByteBuffer;", "coreOffset", "coreRotation", "(Lnet/createmod/catnip/render/SuperByteBuffer;FLorg/joml/Vector3f;Lorg/joml/Vector3f;)Lnet/createmod/catnip/render/SuperByteBuffer;", "", "x", "hash64", "(J)J", "state", "", "rand01", "(J)D", "randSigned", "", "Lnet/minecraft/world/phys/Vec3;", "pts", "offsetMag", "seed", "subdivideOnce", "(Ljava/util/List;DJ)Ljava/util/List;", "start", "end", "time", "amount", "animateWiggle", "(Ljava/util/List;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;JDD)Ljava/util/List;", "animateWiggleLocalTangent", "(Ljava/util/List;JDD)Ljava/util/List;", "Lorg/valkyrienskies/clockwork/util/arc/LightningBolt;", "inst", "nowGameTime", "partialTick", "generatePolylinesFollow", "(Lorg/valkyrienskies/clockwork/util/arc/LightningBolt;JF)Ljava/util/List;", "Lcom/mojang/blaze3d/vertex/VertexConsumer;", "vc", "Lorg/joml/Matrix4f;", "pose", "a", "b", "thickness", "r", "g", "bl", "alpha", "addRibbonSegment", "(Lcom/mojang/blaze3d/vertex/VertexConsumer;Lorg/joml/Matrix4f;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;FFFFF)V", "v", "safeNormalize", "(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;", "axisN", "Lkotlin/Pair;", "buildBasis", "(Lnet/minecraft/world/phys/Vec3;)Lkotlin/Pair;", "Lorg/valkyrienskies/clockwork/util/arc/ArcBias;", "arcBias", "segments", "buildBackbone", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lorg/valkyrienskies/clockwork/util/arc/ArcBias;I)Ljava/util/List;", "Lnet/minecraft/resources/ResourceLocation;", "CRYSTAL_MATRIX", "Lnet/minecraft/resources/ResourceLocation;", "getCRYSTAL_MATRIX", "()Lnet/minecraft/resources/ResourceLocation;", "PURPLE_HUE", "getPURPLE_HUE", "<init>", "()V", "clockwork"})
public final class RenderUtil {
    @NotNull
    public static final RenderUtil INSTANCE = new RenderUtil();
    @NotNull
    private static final ResourceLocation CRYSTAL_MATRIX = ClockworkMod.asResource("textures/block/empty.png");
    @NotNull
    private static final ResourceLocation PURPLE_HUE = ClockworkMod.asResource("textures/block/purple_hue.png");

    private RenderUtil() {
    }

    @NotNull
    public final ResourceLocation getCRYSTAL_MATRIX() {
        return CRYSTAL_MATRIX;
    }

    @NotNull
    public final ResourceLocation getPURPLE_HUE() {
        return PURPLE_HUE;
    }

    public final void renderCubeMatrix(@NotNull PoseStack matrices, @NotNull PartialItemModelRenderer renderer, @NotNull TransformData innerData, @NotNull TransformData data, float scale, int light) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)innerData, (String)"innerData");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Vector3f modelOffset = new Vector3f(0.0f, -0.28125f, 0.0f);
        PartialModel partialModel = ClockworkPartials.INSTANCE.getCRYSTAL_INNER();
        RenderType renderType = RenderType.m_173239_();
        Intrinsics.checkNotNullExpressionValue((Object)renderType, (String)"endPortal(...)");
        this.renderAndTransform(matrices, partialModel, renderType, renderer, modelOffset, innerData.getOffset(), innerData.getRotation(), scale, light);
        PartialModel partialModel2 = ClockworkPartials.INSTANCE.getCRYSTAL();
        RenderType.CompositeRenderType compositeRenderType = ClockworkRenderTypes.Companion.getCRYSTAL().apply(CRYSTAL_MATRIX);
        Intrinsics.checkNotNullExpressionValue((Object)compositeRenderType, (String)"apply(...)");
        this.renderAndTransform(matrices, partialModel2, (RenderType)compositeRenderType, renderer, modelOffset, data.getOffset(), data.getRotation(), scale, light);
        PartialModel partialModel3 = ClockworkPartials.INSTANCE.getCRYSTAL_OUTER();
        RenderType renderType2 = RenderType.m_110473_((ResourceLocation)PURPLE_HUE);
        Intrinsics.checkNotNullExpressionValue((Object)renderType2, (String)"entityTranslucent(...)");
        this.renderAndTransform(matrices, partialModel3, renderType2, renderer, modelOffset, data.getOffset(), data.getRotation(), scale, light);
    }

    public final void renderCube(@NotNull PoseStack matrices, @NotNull PartialItemModelRenderer renderer, @NotNull TransformData data, float scale, int light) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Vector3f modelOffset = new Vector3f(0.0f, -0.28125f, 0.0f);
        PartialModel partialModel = ClockworkPartials.INSTANCE.getCRYSTAL();
        RenderType.CompositeRenderType compositeRenderType = ClockworkRenderTypes.Companion.getCRYSTAL().apply(CRYSTAL_MATRIX);
        Intrinsics.checkNotNullExpressionValue((Object)compositeRenderType, (String)"apply(...)");
        this.renderAndTransform(matrices, partialModel, (RenderType)compositeRenderType, renderer, modelOffset, data.getOffset(), data.getRotation(), scale, light);
        PartialModel partialModel2 = ClockworkPartials.INSTANCE.getCRYSTAL_OUTER();
        RenderType renderType = RenderType.m_110473_((ResourceLocation)PURPLE_HUE);
        Intrinsics.checkNotNullExpressionValue((Object)renderType, (String)"entityTranslucent(...)");
        this.renderAndTransform(matrices, partialModel2, renderType, renderer, modelOffset, data.getOffset(), data.getRotation(), scale, light);
    }

    public final void renderAndTransform(@NotNull PoseStack matrices, @NotNull PartialModel model, @NotNull RenderType renderType, @NotNull PartialItemModelRenderer renderer, @NotNull Vector3f modelCorrection, @NotNull Vector3f offset, @NotNull Vector3f rotationVec, float scale, int light) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)renderType, (String)"renderType");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)modelCorrection, (String)"modelCorrection");
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        Intrinsics.checkNotNullParameter((Object)rotationVec, (String)"rotationVec");
        matrices.m_85836_();
        matrices.m_85837_((double)offset.x(), (double)offset.y(), (double)offset.z());
        matrices.m_85837_(0.25, 0.25, 0.25);
        matrices.m_85836_();
        matrices.m_85841_(scale, scale, scale);
        matrices.m_85837_(-(1.0 / ((double)scale * (double)4)), -(1.0 / ((double)scale * (double)4)), -(1.0 / ((double)scale * (double)4)));
        matrices.m_85837_(-((double)modelCorrection.x()), -((double)modelCorrection.y()), -((double)modelCorrection.z()));
        new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)rotationVec.y()), 0.0f, 1.0f, 0.0f));
        new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)rotationVec.x()), 1.0f, 0.0f, 0.0f));
        new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)rotationVec.z()), 0.0f, 0.0f, 1.0f));
        matrices.m_85837_((double)modelCorrection.x(), (double)modelCorrection.y(), (double)modelCorrection.z());
        renderer.render(model.get(), renderType, light);
        matrices.m_85849_();
        matrices.m_85849_();
    }

    public final void renderCubeMatrix(@NotNull PoseStack matrices, @NotNull MultiBufferSource buffer, @NotNull BlockState blockState, @NotNull TransformData innerData, @NotNull TransformData data, @NotNull TransformData outerData, float scale, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        Intrinsics.checkNotNullParameter((Object)innerData, (String)"innerData");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)outerData, (String)"outerData");
        VertexConsumer crystal_inner_buffer = buffer.m_6299_(RenderType.m_173239_());
        SuperByteBuffer crystal_inner = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getCRYSTAL_INNER(), (BlockState)blockState);
        Intrinsics.checkNotNull((Object)crystal_inner);
        this.renderAndTransform(crystal_inner, scale, innerData.getOffset(), innerData.getRotation()).light(light).color(255, 255, 255, 255).overlay(overlay).disableDiffuse().renderInto(matrices, crystal_inner_buffer);
        VertexConsumer crystal_buffer = buffer.m_6299_((RenderType)ClockworkRenderTypes.Companion.getCRYSTAL().apply(CRYSTAL_MATRIX));
        SuperByteBuffer crystal = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getCRYSTAL(), (BlockState)blockState);
        Intrinsics.checkNotNull((Object)crystal);
        this.renderAndTransform(crystal, scale, data.getOffset(), data.getRotation()).light(light).color(255, 255, 255, 255).overlay(overlay).disableDiffuse().renderInto(matrices, crystal_buffer);
        VertexConsumer crystal_outer_buffer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)PURPLE_HUE));
        SuperByteBuffer crystal_outer = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getCRYSTAL_OUTER(), (BlockState)blockState);
        Intrinsics.checkNotNull((Object)crystal_outer);
        this.renderAndTransform(crystal_outer, scale, outerData.getOffset(), outerData.getRotation()).light(light).color(255, 255, 255, 255).overlay(overlay).renderInto(matrices, crystal_outer_buffer);
    }

    private final SuperByteBuffer renderAndTransform(SuperByteBuffer buffer, float scale, Vector3f coreOffset, Vector3f coreRotation) {
        buffer.scale(scale);
        buffer.translate(-(1.0 / ((double)scale * (double)4)), -(1.0 / ((double)scale * (double)4)), -(1.0 / ((double)scale * (double)4)));
        ((SuperByteBuffer)buffer.translateY(coreOffset.y * (float)2)).rotateCentered((float)((double)(coreRotation.y / (float)180) * Math.PI), Direction.UP);
        ((SuperByteBuffer)buffer.translateY(coreOffset.z * (float)2)).rotateCentered((float)((double)(coreRotation.z / (float)180) * Math.PI), Direction.NORTH);
        ((SuperByteBuffer)buffer.translateY(coreOffset.x * (float)2)).rotateCentered((float)((double)(coreRotation.x / (float)180) * Math.PI), Direction.EAST);
        buffer.translateY(-0.28125f);
        return buffer;
    }

    public final long hash64(long x) {
        long z = ULong.constructor-impl((long)(ULong.constructor-impl((long)x) + -7046029254386353131L));
        z = ULong.constructor-impl((long)(ULong.constructor-impl((long)(z ^ ULong.constructor-impl((long)(z >>> 30)))) * -4658895280553007687L));
        z = ULong.constructor-impl((long)(ULong.constructor-impl((long)(z ^ ULong.constructor-impl((long)(z >>> 27)))) * -7723592293110705685L));
        z = ULong.constructor-impl((long)(z ^ ULong.constructor-impl((long)(z >>> 31))));
        return z;
    }

    public final double rand01(long state) {
        long v = ULong.constructor-impl((long)(ULong.constructor-impl((long)this.hash64(state)) >>> 11));
        return (double)v * (double)1.110223E-16f;
    }

    private final double randSigned(long state) {
        return this.rand01(state) * 2.0 - 1.0;
    }

    private final List<Vec3> subdivideOnce(List<? extends Vec3> pts, double offsetMag, long seed) {
        if (pts.size() < 2) {
            return pts;
        }
        ArrayList<Object> out = new ArrayList<Object>(pts.size() * 2 - 1);
        int n = pts.size() - 1;
        for (int i = 0; i < n; ++i) {
            Vec3 a = pts.get(i);
            Vec3 b = pts.get(i + 1);
            out.add(a);
            Vec3 mid = a.m_82549_(b).m_82490_(0.5);
            Vec3 dir = b.m_82546_(a);
            double len = dir.m_82553_();
            Vec3 dirN = len > 1.0E-6 ? dir.m_82490_(1.0 / len) : new Vec3(0.0, 1.0, 0.0);
            Vec3 ref = Math.abs(dirN.f_82480_) < 0.9 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
            Vec3 u = dirN.m_82537_(ref).m_82541_();
            Vec3 v = dirN.m_82537_(u).m_82541_();
            double r0 = this.randSigned(seed + (long)i * 1315423911L);
            double r1 = this.randSigned(seed + (long)i * 2654435761L);
            Vec3 disp = u.m_82490_(r0 * offsetMag).m_82549_(v.m_82490_(r1 * offsetMag));
            out.add(mid.m_82549_(disp));
        }
        out.add(CollectionsKt.last(pts));
        return out;
    }

    private final List<Vec3> animateWiggle(List<? extends Vec3> pts, Vec3 start, Vec3 end, long seed, double time, double amount) {
        if (pts.size() <= 2) {
            return pts;
        }
        ArrayList<Vec3> out = new ArrayList<Vec3>(pts.size());
        out.add(start);
        Vec3 overallDir = end.m_82546_(start);
        double overallLen = RangesKt.coerceAtLeast((double)overallDir.m_82553_(), (double)1.0E-6);
        Vec3 overallN = overallDir.m_82490_(1.0 / overallLen);
        Vec3 ref = Math.abs(overallN.f_82480_) < 0.9 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
        Vec3 U = overallN.m_82537_(ref).m_82541_();
        Vec3 V = overallN.m_82537_(U).m_82541_();
        int n = pts.size() - 1;
        for (int i = 1; i < n; ++i) {
            double t = (double)i / (double)(pts.size() - 1);
            double f0 = 14.0 + 22.0 * this.rand01(seed + (long)i * 11L);
            double f1 = 14.0 + 22.0 * this.rand01(seed + (long)i * 19L);
            double ph0 = this.rand01(seed + (long)i * 23L) * Math.PI * 2.0;
            double ph1 = this.rand01(seed + (long)i * 29L) * Math.PI * 2.0;
            double s0 = Math.sin(time * f0 + ph0);
            double s1 = Math.sin(time * f1 + ph1);
            double taper = t * (1.0 - t) * 4.0;
            Vec3 disp = U.m_82490_(s0 * amount * taper).m_82549_(V.m_82490_(s1 * amount * taper));
            out.add(pts.get(i).m_82549_(disp));
        }
        out.add(end);
        return out;
    }

    private final List<Vec3> animateWiggleLocalTangent(List<? extends Vec3> pts, long seed, double time, double amount) {
        if (pts.size() <= 2) {
            return pts;
        }
        ArrayList<Object> out = new ArrayList<Object>(pts.size());
        out.add(CollectionsKt.first(pts));
        int n = pts.size() - 1;
        for (int i = 1; i < n; ++i) {
            Vec3 prev = pts.get(i - 1);
            Vec3 cur2 = pts.get(i);
            Vec3 next = pts.get(i + 1);
            Vec3 tangent = next.m_82546_(prev);
            double len = tangent.m_82553_();
            Vec3 tN = len > 1.0E-6 ? tangent.m_82490_(1.0 / len) : new Vec3(0.0, 1.0, 0.0);
            Vec3 ref = Math.abs(tN.f_82480_) < 0.9 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
            Vec3 u = tN.m_82537_(ref).m_82541_();
            Vec3 v = tN.m_82537_(u).m_82541_();
            double f0 = 14.0 + 22.0 * this.rand01(seed + (long)i * 11L);
            double f1 = 14.0 + 22.0 * this.rand01(seed + (long)i * 19L);
            double ph0 = this.rand01(seed + (long)i * 23L) * Math.PI * 2.0;
            double ph1 = this.rand01(seed + (long)i * 29L) * Math.PI * 2.0;
            double s0 = Math.sin(time * f0 + ph0);
            double s1 = Math.sin(time * f1 + ph1);
            double tt = (double)i / (double)(pts.size() - 1);
            double taper = tt * (1.0 - tt) * 4.0;
            Vec3 disp = u.m_82490_(s0 * amount * taper).m_82549_(v.m_82490_(s1 * amount * taper));
            out.add(cur2.m_82549_(disp));
        }
        out.add(CollectionsKt.last(pts));
        return out;
    }

    @NotNull
    public final List<List<Vec3>> generatePolylinesFollow(@NotNull LightningBolt inst, long nowGameTime, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)inst, (String)"inst");
        Vec3 start = (Vec3)inst.getStartProvider().invoke();
        Vec3 end = (Vec3)inst.getEndProvider().invoke();
        int backboneSegments = 8;
        List<Vec3> pts = null;
        pts = this.buildBackbone(start, end, inst.getArcBias(), backboneSegments);
        double mag = 0.0;
        mag = inst.getMaxOffset();
        int n = inst.getSubdivisions();
        int n2 = 0;
        while (n2 < n) {
            int s = n2++;
            boolean bl = false;
            pts = INSTANCE.subdivideOnce(pts, mag, inst.getSeed() + (long)s * 99991L);
            mag *= 0.55;
        }
        double wiggleSpeed = 3.0;
        double rawTime = ((double)nowGameTime + (double)partialTick) / 20.0 * wiggleSpeed;
        double time = Math.floor(rawTime * 12.0) / 12.0;
        pts = Intrinsics.areEqual((Object)inst.getArcBias(), (Object)ArcBias.None.INSTANCE) ? this.animateWiggle(pts, start, end, inst.getSeed() ^ 0xCAFEBABEL, time, inst.getMaxOffset() * 0.18) : this.animateWiggleLocalTangent(pts, inst.getSeed() ^ 0xDEADBEEFL, time, inst.getMaxOffset() * 0.18);
        ArrayList<List<Vec3>> lines = new ArrayList<List<Vec3>>();
        lines.add(pts);
        int n3 = pts.size() - 1;
        for (int i = 1; i < n3; ++i) {
            if (this.rand01(inst.getSeed() + (long)i * 8191L) >= inst.getBranchChance()) continue;
            Vec3 p = pts.get(i);
            Vec3 trunk = pts.get(i + 1).m_82546_(pts.get(i - 1)).m_82541_();
            Vec3 ref = Math.abs(trunk.f_82480_) < 0.9 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
            Vec3 u = trunk.m_82537_(ref).m_82541_();
            Vec3 v = trunk.m_82537_(u).m_82541_();
            Vec3 bdir = u.m_82490_(this.randSigned(inst.getSeed() + (long)i * 17L)).m_82549_(v.m_82490_(this.randSigned(inst.getSeed() + (long)i * 31L))).m_82541_();
            double trunkT = (double)i / (double)(pts.size() - 1);
            double branchTaper = inst.getBranchTaper() ? RangesKt.coerceIn((double)(1.0 - trunkT), (double)0.0, (double)1.0) : 1.0;
            double len = start.m_82554_(end) * inst.getBranchScale() * (0.6 + 0.4 * this.rand01(inst.getSeed() + (long)i * 43L)) * branchTaper;
            Vec3 bend = p.m_82549_(bdir.m_82490_(len));
            List<Vec3> bPts = null;
            Object[] objectArray = new Vec3[]{p, bend};
            bPts = CollectionsKt.listOf((Object[])objectArray);
            double bMag = 0.0;
            bMag = inst.getMaxOffset() * inst.getBranchScale();
            int n4 = RangesKt.coerceAtLeast((int)(inst.getSubdivisions() - 2), (int)2);
            int n5 = 0;
            while (n5 < n4) {
                int s = n5++;
                boolean bl = false;
                bPts = INSTANCE.subdivideOnce((List<? extends Vec3>)bPts, bMag, inst.getSeed() + (long)11259375 + (long)i * 1009L + (long)s * 131L);
                bMag *= 0.6;
            }
            Intrinsics.checkNotNull((Object)bend);
            bPts = this.animateWiggle((List<? extends Vec3>)bPts, p, bend, inst.getSeed() ^ (long)i << 32, time, inst.getMaxOffset() * 0.12 * inst.getBranchScale());
            lines.add(bPts);
        }
        return lines;
    }

    public final void addRibbonSegment(@NotNull VertexConsumer vc, @NotNull Matrix4f pose, @NotNull Vec3 a, @NotNull Vec3 b, float thickness, float r, float g, float bl, float alpha) {
        Vec3 mid;
        Vec3 view;
        Intrinsics.checkNotNullParameter((Object)vc, (String)"vc");
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        Vec3 dir = b.m_82546_(a);
        double len = dir.m_82553_();
        if (len < 1.0E-6) {
            return;
        }
        Vec3 dirN = dir.m_82490_(1.0 / len);
        Vec3 side = dirN.m_82537_(view = (mid = a.m_82549_(b).m_82490_(0.5)).m_82541_());
        if (side.m_82553_() < 1.0E-6 && (side = dirN.m_82537_(new Vec3(0.0, 1.0, 0.0))).m_82553_() < 1.0E-6) {
            side = dirN.m_82537_(new Vec3(1.0, 0.0, 0.0));
        }
        Vec3 sideN = side.m_82541_().m_82490_((double)thickness);
        Vec3 aL = a.m_82546_(sideN);
        Vec3 aR = a.m_82549_(sideN);
        Vec3 bL = b.m_82546_(sideN);
        Vec3 bR = b.m_82549_(sideN);
        vc.m_252986_(pose, (float)aL.f_82479_, (float)aL.f_82480_, (float)aL.f_82481_).m_85950_(r, g, bl, alpha).m_7421_(0.0f, 0.0f).m_5752_();
        vc.m_252986_(pose, (float)aR.f_82479_, (float)aR.f_82480_, (float)aR.f_82481_).m_85950_(r, g, bl, alpha).m_7421_(1.0f, 0.0f).m_5752_();
        vc.m_252986_(pose, (float)bR.f_82479_, (float)bR.f_82480_, (float)bR.f_82481_).m_85950_(r, g, bl, alpha).m_7421_(1.0f, 1.0f).m_5752_();
        vc.m_252986_(pose, (float)bL.f_82479_, (float)bL.f_82480_, (float)bL.f_82481_).m_85950_(r, g, bl, alpha).m_7421_(0.0f, 1.0f).m_5752_();
    }

    private final Vec3 safeNormalize(Vec3 v) {
        Vec3 vec3;
        if (v.m_82556_() > 1.0E-12) {
            Vec3 vec32 = v.m_82541_();
            vec3 = vec32;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"normalize(...)");
        } else {
            Vec3 vec33 = Vec3.f_82478_;
            vec3 = vec33;
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"ZERO");
        }
        return vec3;
    }

    private final Pair<Vec3, Vec3> buildBasis(Vec3 axisN) {
        Vec3 ref = Math.abs(axisN.f_82480_) < 0.9 ? new Vec3(0.0, 1.0, 0.0) : new Vec3(1.0, 0.0, 0.0);
        Vec3 vec3 = axisN.m_82537_(ref);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"cross(...)");
        Vec3 u = this.safeNormalize(vec3);
        Vec3 vec32 = axisN.m_82537_(u);
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"cross(...)");
        Vec3 v = this.safeNormalize(vec32);
        return TuplesKt.to((Object)u, (Object)v);
    }

    private final List<Vec3> buildBackbone(Vec3 start, Vec3 end, ArcBias arcBias, int segments) {
        ArrayList<Vec3> out = new ArrayList<Vec3>(segments + 1);
        Vec3 chord = end.m_82546_(start);
        int i = 0;
        if (i <= segments) {
            while (true) {
                double t = (double)i / (double)segments;
                Vec3 p = start.m_82549_(chord.m_82490_(t));
                double envelope = 4.0 * t * (1.0 - t);
                ArcBias arcBias2 = arcBias;
                if (!Intrinsics.areEqual((Object)arcBias2, (Object)ArcBias.None.INSTANCE)) {
                    if (arcBias2 instanceof ArcBias.Parabola) {
                        dir = this.safeNormalize(((ArcBias.Parabola)arcBias).getDirection());
                        p = p.m_82549_(dir.m_82490_(((ArcBias.Parabola)arcBias).getStrength() * envelope));
                    } else if (arcBias2 instanceof ArcBias.DoubleHump) {
                        dir = this.safeNormalize(((ArcBias.DoubleHump)arcBias).getDirection());
                        double wave = -Math.sin(t * Math.PI * 2.0);
                        p = p.m_82549_(dir.m_82490_(((ArcBias.DoubleHump)arcBias).getStrength() * wave * envelope));
                    } else if (arcBias2 instanceof ArcBias.SineWave) {
                        dir = this.safeNormalize(((ArcBias.SineWave)arcBias).getDirection());
                        double wave = Math.sin(t * Math.PI * 2.0 * ((ArcBias.SineWave)arcBias).getFrequency());
                        p = p.m_82549_(dir.m_82490_(((ArcBias.SineWave)arcBias).getStrength() * wave * envelope));
                    } else if (arcBias2 instanceof ArcBias.Spiral) {
                        Pair<Vec3, Vec3> pair = ((ArcBias.Spiral)arcBias).getAxis();
                        if (pair == null) {
                            pair = chord;
                        }
                        Pair<Vec3, Vec3> pair2 = pair;
                        Intrinsics.checkNotNull((Object)pair2);
                        axisN = this.safeNormalize((Vec3)pair2);
                        pair2 = this.buildBasis(axisN);
                        u = (Vec3)pair2.component1();
                        v = (Vec3)pair2.component2();
                        theta = t * ((ArcBias.Spiral)arcBias).getTurns() * (Math.PI * 2) + ((ArcBias.Spiral)arcBias).getPhase();
                        double ramp = ((ArcBias.Spiral)arcBias).getRadiusStartMul() + (((ArcBias.Spiral)arcBias).getRadiusEndMul() - ((ArcBias.Spiral)arcBias).getRadiusStartMul()) * t;
                        double r = ((ArcBias.Spiral)arcBias).getRadius() * ramp * envelope;
                        Vec3 offset = u.m_82490_(Math.cos(theta) * r).m_82549_(v.m_82490_(Math.sin(theta) * r));
                        p = p.m_82549_(offset);
                    } else if (arcBias2 instanceof ArcBias.DoubleHelix) {
                        Pair<Vec3, Vec3> pair = ((ArcBias.DoubleHelix)arcBias).getAxis();
                        if (pair == null) {
                            pair = chord;
                        }
                        Pair<Vec3, Vec3> pair3 = pair;
                        Intrinsics.checkNotNull((Object)pair3);
                        axisN = this.safeNormalize((Vec3)pair3);
                        pair3 = this.buildBasis(axisN);
                        u = (Vec3)pair3.component1();
                        v = (Vec3)pair3.component2();
                        theta = t * ((ArcBias.DoubleHelix)arcBias).getTurns() * (Math.PI * 2) + ((ArcBias.DoubleHelix)arcBias).getPhase();
                        double sep = RangesKt.coerceIn((double)((ArcBias.DoubleHelix)arcBias).getStrandSeparation(), (double)0.0, (double)1.0);
                        double mod = 1.0 + sep * Math.cos(2.0 * theta);
                        double r = ((ArcBias.DoubleHelix)arcBias).getRadius() * mod * envelope;
                        Vec3 offset = u.m_82490_(Math.cos(theta) * r).m_82549_(v.m_82490_(Math.sin(theta) * r));
                        p = p.m_82549_(offset);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                out.add(p);
                if (i == segments) break;
                ++i;
            }
        }
        return out;
    }
}

