/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util.gui;

import com.simibubi.create.foundation.item.TooltipModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkGasses;
import org.valkyrienskies.clockwork.platform.PlatformUtils;
import org.valkyrienskies.clockwork.util.gui.IHaveDuctStats;
import org.valkyrienskies.clockwork.util.gui.ProductionInfo;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0004\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/valkyrienskies/clockwork/util/gui/DuctStats;", "Lcom/simibubi/create/foundation/item/TooltipModifier;", "Lnet/minecraft/world/level/block/Block;", "block", "Lnet/minecraft/world/level/block/Block;", "getBlock", "()Lnet/minecraft/world/level/block/Block;", "<init>", "(Lnet/minecraft/world/level/block/Block;)V", "Companion", "clockwork"})
public abstract class DuctStats
implements TooltipModifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Block block;

    public DuctStats(@NotNull Block block) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        this.block = block;
    }

    @NotNull
    public final Block getBlock() {
        return this.block;
    }

    @JvmStatic
    @NotNull
    public static final List<Component> getDuctStats(@NotNull Block block, @NotNull Player player) {
        return Companion.getDuctStats(block, player);
    }

    @JvmStatic
    @Nullable
    public static final DuctStats create(@NotNull Item item) {
        return Companion.create(item);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J%\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/clockwork/util/gui/DuctStats$Companion;", "", "Lnet/minecraft/world/level/block/Block;", "block", "Lnet/minecraft/world/entity/player/Player;", "player", "", "Lnet/minecraft/network/chat/Component;", "getDuctStats", "(Lnet/minecraft/world/level/block/Block;Lnet/minecraft/world/entity/player/Player;)Ljava/util/List;", "Lnet/minecraft/world/item/Item;", "item", "Lorg/valkyrienskies/clockwork/util/gui/DuctStats;", "create", "(Lnet/minecraft/world/item/Item;)Lorg/valkyrienskies/clockwork/util/gui/DuctStats;", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final List<Component> getDuctStats(@NotNull Block block, @NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            List list = new ArrayList();
            if (block instanceof IHaveDuctStats) {
                List<Component> additional;
                double internalVolume = ((IHaveDuctStats)block).getInternalVolume();
                double maxTemperature = ((IHaveDuctStats)block).getMaximumTemperature();
                double maxPressure = ((IHaveDuctStats)block).getMaximumPressure();
                ((Collection)list).add(Component.m_237115_((String)"vs_clockwork.duct_stats.header").m_130940_(ChatFormatting.GRAY));
                ((Collection)list).add(Component.m_237115_((String)"vs_clockwork.duct_stats.internal_volume").m_130946_(" " + internalVolume + " m\u00b3").m_130940_(ChatFormatting.GREEN));
                ((Collection)list).add(Component.m_237115_((String)"vs_clockwork.duct_stats.max_temperature").m_130946_(" " + maxTemperature + " K").m_130940_(ChatFormatting.RED));
                ((Collection)list).add(Component.m_237115_((String)"vs_clockwork.duct_stats.max_pressure").m_130946_(" " + maxPressure / (double)1000 + " kPa").m_130940_(ChatFormatting.BLUE));
                Map<ResourceLocation, ProductionInfo> productionStats = ((IHaveDuctStats)block).getProductionStats();
                if (!productionStats.isEmpty()) {
                    ((Collection)list).add(CommonComponents.f_237098_);
                    ((Collection)list).add(Component.m_237115_((String)"vs_clockwork.duct_stats.is_producer").m_130940_(ChatFormatting.GOLD));
                    for (Map.Entry<ResourceLocation, ProductionInfo> entry : productionStats.entrySet()) {
                        ResourceLocation key = entry.getKey();
                        ProductionInfo info = entry.getValue();
                        GasType gasType = GasTypeRegistry.INSTANCE.getGasType(key);
                        Intrinsics.checkNotNull((Object)gasType);
                        MutableComponent iconComponent = Component.m_237113_((String)ClockworkGasses.getDisplayCharacterCode(gasType)).m_130938_(Companion::getDuctStats$lambda$0);
                        MutableComponent methodComponent = Component.m_237115_((String)info.getMethod().getLangKey());
                        MutableComponent typeComponent = Component.m_237115_((String)info.getType().getLangKey());
                        MutableComponent fullComponent = Component.m_237119_().m_7220_((Component)iconComponent).m_130946_(" - ").m_7220_((Component)methodComponent).m_130946_(" (").m_7220_((Component)typeComponent);
                        if (((CharSequence)info.getCondition().toString()).length() > 0) {
                            fullComponent = fullComponent.m_7220_(info.getCondition());
                        }
                        fullComponent = fullComponent.m_130946_(")");
                        ((Collection)list).add(fullComponent.m_130940_(ChatFormatting.WHITE));
                    }
                }
                if (!((Collection)(additional = ((IHaveDuctStats)block).getAdditionalInfoLines())).isEmpty()) {
                    ((Collection)list).add(CommonComponents.f_237098_);
                    list.addAll((Collection)additional);
                }
            }
            return list;
        }

        @JvmStatic
        @Nullable
        public final DuctStats create(@NotNull Item item) {
            Block block;
            Intrinsics.checkNotNullParameter((Object)item, (String)"item");
            if (item instanceof BlockItem && (block = ((BlockItem)item).m_40614_()) instanceof IHaveDuctStats) {
                return PlatformUtils.getDuctStats(block);
            }
            return null;
        }

        private static final Style getDuctStats$lambda$0(Style it) {
            return it.m_131150_(ClockworkGasses.getICON_FONT_LOCATION());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

