/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.forces.BalloonController;
import org.valkyrienskies.clockwork.content.forces.data.BalloonData;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lorg/valkyrienskies/clockwork/util/BlockUpdateCollector;", "", "Lnet/minecraft/server/level/ServerLevel;", "sLevel", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "", "onSetBlock", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "<init>", "()V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nBlockUpdateCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BlockUpdateCollector.kt\norg/valkyrienskies/clockwork/util/BlockUpdateCollector\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,75:1\n216#2,2:76\n*S KotlinDebug\n*F\n+ 1 BlockUpdateCollector.kt\norg/valkyrienskies/clockwork/util/BlockUpdateCollector\n*L\n20#1:76,2\n*E\n"})
public final class BlockUpdateCollector {
    @NotNull
    public static final BlockUpdateCollector INSTANCE = new BlockUpdateCollector();

    private BlockUpdateCollector() {
    }

    public final void onSetBlock(@NotNull ServerLevel sLevel, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)sLevel, (String)"sLevel");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        LoadedServerShip ship = VSGameUtilsKt.getLoadedShipManagingPos((ServerLevel)sLevel, (Vec3i)((Vec3i)pos));
        if (ship != null) {
            int id;
            BalloonController controller = BalloonController.Companion.getOrCreate(ship);
            ArrayList<Integer> shouldUpdate = new ArrayList<Integer>();
            ArrayList<Integer> shouldValidate = new ArrayList<Integer>();
            Object $this$forEach$iv = controller.getBalloons();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                int id2 = ((Number)entry.getKey()).intValue();
                BalloonData balloon = (BalloonData)entry.getValue();
                Set<BlockPos> external = balloon.getExternalPositions();
                if (BalloonController.Companion.isValidBalloonEnclosure(state, (Level)sLevel, pos)) {
                    if (balloon.containsPosition(pos)) {
                        shouldUpdate.add(id2);
                        balloon.setShouldReScan(true);
                        shouldValidate.add(id2);
                    }
                    if (external.contains(pos)) {
                        balloon.validate((Level)sLevel);
                    }
                }
                if (BalloonController.Companion.isValidBalloonEnclosure(state, (Level)sLevel, pos)) continue;
                shouldValidate.add(id2);
                balloon.setShouldReScan(true);
            }
            if (shouldUpdate.size() > 1) {
                ClockworkMod.INSTANCE.getLOGGER().warn("A block at " + pos + " somehow induced a split inside multiple balloons simultaneously. Sus...");
            }
            Iterator iterator2 = shouldUpdate.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            $this$forEach$iv = iterator2;
            while ($this$forEach$iv.hasNext()) {
                Iterator iterator3;
                Pair<Boolean, ArrayList<BalloonData>> result;
                Object e = $this$forEach$iv.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                id = ((Number)e).intValue();
                Pair<Boolean, ArrayList<BalloonData>> pair = controller.getBalloons().get(id);
                if (pair == null) continue;
                if ((pair = pair.trySplit((Level)sLevel)) == null || !((Boolean)(result = pair).getFirst()).booleanValue() || !(!((Collection)result.getSecond()).isEmpty())) continue;
                Intrinsics.checkNotNullExpressionValue(((ArrayList)result.getSecond()).iterator(), (String)"iterator(...)");
                while (iterator3.hasNext()) {
                    Object e2 = iterator3.next();
                    Intrinsics.checkNotNullExpressionValue(e2, (String)"next(...)");
                    BalloonData newBalloon = (BalloonData)e2;
                    controller.addBalloon(newBalloon);
                }
            }
            if (shouldValidate.size() > 1) {
                BalloonData balloonData = controller.getBalloons().get(shouldValidate.get(0));
                Intrinsics.checkNotNull((Object)balloonData);
                BalloonData baseMergedBalloon = balloonData;
                BalloonData.EnclosureStatus status = BalloonData.EnclosureStatus.VALID;
                int n = controller.getBalloons().size();
                for (int x = 1; x < n; ++x) {
                    if (controller.getBalloons().get(x) == null) continue;
                    BalloonData balloonData2 = controller.getBalloons().get(x);
                    Intrinsics.checkNotNull((Object)balloonData2);
                    status = status.weakestOf(baseMergedBalloon.mergeWith(balloonData2, (Level)sLevel));
                    BalloonData balloonData3 = controller.getBalloons().get(x);
                    Intrinsics.checkNotNull((Object)balloonData3);
                    balloonData3.setShouldRemove(true);
                }
                if (!status.isAtLeast(BalloonData.EnclosureStatus.UNKNOWN)) {
                    baseMergedBalloon.setShouldRemove(true);
                }
            } else {
                Iterator iterator4 = shouldValidate.iterator();
                Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
                Iterator iterator5 = iterator4;
                while (iterator5.hasNext()) {
                    Object e = iterator5.next();
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    id = ((Number)e).intValue();
                    BalloonData balloon = controller.getBalloons().get(id);
                    if (balloon == null) continue;
                    balloon.setShouldValidate(true);
                }
            }
        }
    }
}

