/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.forge;

import dev.architectury.platform.Platform;
import dev.architectury.platform.forge.EventBuses;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.RegisterEvent;
import org.valkyrienskies.clockwork.ClockworkBlockEntities;
import org.valkyrienskies.clockwork.ClockworkBlocks;
import org.valkyrienskies.clockwork.ClockworkConfigUpdater;
import org.valkyrienskies.clockwork.ClockworkContraptions;
import org.valkyrienskies.clockwork.ClockworkEntities;
import org.valkyrienskies.clockwork.ClockworkItems;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkPackets;
import org.valkyrienskies.clockwork.ClockworkParticles;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.forge.CCTweakedForgeEvents;
import org.valkyrienskies.clockwork.forge.ClockworkModForgeClient;
import org.valkyrienskies.clockwork.forge.ForgeClockworkEntities;
import org.valkyrienskies.clockwork.util.AtmosphereParametersResolver;

@Mod(value="vs_clockwork")
public class ClockworkModForge {
    public ClockworkModForge(FMLJavaModLoadingContext context) {
        IEventBus modEventBus = context.getModEventBus();
        context.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ClockworkConfigUpdater.INSTANCE.getSERVER_SPEC(), "valkyrienskies/clockwork/server.toml");
        context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClockworkConfigUpdater.INSTANCE.getCLIENT_SPEC(), "valkyrienskies/clockwork/client.toml");
        modEventBus.addListener(this::onConfigLoading);
        modEventBus.addListener(this::onConfigReloading);
        if (Platform.isModLoaded((String)"computercraft")) {
            MinecraftForge.EVENT_BUS.register((Object)new CCTweakedForgeEvents());
        }
        EventBuses.registerModEventBus((String)"vs_clockwork", (IEventBus)modEventBus);
        ClockworkMod.INSTANCE.getREGISTRATE().registerEventListeners(modEventBus);
        ClockworkSounds.register();
        ClockworkParticles.init();
        ClockworkBlocks.register();
        ClockworkItems.register();
        ClockworkBlockEntities.register();
        modEventBus.addListener(this::onRegister);
        ClockworkEntities.register();
        ForgeClockworkEntities.register();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modEventBus.addListener(event -> ClockworkParticles.initClient(event)));
        ClockworkPackets.init();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClockworkModForgeClient.onCtorClient(modEventBus));
        modEventBus.addListener(this::onClientSetup);
        MinecraftForge.EVENT_BUS.addListener(this::registerResourceManagers);
        modEventBus.addListener(ClockworkModForge::init);
        ClockworkMod.init();
        modEventBus.addListener(this::onTabModify);
    }

    private void onConfigLoading(ModConfigEvent.Loading event) {
        ClockworkConfigUpdater.INSTANCE.update(event.getConfig());
    }

    private void onConfigReloading(ModConfigEvent.Reloading event) {
        ClockworkConfigUpdater.INSTANCE.update(event.getConfig());
    }

    private void onRegister(RegisterEvent evt) {
        ClockworkContraptions.init();
    }

    private void registerResourceManagers(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)AtmosphereParametersResolver.INSTANCE);
    }

    private void onTabModify(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == ClockworkMod.INSTANCE.getBASE_CREATIVE_TABINFO()) {
            event.m_246326_((ItemLike)ClockworkBlocks.BALLOON_CASING.m_5456_());
        }
    }

    public static void init(FMLCommonSetupEvent event) {
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ClockworkBlocks.GOO_BLOCK.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ClockworkBlocks.SLICKER.get()), (RenderType)RenderType.m_110466_());
    }
}

