/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.solid.delivery.cannon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkBlocks;
import org.valkyrienskies.clockwork.ClockworkLang;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.content.logistics.solid.delivery.ActiveChutes;
import org.valkyrienskies.clockwork.content.logistics.solid.delivery.chute.DeliveryChuteBlockEntity;
import org.valkyrienskies.clockwork.content.logistics.solid.delivery.frequency_slot.FrequencySlotBehaviour;
import org.valkyrienskies.clockwork.platform.SolidDeliveryMethods;
import org.valkyrienskies.clockwork.util.ClockworkUtils;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.world.RaycastUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u0098\u00012\u00020\u00012\u00020\u0002:\u0006\u0098\u0001\u0099\u0001\u009a\u0001B0\u0012\u000e\u0010\u0092\u0001\u001a\t\u0012\u0002\b\u0003\u0018\u00010\u0091\u0001\u0012\t\u0010\u0093\u0001\u001a\u0004\u0018\u00010J\u0012\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0094\u0001\u00a2\u0006\u0006\b\u0096\u0001\u0010\u0097\u0001J\u001d\u0010\u0007\u001a\u00020\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000b\u0010\nJ\r\u0010\f\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\nJ\u0015\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\r\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\"\u001a\u00020!2\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b\"\u0010#J\u001f\u0010'\u001a\u00020\u00062\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010)\u001a\u00020\u00062\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0012H\u0014\u00a2\u0006\u0004\b)\u0010(R\"\u0010+\u001a\u00020*8\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R(\u00103\u001a\b\u0012\u0004\u0012\u000202018\u0006@\u0006X\u0086.\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\"\u0010:\u001a\u0002098\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\"\u0010@\u001a\u0002098\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b@\u0010;\u001a\u0004\bA\u0010=\"\u0004\bB\u0010?R\"\u0010C\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bC\u0010D\u001a\u0004\bE\u0010F\"\u0004\bG\u0010HR(\u0010K\u001a\b\u0012\u0004\u0012\u00020J0I8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010L\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\"\u0010Q\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bQ\u0010D\u001a\u0004\bR\u0010F\"\u0004\bS\u0010HR\"\u0010T\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bT\u0010D\u001a\u0004\bU\u0010F\"\u0004\bV\u0010HR$\u0010W\u001a\u0004\u0018\u00010J8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bW\u0010X\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R*\u0010_\u001a\n ^*\u0004\u0018\u00010]0]8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b_\u0010`\u001a\u0004\ba\u0010b\"\u0004\bc\u0010dR*\u0010e\u001a\n ^*\u0004\u0018\u00010]0]8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\be\u0010`\u001a\u0004\bf\u0010b\"\u0004\bg\u0010dR*\u0010h\u001a\n ^*\u0004\u0018\u00010]0]8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bh\u0010`\u001a\u0004\bi\u0010b\"\u0004\bj\u0010dR\u001f\u0010l\u001a\n ^*\u0004\u0018\u00010k0k8\u0006\u00a2\u0006\f\n\u0004\bl\u0010m\u001a\u0004\bn\u0010oR\"\u0010p\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bp\u0010D\u001a\u0004\bq\u0010F\"\u0004\br\u0010HR\"\u0010t\u001a\u00020s8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bt\u0010u\u001a\u0004\bv\u0010w\"\u0004\bx\u0010yR\"\u0010z\u001a\u00020s8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bz\u0010u\u001a\u0004\b{\u0010w\"\u0004\b|\u0010yR\"\u0010}\u001a\u00020s8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b}\u0010u\u001a\u0004\b~\u0010w\"\u0004\b\u007f\u0010yR&\u0010\u0080\u0001\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0015\n\u0005\b\u0080\u0001\u0010D\u001a\u0005\b\u0081\u0001\u0010F\"\u0005\b\u0082\u0001\u0010HR)\u0010\u0083\u0001\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0006\b\u0083\u0001\u0010\u0084\u0001\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001\"\u0006\b\u0087\u0001\u0010\u0088\u0001R\u0013\u0010\u008a\u0001\u001a\u00020!8F\u00a2\u0006\u0007\u001a\u0005\b\u0089\u0001\u0010FR\u0014\u0010\u008d\u0001\u001a\u00020\u001f8F\u00a2\u0006\b\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001R\u0014\u0010\u008e\u0001\u001a\u00020\u00128F\u00a2\u0006\b\u001a\u0006\b\u008e\u0001\u0010\u0086\u0001R\u0013\u0010\u0090\u0001\u001a\u00020!8F\u00a2\u0006\u0007\u001a\u0005\b\u008f\u0001\u0010F\u00a8\u0006\u009b\u0001"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonBlockEntity;", "Lcom/simibubi/create/foundation/blockEntity/SmartBlockEntity;", "Lcom/simibubi/create/api/equipment/goggles/IHaveGoggleInformation;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "lazyTick", "()V", "tick", "reset", "Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/chute/DeliveryChuteBlockEntity;", "chuteBlockEntity", "updateAngleChaser", "(Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/chute/DeliveryChuteBlockEntity;)V", "chute", "", "isObstructed", "(Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/chute/DeliveryChuteBlockEntity;)Z", "Lnet/minecraft/world/phys/Vec3;", "from", "to", "Lnet/minecraft/world/phys/BlockHitResult;", "clip", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/BlockHitResult;", "", "count", "addGunpowderTicks", "(I)V", "Lorg/joml/Vector3d;", "vec", "", "getParabolaY", "(Lorg/joml/Vector3d;)D", "Lnet/minecraft/nbt/CompoundTag;", "tag", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "write", "Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/frequency_slot/FrequencySlotBehaviour;", "frequencySlotBehaviour", "Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/frequency_slot/FrequencySlotBehaviour;", "getFrequencySlotBehaviour", "()Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/frequency_slot/FrequencySlotBehaviour;", "setFrequencySlotBehaviour", "(Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/frequency_slot/FrequencySlotBehaviour;)V", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonBlockEntity$DistributionMode;", "distributionModeBehaviour", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "getDistributionModeBehaviour", "()Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;", "setDistributionModeBehaviour", "(Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/ScrollOptionBehaviour;)V", "Lnet/minecraft/world/item/ItemStack;", "currentStack", "Lnet/minecraft/world/item/ItemStack;", "getCurrentStack", "()Lnet/minecraft/world/item/ItemStack;", "setCurrentStack", "(Lnet/minecraft/world/item/ItemStack;)V", "midAirStack", "getMidAirStack", "setMidAirStack", "lastVel", "D", "getLastVel", "()D", "setLastVel", "(D)V", "Ljava/util/HashSet;", "Lnet/minecraft/core/BlockPos;", "visitedChutes", "Ljava/util/HashSet;", "getVisitedChutes", "()Ljava/util/HashSet;", "setVisitedChutes", "(Ljava/util/HashSet;)V", "cooldown", "getCooldown", "setCooldown", "gunpowderTicks", "getGunpowderTicks", "setGunpowderTicks", "shootingAtChute", "Lnet/minecraft/core/BlockPos;", "getShootingAtChute", "()Lnet/minecraft/core/BlockPos;", "setShootingAtChute", "(Lnet/minecraft/core/BlockPos;)V", "Lnet/createmod/catnip/animation/LerpedFloat;", "kotlin.jvm.PlatformType", "xRot", "Lnet/createmod/catnip/animation/LerpedFloat;", "getXRot", "()Lnet/createmod/catnip/animation/LerpedFloat;", "setXRot", "(Lnet/createmod/catnip/animation/LerpedFloat;)V", "yRot", "getYRot", "setYRot", "distance", "getDistance", "setDistance", "Lnet/minecraft/util/RandomSource;", "soundRandom", "Lnet/minecraft/util/RandomSource;", "getSoundRandom", "()Lnet/minecraft/util/RandomSource;", "clientShotProgress", "getClientShotProgress", "setClientShotProgress", "", "clientBarrelOffset", "F", "getClientBarrelOffset", "()F", "setClientBarrelOffset", "(F)V", "clientCannonRotationOffset", "getClientCannonRotationOffset", "setClientCannonRotationOffset", "clientAntennaRotationOffset", "getClientAntennaRotationOffset", "setClientAntennaRotationOffset", "clientItemRotation", "getClientItemRotation", "setClientItemRotation", "fired", "Z", "getFired", "()Z", "setFired", "(Z)V", "getGunpowderedCoefficient", "gunpowderedCoefficient", "getRealPos", "()Lorg/joml/Vector3d;", "realPos", "isRoundRobin", "getDefaultXrot", "defaultXrot", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "Companion", "FrequencySlot", "DistributionMode", "clockwork"})
public final class DeliveryCannonBlockEntity
extends SmartBlockEntity
implements IHaveGoggleInformation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public FrequencySlotBehaviour frequencySlotBehaviour;
    public ScrollOptionBehaviour<DistributionMode> distributionModeBehaviour;
    @NotNull
    private ItemStack currentStack;
    @NotNull
    private ItemStack midAirStack;
    private double lastVel;
    @NotNull
    private HashSet<BlockPos> visitedChutes;
    private double cooldown;
    private double gunpowderTicks;
    @Nullable
    private BlockPos shootingAtChute;
    private LerpedFloat xRot;
    private LerpedFloat yRot;
    private LerpedFloat distance;
    private final RandomSource soundRandom;
    private double clientShotProgress;
    private float clientBarrelOffset;
    private float clientCannonRotationOffset;
    private float clientAntennaRotationOffset;
    private double clientItemRotation;
    private boolean fired;

    public DeliveryCannonBlockEntity(@Nullable BlockEntityType<?> type, @Nullable BlockPos pos, @Nullable BlockState state) {
        super(type, pos, state);
        ItemStack itemStack = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.currentStack = itemStack;
        ItemStack itemStack2 = ItemStack.f_41583_;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack2, (String)"EMPTY");
        this.midAirStack = itemStack2;
        this.visitedChutes = new HashSet();
        this.xRot = LerpedFloat.angular();
        this.yRot = LerpedFloat.angular();
        this.distance = LerpedFloat.linear();
        this.soundRandom = RandomSource.m_216327_();
        this.xRot.chase(this.getDefaultXrot(), 1.0, LerpedFloat.Chaser.LINEAR);
        this.yRot.chase(0.0, 1.0, LerpedFloat.Chaser.LINEAR);
        this.distance.chase(0.0, 0.5, LerpedFloat.Chaser.LINEAR);
    }

    @NotNull
    public final FrequencySlotBehaviour getFrequencySlotBehaviour() {
        FrequencySlotBehaviour frequencySlotBehaviour = this.frequencySlotBehaviour;
        if (frequencySlotBehaviour != null) {
            return frequencySlotBehaviour;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"frequencySlotBehaviour");
        return null;
    }

    public final void setFrequencySlotBehaviour(@NotNull FrequencySlotBehaviour frequencySlotBehaviour) {
        Intrinsics.checkNotNullParameter((Object)((Object)frequencySlotBehaviour), (String)"<set-?>");
        this.frequencySlotBehaviour = frequencySlotBehaviour;
    }

    @NotNull
    public final ScrollOptionBehaviour<DistributionMode> getDistributionModeBehaviour() {
        ScrollOptionBehaviour<DistributionMode> scrollOptionBehaviour = this.distributionModeBehaviour;
        if (scrollOptionBehaviour != null) {
            return scrollOptionBehaviour;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"distributionModeBehaviour");
        return null;
    }

    public final void setDistributionModeBehaviour(@NotNull ScrollOptionBehaviour<DistributionMode> scrollOptionBehaviour) {
        Intrinsics.checkNotNullParameter(scrollOptionBehaviour, (String)"<set-?>");
        this.distributionModeBehaviour = scrollOptionBehaviour;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        this.setFrequencySlotBehaviour(new FrequencySlotBehaviour(this, (ValueBoxTransform)new FrequencySlot()));
        behaviours.add(this.getFrequencySlotBehaviour());
        this.setDistributionModeBehaviour((ScrollOptionBehaviour<DistributionMode>)new ScrollOptionBehaviour(DistributionMode.class, (Component)ClockworkLang.translateDirect("delivery_cannon.distribution_mode", new Object[0]), (SmartBlockEntity)this, (ValueBoxTransform)new FrequencySlot()));
        this.getDistributionModeBehaviour().requiresWrench();
        behaviours.add(this.getFrequencySlotBehaviour());
        behaviours.add((BlockEntityBehaviour)this.getDistributionModeBehaviour());
    }

    @NotNull
    public final ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public final void setCurrentStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.currentStack = itemStack;
    }

    @NotNull
    public final ItemStack getMidAirStack() {
        return this.midAirStack;
    }

    public final void setMidAirStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.midAirStack = itemStack;
    }

    public final double getLastVel() {
        return this.lastVel;
    }

    public final void setLastVel(double d) {
        this.lastVel = d;
    }

    @NotNull
    public final HashSet<BlockPos> getVisitedChutes() {
        return this.visitedChutes;
    }

    public final void setVisitedChutes(@NotNull HashSet<BlockPos> hashSet) {
        Intrinsics.checkNotNullParameter(hashSet, (String)"<set-?>");
        this.visitedChutes = hashSet;
    }

    public final double getCooldown() {
        return this.cooldown;
    }

    public final void setCooldown(double d) {
        this.cooldown = d;
    }

    public final double getGunpowderTicks() {
        return this.gunpowderTicks;
    }

    public final void setGunpowderTicks(double d) {
        this.gunpowderTicks = d;
    }

    @Nullable
    public final BlockPos getShootingAtChute() {
        return this.shootingAtChute;
    }

    public final void setShootingAtChute(@Nullable BlockPos blockPos) {
        this.shootingAtChute = blockPos;
    }

    public final LerpedFloat getXRot() {
        return this.xRot;
    }

    public final void setXRot(LerpedFloat lerpedFloat) {
        this.xRot = lerpedFloat;
    }

    public final LerpedFloat getYRot() {
        return this.yRot;
    }

    public final void setYRot(LerpedFloat lerpedFloat) {
        this.yRot = lerpedFloat;
    }

    public final LerpedFloat getDistance() {
        return this.distance;
    }

    public final void setDistance(LerpedFloat lerpedFloat) {
        this.distance = lerpedFloat;
    }

    public final RandomSource getSoundRandom() {
        return this.soundRandom;
    }

    public final double getClientShotProgress() {
        return this.clientShotProgress;
    }

    public final void setClientShotProgress(double d) {
        this.clientShotProgress = d;
    }

    public final float getClientBarrelOffset() {
        return this.clientBarrelOffset;
    }

    public final void setClientBarrelOffset(float f) {
        this.clientBarrelOffset = f;
    }

    public final float getClientCannonRotationOffset() {
        return this.clientCannonRotationOffset;
    }

    public final void setClientCannonRotationOffset(float f) {
        this.clientCannonRotationOffset = f;
    }

    public final float getClientAntennaRotationOffset() {
        return this.clientAntennaRotationOffset;
    }

    public final void setClientAntennaRotationOffset(float f) {
        this.clientAntennaRotationOffset = f;
    }

    public final double getClientItemRotation() {
        return this.clientItemRotation;
    }

    public final void setClientItemRotation(double d) {
        this.clientItemRotation = d;
    }

    public final boolean getFired() {
        return this.fired;
    }

    public final void setFired(boolean bl) {
        this.fired = bl;
    }

    public final double getGunpowderedCoefficient() {
        return this.gunpowderTicks > 0.0 ? 1.0 : 0.0;
    }

    @NotNull
    public final Vector3d getRealPos() {
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return ClockworkUtils.INSTANCE.getRealPos(this.f_58857_, blockPos);
    }

    public final boolean isRoundRobin() {
        return this.getDistributionModeBehaviour().get() == DistributionMode.ROUND_ROBIN;
    }

    public final double getDefaultXrot() {
        return ((Direction)this.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_();
    }

    public void lazyTick() {
        this.sendData();
    }

    public void tick() {
        super.tick();
        this.xRot.updateChaseSpeed(1.0 + this.getGunpowderedCoefficient() * (double)3);
        this.yRot.updateChaseSpeed(1.0 + this.getGunpowderedCoefficient() * (double)3);
        this.distance.updateChaseSpeed(0.5 + this.getGunpowderedCoefficient() * (double)2);
        this.xRot.tickChaser();
        this.yRot.tickChaser();
        this.distance.tickChaser();
        this.gunpowderTicks = Math.max(this.gunpowderTicks, this.gunpowderTicks - 1.0);
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        if (level.f_46443_) {
            return;
        }
        if (this.shootingAtChute != null) {
            DeliveryChuteBlockEntity chute = (DeliveryChuteBlockEntity)((Object)((Map)ActiveChutes.INSTANCE.getActives()).get(this.shootingAtChute));
            if (chute != null) {
                this.distance.updateChaseTarget((float)chute.getRealPos().distance((Vector3dc)this.getRealPos()));
            } else if (((Map)ActiveChutes.INSTANCE.getUnloaded()).get(this.shootingAtChute) == null) {
                this.reset();
            }
            if ((double)Math.abs(this.distance.getValue() - this.distance.getChaseTarget()) < 0.5 && chute != null) {
                chute.setBusy(false);
                DeliveryChuteBlockEntity.receiveItem$default(chute, this.midAirStack, false, 2, null);
                this.reset();
            }
            return;
        }
        this.cooldown = Math.max(this.cooldown, this.cooldown - 1.0);
        if (this.midAirStack.m_41619_() && !this.currentStack.m_41619_()) {
            List<BlockPos> chutes = ActiveChutes.INSTANCE.getSortedChuteWithFrequency(this.getRealPos(), 100.0, this.getFrequencySlotBehaviour().getFrequency());
            if (chutes.isEmpty()) {
                return;
            }
            BlockPos chute = null;
            DeliveryChuteBlockEntity chuteBe = null;
            for (BlockPos possibleChute : chutes) {
                if (this.isRoundRobin() && this.visitedChutes.contains(possibleChute)) continue;
                chute = possibleChute;
                DeliveryChuteBlockEntity deliveryChuteBlockEntity = ActiveChutes.INSTANCE.getActives().get(chute);
                if (deliveryChuteBlockEntity == null) continue;
                chuteBe = deliveryChuteBlockEntity;
                if (!chuteBe.getBusy() && chuteBe.receiveItem(this.currentStack, true) && !this.isObstructed(chuteBe)) break;
                chuteBe = null;
            }
            if (chuteBe == null) {
                this.visitedChutes.clear();
                return;
            }
            this.updateAngleChaser(chuteBe);
            if (Math.abs(this.xRot.getValue() - this.xRot.getChaseTarget()) < 1.0f && Math.abs(this.yRot.getValue() - this.yRot.getChaseTarget()) < 1.0f) {
                if (this.isRoundRobin()) {
                    this.visitedChutes.add(chuteBe.m_58899_());
                }
                this.shootingAtChute = chute;
                this.midAirStack = this.currentStack;
                this.currentStack = ItemStack.f_41583_;
                Vector3d vector3d = this.getRealPos();
                Object v = ((Map)ActiveChutes.INSTANCE.getActives()).get(chute);
                Intrinsics.checkNotNull(v);
                this.distance.updateChaseTarget((float)vector3d.distance((Vector3dc)((DeliveryChuteBlockEntity)((Object)v)).getRealPos()));
                chuteBe.setBusy(true);
                float pitch = Mth.m_216283_((RandomSource)this.soundRandom, (float)0.9f, (float)1.1f);
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                BlockPos blockPos = this.m_58899_();
                SoundEvent soundEvent = ClockworkSounds.INSTANCE.getTHWOOM().getMainEvent();
                Intrinsics.checkNotNull((Object)soundEvent);
                level2.m_5594_(null, blockPos, soundEvent, SoundSource.BLOCKS, 1.0f, pitch);
                this.fired = true;
                this.sendData();
            }
        } else if (this.currentStack.m_41619_()) {
            Level level3 = this.f_58857_;
            Intrinsics.checkNotNull((Object)level3);
            this.currentStack = SolidDeliveryMethods.extractFrom(level3, this);
        }
    }

    public final void reset() {
        this.xRot.updateChaseTarget((float)this.getDefaultXrot());
        this.yRot.updateChaseTarget(0.0f);
        this.distance.setValue(0.0);
        this.distance.updateChaseTarget(0.0f);
        this.shootingAtChute = null;
        this.midAirStack = ItemStack.f_41583_;
        this.sendData();
    }

    public final void updateAngleChaser(@NotNull DeliveryChuteBlockEntity chuteBlockEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)chuteBlockEntity), (String)"chuteBlockEntity");
        Vector3d vertex = Companion.getThirdPoint(this.getRealPos(), chuteBlockEntity.getRealPos());
        Vector3d deltaP = this.getRealPos().sub((Vector3dc)vertex);
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)blockPos);
        if (ship != null) {
            Vector3d temp = ship.getWorldToShip().transformDirection((Vector3dc)new Vector3d(deltaP.x, deltaP.y, deltaP.z), new Vector3d());
            deltaP.x = temp.x;
            deltaP.y = temp.y;
            deltaP.z = temp.z;
        }
        double xTargetRot = Companion.euler_angle(deltaP.z, -deltaP.x);
        double otherV = 0.0;
        otherV = Math.abs(deltaP.z) > Math.abs(deltaP.x) ? deltaP.z : deltaP.x;
        double u_angle = Companion.euler_angle(deltaP.y, otherV);
        if (u_angle > 90.0) {
            u_angle = (double)180 - u_angle;
        }
        double yTargetRot = u_angle;
        this.xRot.updateChaseTarget((float)xTargetRot);
        this.yRot.updateChaseTarget(Math.min(90.0f, (float)yTargetRot));
        this.sendData();
    }

    public final boolean isObstructed(@NotNull DeliveryChuteBlockEntity chute) {
        Intrinsics.checkNotNullParameter((Object)((Object)chute), (String)"chute");
        return false;
    }

    @NotNull
    public final BlockHitResult clip(@NotNull Vec3 from, @NotNull Vec3 to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        return RaycastUtilsKt.clipIncludeShips$default((Level)level, (ClipContext)new ClipContext(from, to, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null), (boolean)false, null, (boolean)false, (int)14, null);
    }

    public final void addGunpowderTicks(int count) {
        this.gunpowderTicks += (double)(count * 6000);
    }

    public final double getParabolaY(@NotNull Vector3d vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        Vector3d startPos = this.getRealPos();
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        BlockPos blockPos = this.shootingAtChute;
        Intrinsics.checkNotNull((Object)blockPos);
        Vector3d endPos = ClockworkUtils.INSTANCE.getRealPos(level, blockPos);
        Vector3d middlePos = Companion.getThirdPoint(startPos, endPos);
        double sX = startPos.x;
        double eX = endPos.x;
        double vX = middlePos.x;
        double iX = vec.x;
        if (Math.abs(endPos.x - startPos.x) < Math.abs(endPos.z - startPos.z)) {
            sX = startPos.z;
            eX = endPos.z;
            vX = middlePos.z;
            iX = vec.z;
        }
        return Companion.parabola(sX, startPos.y, eX, endPos.y, vX, middlePos.y, iX);
    }

    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.read(tag, clientPacket);
        CompoundTag compoundTag = (CompoundTag)tag.m_128423_("xRot");
        if (compoundTag == null) {
            return;
        }
        this.xRot.readNBT(compoundTag, clientPacket);
        CompoundTag compoundTag2 = (CompoundTag)tag.m_128423_("yRot");
        if (compoundTag2 == null) {
            return;
        }
        this.yRot.readNBT(compoundTag2, clientPacket);
        CompoundTag compoundTag3 = (CompoundTag)tag.m_128423_("distance");
        if (compoundTag3 == null) {
            return;
        }
        this.distance.readNBT(compoundTag3, clientPacket);
        this.currentStack = ItemStack.m_41712_((CompoundTag)tag);
        this.midAirStack = ItemStack.m_41712_((CompoundTag)tag);
        if (tag.m_128441_("shootingAtChute")) {
            Tag tag2 = tag.m_128423_("shootingAtChute");
            Intrinsics.checkNotNull((Object)tag2, (String)"null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            this.shootingAtChute = NbtUtils.m_129239_((CompoundTag)((CompoundTag)tag2));
        }
    }

    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128365_("xRot", (Tag)this.xRot.writeNBT());
        tag.m_128365_("yRot", (Tag)this.yRot.writeNBT());
        tag.m_128365_("distance", (Tag)this.distance.writeNBT());
        this.currentStack.m_41739_(tag);
        this.midAirStack.m_41739_(tag);
        if (this.shootingAtChute != null) {
            BlockPos blockPos = this.shootingAtChute;
            Intrinsics.checkNotNull((Object)blockPos);
            tag.m_128365_("shootingAtChute", (Tag)NbtUtils.m_129224_((BlockPos)blockPos));
        }
        super.write(tag, clientPacket);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016JE\u0010\n\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonBlockEntity$Companion;", "", "", "x1", "y1", "x2", "y2", "x3", "y3", "z", "parabola", "(DDDDDDD)D", "Lorg/joml/Vector3d;", "start", "end", "getThirdPoint", "(Lorg/joml/Vector3d;Lorg/joml/Vector3d;)Lorg/joml/Vector3d;", "x", "y", "euler_angle", "(DD)D", "<init>", "()V", "clockwork"})
    public static final class Companion {
        private Companion() {
        }

        public final double parabola(double x1, double y1, double x2, double y2, double x3, double y3, double z) {
            double denom = (x1 - x2) * (x1 - x3) * (x2 - x3);
            double A = (x3 * (y2 - y1) + x2 * (y1 - y3) + x1 * (y3 - y2)) / denom;
            double B = (x3 * x3 * (y1 - y2) + x2 * x2 * (y3 - y1) + x1 * x1 * (y2 - y3)) / denom;
            double C = (x2 * x3 * (x2 - x3) * y1 + x3 * x1 * (x3 - x1) * y2 + x1 * x2 * (x1 - x2) * y3) / denom;
            return A * Math.pow(z, 2) + B * z + C;
        }

        @NotNull
        public final Vector3d getThirdPoint(@NotNull Vector3d start, @NotNull Vector3d end) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)end, (String)"end");
            return new Vector3d((start.x + end.x) / (double)2, (start.y + end.y) / (double)2 + (double)5, (start.z + end.z) / (double)2);
        }

        public final double euler_angle(double x, double y) {
            double rad = Math.atan(y / x);
            double deg = rad * (double)180 / Math.PI;
            if (x < 0.0) {
                deg += (double)180;
            }
            double eul = ((double)270 + deg) % (double)360;
            return eul;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0086\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fj\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0011"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonBlockEntity$DistributionMode;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/scrollValue/INamedIconOptions;", "", "Lcom/simibubi/create/foundation/gui/AllIcons;", "getIcon", "()Lcom/simibubi/create/foundation/gui/AllIcons;", "", "getTranslationKey", "()Ljava/lang/String;", "icon", "Lcom/simibubi/create/foundation/gui/AllIcons;", "translationKey", "Ljava/lang/String;", "<init>", "(Ljava/lang/String;ILcom/simibubi/create/foundation/gui/AllIcons;)V", "ROUND_ROBIN", "ALWAYS_CLOSEST", "clockwork"})
    public static final class DistributionMode
    extends Enum<DistributionMode>
    implements INamedIconOptions {
        @NotNull
        private final AllIcons icon;
        @NotNull
        private final String translationKey;
        public static final /* enum */ DistributionMode ROUND_ROBIN;
        public static final /* enum */ DistributionMode ALWAYS_CLOSEST;
        private static final /* synthetic */ DistributionMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private DistributionMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "contraptions.movement_mode." + Lang.asId((String)this.name());
        }

        @NotNull
        public AllIcons getIcon() {
            return this.icon;
        }

        @NotNull
        public String getTranslationKey() {
            return this.translationKey;
        }

        public static DistributionMode[] values() {
            return (DistributionMode[])$VALUES.clone();
        }

        public static DistributionMode valueOf(String value) {
            return Enum.valueOf(DistributionMode.class, value);
        }

        @NotNull
        public static EnumEntries<DistributionMode> getEntries() {
            return $ENTRIES;
        }

        static {
            AllIcons allIcons = AllIcons.I_TUNNEL_ROUND_ROBIN;
            Intrinsics.checkNotNullExpressionValue((Object)allIcons, (String)"I_TUNNEL_ROUND_ROBIN");
            ROUND_ROBIN = new DistributionMode(allIcons);
            AllIcons allIcons2 = AllIcons.I_TUNNEL_PREFER_NEAREST;
            Intrinsics.checkNotNullExpressionValue((Object)allIcons2, (String)"I_TUNNEL_PREFER_NEAREST");
            ALWAYS_CLOSEST = new DistributionMode(allIcons2);
            $VALUES = distributionModeArray = new DistributionMode[]{DistributionMode.ROUND_ROBIN, DistributionMode.ALWAYS_CLOSEST};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ'\u0010\t\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ/\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u0013H\u0014\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\bH\u0014\u00a2\u0006\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/solid/delivery/cannon/DeliveryCannonBlockEntity$FrequencySlot;", "Lcom/simibubi/create/foundation/blockEntity/behaviour/ValueBoxTransform$Sided;", "Lnet/minecraft/world/level/LevelAccessor;", "level", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "Lnet/minecraft/world/phys/Vec3;", "getLocalOffset", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)Lnet/minecraft/world/phys/Vec3;", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "", "rotate", "(Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lcom/mojang/blaze3d/vertex/PoseStack;)V", "", "angle", "(Lnet/minecraft/world/level/block/state/BlockState;)F", "Lnet/minecraft/core/Direction;", "direction", "", "isSideActive", "(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;)Z", "getSouthLocation", "()Lnet/minecraft/world/phys/Vec3;", "<init>", "()V", "clockwork"})
    public static final class FrequencySlot
    extends ValueBoxTransform.Sided {
        @NotNull
        public Vec3 getLocalOffset(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state) {
            Vec3 vec3;
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            if (this.direction != Direction.UP) {
                Vec3 vec32 = super.getLocalOffset(level, pos, state);
                vec3 = vec32;
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getLocalOffset(...)");
            } else {
                Vec3 vec33 = new Vec3(0.5, 0.65625, 0.5).m_82549_(VecHelper.rotate((Vec3)VecHelper.voxelSpace((double)0.0, (double)0.0, (double)-5.0), (double)this.angle(state), (Direction.Axis)Direction.Axis.Y));
                vec3 = vec33;
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"add(...)");
            }
            return vec3;
        }

        public void rotate(@NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull PoseStack ms) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
            if (this.direction != Direction.UP) {
                super.rotate(level, pos, state, ms);
                return;
            }
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(this.angle(state))).rotateXDegrees(90.0f);
        }

        private final float angle(BlockState state) {
            return ClockworkBlocks.DELIVERY_CANNON.has(state) ? AngleHelper.horizontalAngle((Direction)((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_))) : 0.0f;
        }

        protected boolean isSideActive(@NotNull BlockState state, @NotNull Direction direction) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)direction, (String)"direction");
            return !(direction == Direction.UP || direction == Direction.DOWN || (state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) != Direction.NORTH && state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) != Direction.SOUTH || direction != Direction.NORTH && direction != Direction.SOUTH) && (state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) != Direction.WEST && state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_) != Direction.EAST || direction != Direction.WEST && direction != Direction.EAST));
        }

        @NotNull
        protected Vec3 getSouthLocation() {
            Vec3 vec3;
            if (this.direction == Direction.UP) {
                Vec3 vec32 = Vec3.f_82478_;
                vec3 = vec32;
                Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
            } else {
                Vec3 vec33 = VecHelper.voxelSpace((double)8.0, (double)3.0, (double)15.5);
                vec3 = vec33;
                Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"voxelSpace(...)");
            }
            return vec3;
        }
    }
}

