/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.pockets.nozzle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.joml.Vector3ic;
import org.valkyrienskies.clockwork.ClockworkModClient;
import org.valkyrienskies.clockwork.content.forces.data.BalloonData;
import org.valkyrienskies.clockwork.platform.api.network.ClientNetworkContext;
import org.valkyrienskies.clockwork.platform.api.network.S2CCWPacket;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b\u001e\u0010!J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0006J)\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0006J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0011R$\u0010\u0015\u001a\u0004\u0018\u00010\u00148\u0016@\u0016X\u0096\u000e\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR&\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001c\u00a8\u0006\""}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/BalloonStatusPacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/S2CCWPacket;", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "", "write", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "Lorg/valkyrienskies/clockwork/platform/api/network/ClientNetworkContext;", "context", "handle", "(Lorg/valkyrienskies/clockwork/platform/api/network/ClientNetworkContext;)V", "writeLeaks", "", "Lkotlin/Pair;", "Lorg/joml/Vector3ic;", "", "readLeaks", "(Lnet/minecraft/network/FriendlyByteBuf;)Ljava/util/List;", "writeSealedLeaks", "readSealedLeaks", "Lnet/minecraft/world/entity/player/Player;", "player", "Lnet/minecraft/world/entity/player/Player;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "setPlayer", "(Lnet/minecraft/world/entity/player/Player;)V", "leaks", "Ljava/util/List;", "sealedLeaks", "<init>", "Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData;", "balloon", "(Lorg/valkyrienskies/clockwork/content/forces/data/BalloonData;)V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nBalloonStatusPacket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BalloonStatusPacket.kt\norg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/BalloonStatusPacket\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n774#2:111\n865#2,2:112\n*S KotlinDebug\n*F\n+ 1 BalloonStatusPacket.kt\norg/valkyrienskies/clockwork/content/logistics/gas/pockets/nozzle/BalloonStatusPacket\n*L\n25#1:111\n25#1:112,2\n*E\n"})
public final class BalloonStatusPacket
implements S2CCWPacket {
    @Nullable
    private Player player;
    @NotNull
    private final List<Pair<Vector3ic, Boolean>> leaks;
    @NotNull
    private final List<Vector3ic> sealedLeaks;

    @Override
    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public void setPlayer(@Nullable Player player) {
        this.player = player;
    }

    public BalloonStatusPacket(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.leaks = this.readLeaks(buffer);
        this.sealedLeaks = this.readSealedLeaks(buffer);
    }

    /*
     * WARNING - void declaration
     */
    public BalloonStatusPacket(@NotNull BalloonData balloon) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)balloon, (String)"balloon");
        Iterable iterable = balloon.getLastSentLeaks();
        BalloonStatusPacket balloonStatusPacket = this;
        boolean $i$f$filter22 = false;
        void var4_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Vector3ic leakPos = (Vector3ic)element$iv$iv;
            boolean bl = false;
            if (!(!balloon.getLeakPositions().contains(leakPos))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        balloonStatusPacket.sealedLeaks = (List)destination$iv$iv;
        BalloonStatusPacket $i$f$filter22 = this;
        balloonStatusPacket = this;
        boolean bl = false;
        HashSet<Vector3ic> leaks = balloon.getLeakPositions();
        HashSet<Vector3ic> prevLeaks = balloon.getLastSentLeaks();
        ArrayList<Pair> newList = new ArrayList<Pair>();
        Iterator<Vector3ic> iterator = leaks.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<Vector3ic> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Vector3ic leak;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            boolean isNew = !prevLeaks.contains(leak);
            newList.add(new Pair((Object)leak, (Object)isNew));
        }
        prevLeaks.clear();
        prevLeaks.addAll((Collection<Vector3ic>)leaks);
        balloonStatusPacket.leaks = newList;
    }

    @Override
    public void write(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.writeLeaks(buffer);
        this.writeSealedLeaks(buffer);
    }

    @Override
    public void handle(@NotNull ClientNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.enqueueWork(() -> BalloonStatusPacket.handle$lambda$2(this));
        context.setPacketHandled(true);
    }

    private final void writeLeaks(FriendlyByteBuf buffer) {
        buffer.writeInt(this.leaks.size());
        for (Pair<Vector3ic, Boolean> leak : this.leaks) {
            buffer.writeInt(((Vector3ic)leak.getFirst()).x());
            buffer.writeInt(((Vector3ic)leak.getFirst()).y());
            buffer.writeInt(((Vector3ic)leak.getFirst()).z());
            buffer.writeBoolean(((Boolean)leak.getSecond()).booleanValue());
        }
    }

    private final List<Pair<Vector3ic, Boolean>> readLeaks(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        List leaks = new ArrayList();
        for (int i = 0; i < size; ++i) {
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            boolean isNew = buffer.readBoolean();
            leaks.add(new Pair((Object)new Vector3i(x, y, z), (Object)isNew));
        }
        return leaks;
    }

    private final void writeSealedLeaks(FriendlyByteBuf buffer) {
        buffer.writeInt(this.sealedLeaks.size());
        for (Vector3ic leak : this.sealedLeaks) {
            buffer.writeInt(leak.x());
            buffer.writeInt(leak.y());
            buffer.writeInt(leak.z());
        }
    }

    private final List<Vector3ic> readSealedLeaks(FriendlyByteBuf buffer) {
        int size = buffer.readInt();
        List leaks = new ArrayList();
        for (int i = 0; i < size; ++i) {
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            leaks.add(new Vector3i(x, y, z));
        }
        return leaks;
    }

    private static final void handle$lambda$2(BalloonStatusPacket this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (Minecraft.m_91087_().f_91073_ != null) {
            ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
            Intrinsics.checkNotNull((Object)clientLevel);
            ClientLevel level = clientLevel;
            for (Pair<Vector3ic, Boolean> leak : this$0.leaks) {
                Vector3ic pos = (Vector3ic)leak.getFirst();
                boolean isNew = (Boolean)leak.getSecond();
                ClockworkModClient.getCLIENT_BALLOON_LEAKS().add(pos);
                if (!isNew) continue;
            }
        }
    }
}

