/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.generation.steam_generator;

import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.lang.ref.WeakReference;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Math;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.logistics.gas.generation.steam_generator.SteamGeneratorBlock;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\f\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010 \u0012\u0006\u0010#\u001a\u00020\"\u0012\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J!\u0010\t\u001a\u00020\b2\u0010\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0006\u0018\u00010\u0005H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u000f\u0010\u000b\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fR*\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\r8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0015\u001a\u00020\u00148\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\u00020\u00148\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R\u0019\u0010\u001c\u001a\u0004\u0018\u00010\u001b8\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/generation/steam_generator/SteamGeneratorBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "Lcom/simibubi/create/content/fluids/tank/FluidTankBlockEntity;", "getTank", "()Lcom/simibubi/create/content/fluids/tank/FluidTankBlockEntity;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "tick", "()V", "Ljava/lang/ref/WeakReference;", "source", "Ljava/lang/ref/WeakReference;", "getSource", "()Ljava/lang/ref/WeakReference;", "setSource", "(Ljava/lang/ref/WeakReference;)V", "", "maxMass", "D", "getMaxMass", "()D", "maxPressurePerLevel", "getMaxPressurePerLevel", "Lorg/valkyrienskies/kelvin/api/GasType;", "steamGas", "Lorg/valkyrienskies/kelvin/api/GasType;", "getSteamGas", "()Lorg/valkyrienskies/kelvin/api/GasType;", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nSteamGeneratorBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SteamGeneratorBlockEntity.kt\norg/valkyrienskies/clockwork/content/logistics/gas/generation/steam_generator/SteamGeneratorBlockEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,62:1\n1#2:63\n*E\n"})
public final class SteamGeneratorBlockEntity
extends KNodeBlockEntity {
    @NotNull
    private WeakReference<FluidTankBlockEntity> source;
    private final double maxMass;
    private final double maxPressurePerLevel;
    @Nullable
    private final GasType steamGas;

    public SteamGeneratorBlockEntity(@Nullable BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.source = new WeakReference<Object>(null);
        this.maxMass = 0.1;
        this.maxPressurePerLevel = 2125000.0;
        this.steamGas = GasTypeRegistry.INSTANCE.getGasType("vs_clockwork", "steam");
    }

    @NotNull
    public final WeakReference<FluidTankBlockEntity> getSource() {
        return this.source;
    }

    public final void setSource(@NotNull WeakReference<FluidTankBlockEntity> weakReference) {
        Intrinsics.checkNotNullParameter(weakReference, (String)"<set-?>");
        this.source = weakReference;
    }

    public final double getMaxMass() {
        return this.maxMass;
    }

    public final double getMaxPressurePerLevel() {
        return this.maxPressurePerLevel;
    }

    @Nullable
    public final GasType getSteamGas() {
        return this.steamGas;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final FluidTankBlockEntity getTank() {
        Object tank = null;
        tank = this.source.get();
        if (tank == null || ((FluidTankBlockEntity)tank).m_58901_()) {
            if (tank != null) {
                this.source = new WeakReference<Object>(null);
            }
            BlockState blockState = this.m_58900_();
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            Direction facing = SteamGeneratorBlock.Companion.getFacing(blockState);
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            BlockEntity be = level.m_7702_(this.f_58858_.m_121945_(facing.m_122424_()));
            if (be instanceof FluidTankBlockEntity) {
                void it;
                BlockEntity blockEntity = be;
                FluidTankBlockEntity fluidTankBlockEntity = (FluidTankBlockEntity)blockEntity;
                SteamGeneratorBlockEntity steamGeneratorBlockEntity = this;
                boolean bl = false;
                tank = it;
                BlockEntity blockEntity2 = blockEntity;
                steamGeneratorBlockEntity.source = new WeakReference<BlockEntity>(blockEntity2);
            }
        }
        if (tank == null) {
            return null;
        }
        return ((FluidTankBlockEntity)tank).getControllerBE();
    }

    public void addBehaviours(@Nullable List<? extends BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        super.tick();
        Level level = this.f_58857_;
        if (!(level != null ? !level.f_46443_ : false)) {
            return;
        }
        if (this.steamGas == null) {
            ClockworkMod.INSTANCE.getLOGGER().error("SteamGeneratorBlockEntity can't get GasType 'vs_clockwork:steam'. Did something go wrong?");
            return;
        }
        FluidTankBlockEntity fluidTankBlockEntity = this.getTank();
        if (fluidTankBlockEntity == null) {
            return;
        }
        FluidTankBlockEntity tank = fluidTankBlockEntity;
        float efficiency = Math.clamp((float)tank.boiler.getEngineEfficiency(tank.getTotalTankSize()), (float)0.0f, (float)1.0f);
        if (efficiency == 0.0f) {
            return;
        }
        if (tank.boiler.activeHeat == 0 && !tank.boiler.passiveHeat) {
            return;
        }
        DuctNetworkServer network = ClockworkMod.getKelvin();
        double mass = this.maxMass * (double)efficiency;
        double temperature = (double)80 * java.lang.Math.pow(java.lang.Math.max(0.25, (double)tank.boiler.activeHeat) * (double)100, 0.34);
        if (network.getPressureAt(this.getDuctNodePosition()) > this.maxPressurePerLevel * (double)java.lang.Math.max(1, tank.boiler.activeHeat)) {
            return;
        }
        network.addGasAtTemperature(this.getDuctNodePosition(), this.steamGas, mass, temperature);
    }
}

