/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.filter;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3dc;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.content.logistics.gas.duct.DuctBlockEntity;
import org.valkyrienskies.clockwork.platform.api.network.C2SCWPacket;
import org.valkyrienskies.clockwork.platform.api.network.ServerNetworkContext;
import org.valkyrienskies.core.util.VSCoreUtilKt;
import org.valkyrienskies.kelvin.api.DuctEdge;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.api.GasType;
import org.valkyrienskies.kelvin.api.edges.FilteredEdge;
import org.valkyrienskies.kelvin.impl.registry.GasTypeRegistry;
import org.valkyrienskies.kelvin.util.KelvinExtensions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u0012\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017\u0012\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001d\u0010\u001eB\u0011\b\u0016\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001d\u0010\u0013J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J-\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0014R\u0014\u0010\u000b\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0014R$\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u00178\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\u001a8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/filter/FilterClosePacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/C2SCWPacket;", "Lorg/valkyrienskies/clockwork/platform/api/network/ServerNetworkContext;", "context", "", "handle", "(Lorg/valkyrienskies/clockwork/platform/api/network/ServerNetworkContext;)V", "Lnet/minecraft/world/level/Level;", "level", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "nodeA", "nodeB", "Lorg/valkyrienskies/kelvin/api/DuctEdge;", "edge", "forceUpdate", "(Lnet/minecraft/world/level/Level;Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctEdge;)V", "Lnet/minecraft/network/FriendlyByteBuf;", "buffer", "write", "(Lnet/minecraft/network/FriendlyByteBuf;)V", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "Ljava/util/HashSet;", "Lorg/valkyrienskies/kelvin/api/GasType;", "Lkotlin/collections/HashSet;", "filter", "Ljava/util/HashSet;", "", "blacklist", "Z", "<init>", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;Ljava/util/HashSet;Z)V", "clockwork"})
public final class FilterClosePacket
implements C2SCWPacket {
    @NotNull
    private final DuctNodePos nodeA;
    @NotNull
    private final DuctNodePos nodeB;
    @NotNull
    private final HashSet<GasType> filter;
    private final boolean blacklist;

    public FilterClosePacket(@NotNull DuctNodePos nodeA, @NotNull DuctNodePos nodeB, @NotNull HashSet<GasType> filter, boolean blacklist) {
        Intrinsics.checkNotNullParameter((Object)nodeA, (String)"nodeA");
        Intrinsics.checkNotNullParameter((Object)nodeB, (String)"nodeB");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        this.nodeA = nodeA;
        this.nodeB = nodeB;
        this.filter = filter;
        this.blacklist = blacklist;
    }

    /*
     * WARNING - void declaration
     */
    public FilterClosePacket(@NotNull FriendlyByteBuf buffer) {
        void it;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Vector3dc vector3dc = (Vector3dc)VSCoreUtilKt.readVec3d((ByteBuf)((ByteBuf)buffer));
        ResourceLocation resourceLocation = buffer.m_130281_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"readResourceLocation(...)");
        DuctNodePos ductNodePos = KelvinExtensions.INSTANCE.toDuctNodePos(vector3dc, resourceLocation);
        Vector3dc vector3dc2 = (Vector3dc)VSCoreUtilKt.readVec3d((ByteBuf)((ByteBuf)buffer));
        ResourceLocation resourceLocation2 = buffer.m_130281_();
        Intrinsics.checkNotNullExpressionValue((Object)resourceLocation2, (String)"readResourceLocation(...)");
        String string = buffer.m_130277_();
        DuctNodePos ductNodePos2 = KelvinExtensions.INSTANCE.toDuctNodePos(vector3dc2, resourceLocation2);
        DuctNodePos ductNodePos3 = ductNodePos;
        FilterClosePacket filterClosePacket = this;
        boolean bl = false;
        HashSet<GasType> set = new HashSet<GasType>();
        Intrinsics.checkNotNull((Object)it);
        String[] stringArray = new String[]{" "};
        for (String str : StringsKt.split$default((CharSequence)((CharSequence)it), (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            GasType type;
            if (GasTypeRegistry.INSTANCE.getGasType(new ResourceLocation(((Object)StringsKt.trim((CharSequence)str)).toString())) == null) continue;
            set.add(type);
        }
        HashSet<GasType> hashSet = set;
        filterClosePacket(ductNodePos3, ductNodePos2, hashSet, buffer.readBoolean());
    }

    @Override
    public void handle(@NotNull ServerNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        context.enqueueWork(() -> FilterClosePacket.handle$lambda$1(this, context));
        context.setPacketHandled(true);
    }

    public final void forceUpdate(@NotNull Level level, @NotNull DuctNodePos nodeA, @NotNull DuctNodePos nodeB, @NotNull DuctEdge edge) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)nodeA, (String)"nodeA");
        Intrinsics.checkNotNullParameter((Object)nodeB, (String)"nodeB");
        Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
        BlockPos blockPos = KelvinExtensions.INSTANCE.toMinecraft(nodeA);
        BlockEntity blockEntity = level.m_7702_(blockPos);
        DuctBlockEntity ductBlockEntity = blockEntity instanceof DuctBlockEntity ? (DuctBlockEntity)blockEntity : null;
        if (ductBlockEntity == null) {
            return;
        }
        DuctBlockEntity be = ductBlockEntity;
        ((Map)be.getEdgeData()).put(new DuctBlockEntity.EdgePos(nodeA, nodeB), edge.serialize(new CompoundTag()));
        be.notifyUpdate();
    }

    @Override
    public void write(@NotNull FriendlyByteBuf buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Object tag = "";
        Iterator<GasType> iterator = this.filter.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<GasType> iterator2 = iterator;
        while (iterator2.hasNext()) {
            GasType gas;
            Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
            tag = (String)tag + gas.getResourceLocation() + " ";
        }
        VSCoreUtilKt.writeVec3d((ByteBuf)((ByteBuf)buffer), (Vector3dc)((Vector3dc)KelvinExtensions.INSTANCE.toVector3d(KelvinExtensions.INSTANCE.toMinecraft(this.nodeA))));
        buffer.m_130085_(this.nodeA.getDimensionId());
        VSCoreUtilKt.writeVec3d((ByteBuf)((ByteBuf)buffer), (Vector3dc)((Vector3dc)KelvinExtensions.INSTANCE.toVector3d(KelvinExtensions.INSTANCE.toMinecraft(this.nodeB))));
        buffer.m_130085_(this.nodeB.getDimensionId());
        buffer.m_130070_((String)tag);
        buffer.writeBoolean(this.blacklist);
    }

    private static final void handle$lambda$1(FilterClosePacket this$0, ServerNetworkContext $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        FilteredEdge filteredEdge = (FilteredEdge)ClockworkMod.getKelvin().getEdges().get(new Pair((Object)this$0.nodeA, (Object)this$0.nodeB));
        if (filteredEdge == null) {
            return;
        }
        FilteredEdge edge = filteredEdge;
        edge.modFilter(this$0.filter, this$0.blacklist);
        Level level = $context.getSender().m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        this$0.forceUpdate(level, this$0.nodeA, this$0.nodeB, (DuctEdge)edge);
        Level level2 = $context.getSender().m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"level(...)");
        this$0.forceUpdate(level2, this$0.nodeB, this$0.nodeA, (DuctEdge)edge);
    }
}

