/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.logistics.gas.duct;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkMod;
import org.valkyrienskies.clockwork.ClockworkPackets;
import org.valkyrienskies.clockwork.content.logistics.gas.duct.DuctEdgeSyncPacket;
import org.valkyrienskies.clockwork.content.logistics.gas.duct.DuctEdgeType;
import org.valkyrienskies.clockwork.util.DuctNetworkUtils;
import org.valkyrienskies.clockwork.util.KNodeBlockEntity;
import org.valkyrienskies.kelvin.api.DuctEdge;
import org.valkyrienskies.kelvin.api.DuctNodePos;
import org.valkyrienskies.kelvin.impl.DuctNetworkServer;
import org.valkyrienskies.kelvin.util.INodeBlockEntity;
import org.valkyrienskies.kelvin.util.KelvinExtensions;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001FB#\u0012\n\u0010?\u001a\u0006\u0012\u0002\b\u00030>\u0012\u0006\u0010A\u001a\u00020@\u0012\u0006\u0010C\u001a\u00020B\u00a2\u0006\u0004\bD\u0010EJ\u001d\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018JA\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\u001b\u001a\u00020\n2\b\b\u0002\u0010\u001c\u001a\u00020\n\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u001f\u0010 J\u0017\u0010\"\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\"\u0010 J\u0011\u0010$\u001a\u0004\u0018\u00010#H\u0014\u00a2\u0006\u0004\b$\u0010%R#\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00160&8\u0006\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*R#\u0010-\u001a\u000e\u0012\u0004\u0012\u00020,\u0012\u0004\u0012\u00020\b0+8\u0006\u00a2\u0006\f\n\u0004\b-\u0010.\u001a\u0004\b/\u00100R\"\u00102\u001a\u0002018\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b2\u00103\u001a\u0004\b4\u00105\"\u0004\b6\u00107R\"\u00108\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\u00a8\u0006G"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctBlockEntity;", "Lorg/valkyrienskies/clockwork/util/KNodeBlockEntity;", "", "Lcom/simibubi/create/foundation/blockEntity/behaviour/BlockEntityBehaviour;", "behaviours", "", "addBehaviours", "(Ljava/util/List;)V", "Lnet/minecraft/nbt/CompoundTag;", "tag", "", "clientPacket", "read", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "write", "destroy", "()V", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "getDuctNodePosition", "()Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "Lnet/minecraft/core/Direction;", "dir", "Lorg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctEdgeType;", "cycleEdgeType", "(Lnet/minecraft/core/Direction;)Lorg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctEdgeType;", "otherDuctNodePos", "edgeType", "silent", "forced", "setEdgeType", "(Lnet/minecraft/core/Direction;Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctEdgeType;ZZZ)V", "clearEdgeType", "(Lnet/minecraft/core/Direction;)V", "direction", "syncEdge", "Lnet/minecraft/world/phys/AABB;", "createRenderBoundingBox", "()Lnet/minecraft/world/phys/AABB;", "Ljava/util/EnumMap;", "DIR_TO_CONNECTION_TYPE", "Ljava/util/EnumMap;", "getDIR_TO_CONNECTION_TYPE", "()Ljava/util/EnumMap;", "Ljava/util/HashMap;", "Lorg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctBlockEntity$EdgePos;", "edgeData", "Ljava/util/HashMap;", "getEdgeData", "()Ljava/util/HashMap;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "setObjectMapper", "(Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "shouldUpdateEdges", "Z", "getShouldUpdateEdges", "()Z", "setShouldUpdateEdges", "(Z)V", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/core/BlockPos;", "pos", "Lnet/minecraft/world/level/block/state/BlockState;", "state", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "EdgePos", "clockwork"})
@SourceDebugExtension(value={"SMAP\nDuctBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DuctBlockEntity.kt\norg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,175:1\n1863#2,2:176\n216#3,2:178\n*S KotlinDebug\n*F\n+ 1 DuctBlockEntity.kt\norg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctBlockEntity\n*L\n55#1:176,2\n72#1:178,2\n*E\n"})
public final class DuctBlockEntity
extends KNodeBlockEntity {
    @NotNull
    private final EnumMap<Direction, DuctEdgeType> DIR_TO_CONNECTION_TYPE;
    @NotNull
    private final HashMap<EdgePos, CompoundTag> edgeData;
    @NotNull
    private ObjectMapper objectMapper;
    private boolean shouldUpdateEdges;

    public DuctBlockEntity(@NotNull BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
        this.DIR_TO_CONNECTION_TYPE = new EnumMap(Direction.class);
        this.edgeData = new HashMap();
        this.objectMapper = ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper());
        for (Direction dir : Direction.values()) {
            ((Map)this.DIR_TO_CONNECTION_TYPE).put(dir, DuctEdgeType.NONE);
        }
    }

    @NotNull
    public final EnumMap<Direction, DuctEdgeType> getDIR_TO_CONNECTION_TYPE() {
        return this.DIR_TO_CONNECTION_TYPE;
    }

    @NotNull
    public final HashMap<EdgePos, CompoundTag> getEdgeData() {
        return this.edgeData;
    }

    @NotNull
    public final ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public final void setObjectMapper(@NotNull ObjectMapper objectMapper) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"<set-?>");
        this.objectMapper = objectMapper;
    }

    public final boolean getShouldUpdateEdges() {
        return this.shouldUpdateEdges;
    }

    public final void setShouldUpdateEdges(boolean bl) {
        this.shouldUpdateEdges = bl;
    }

    public void addBehaviours(@NotNull List<BlockEntityBehaviour> behaviours) {
        Intrinsics.checkNotNullParameter(behaviours, (String)"behaviours");
        super.addBehavioursDeferred(behaviours);
    }

    @Override
    protected void read(@NotNull CompoundTag tag, boolean clientPacket) {
        Tag tag2;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.read(tag, clientPacket);
        for (Direction dir : Direction.values()) {
            if (!tag.m_128441_("DuctEdgeType" + dir.name())) continue;
            DuctEdgeType edgeType = (DuctEdgeType)((Object)DuctEdgeType.getEntries().get(tag.m_128451_("DuctEdgeType" + dir.name())));
            ((Map)this.DIR_TO_CONNECTION_TYPE).put(dir, edgeType);
            if (clientPacket) continue;
            this.shouldUpdateEdges = true;
        }
        if (clientPacket) {
            return;
        }
        if (this.f_58857_ != null) {
            DuctNetworkServer ductNetworkServer = ClockworkMod.getKelvin();
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            ResourceLocation resourceLocation = level.m_46472_().m_135782_();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            ductNetworkServer.markLoaded(KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation));
        }
        CompoundTag compoundTag = (tag2 = tag.m_128423_("edgeData")) instanceof CompoundTag ? (CompoundTag)tag2 : null;
        if (compoundTag == null) {
            return;
        }
        CompoundTag edgeDataTag = compoundTag;
        Set set = edgeDataTag.m_128431_();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"getAllKeys(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompoundTag tag3;
            String it = (String)element$iv;
            boolean bl = false;
            EdgePos edgePos = (EdgePos)this.objectMapper.readValue(it, EdgePos.class);
            Tag tag4 = edgeDataTag.m_128423_(it);
            if ((tag4 instanceof CompoundTag ? (CompoundTag)tag4 : null) == null) {
                return;
            }
            tag3 = tag3;
            ((Map)this.edgeData).put(edgePos, tag3);
        }
    }

    @Override
    protected void write(@NotNull CompoundTag tag, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        for (Direction dir : Direction.values()) {
            if (this.DIR_TO_CONNECTION_TYPE.get(dir) == null) continue;
            String string = "DuctEdgeType" + dir.name();
            DuctEdgeType ductEdgeType = this.DIR_TO_CONNECTION_TYPE.get(dir);
            Intrinsics.checkNotNull((Object)((Object)ductEdgeType));
            tag.m_128405_(string, ductEdgeType.ordinal());
        }
        if (!clientPacket) {
            CompoundTag edgeDataTag = new CompoundTag();
            Map $this$forEach$iv = this.edgeData;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry it = element$iv = iterator.next();
                boolean bl = false;
                edgeDataTag.m_128365_(this.objectMapper.writeValueAsString(it.getKey()), (Tag)it.getValue());
            }
            tag.m_128365_("edgeData", (Tag)edgeDataTag);
        }
        super.write(tag, clientPacket);
    }

    public void destroy() {
        if (this.f_58857_ != null) {
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            if (!level.f_46443_) {
                DuctNetworkServer ductNetworkServer = ClockworkMod.getKelvin();
                BlockPos blockPos = this.m_58899_();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
                Level level2 = this.f_58857_;
                Intrinsics.checkNotNull((Object)level2);
                ResourceLocation resourceLocation = level2.m_46472_().m_135782_();
                Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
                ductNetworkServer.removeNode(KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation));
            }
        }
        super.destroy();
    }

    @Override
    @NotNull
    public DuctNodePos getDuctNodePosition() {
        if (this.f_58857_ != null) {
            BlockPos blockPos = this.m_58899_();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
            Level level = this.f_58857_;
            Intrinsics.checkNotNull((Object)level);
            ResourceLocation resourceLocation = level.m_46472_().m_135782_();
            Intrinsics.checkNotNullExpressionValue((Object)resourceLocation, (String)"location(...)");
            return KelvinExtensions.INSTANCE.toDuctNodePos(blockPos, resourceLocation);
        }
        BlockPos blockPos = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getBlockPos(...)");
        return KelvinExtensions.toDuctNodePos$default((KelvinExtensions)KelvinExtensions.INSTANCE, (BlockPos)blockPos, null, (int)1, null);
    }

    @NotNull
    public final DuctEdgeType cycleEdgeType(@NotNull Direction dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Level level = this.f_58857_;
        if (!(level != null ? !level.f_46443_ : false)) {
            return DuctEdgeType.NONE;
        }
        DuctEdgeType ductEdgeType = this.DIR_TO_CONNECTION_TYPE.get(dir);
        Intrinsics.checkNotNull((Object)((Object)ductEdgeType));
        DuctEdgeType currentType = ductEdgeType;
        if (currentType == DuctEdgeType.NONE) {
            return DuctEdgeType.NONE;
        }
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        BlockEntity blockEntity = level2.m_7702_(this.m_58899_().m_121945_(dir));
        INodeBlockEntity iNodeBlockEntity = blockEntity instanceof INodeBlockEntity ? (INodeBlockEntity)blockEntity : null;
        if (iNodeBlockEntity == null || (iNodeBlockEntity = iNodeBlockEntity.getDuctNodePosition()) == null) {
            return DuctEdgeType.NONE;
        }
        INodeBlockEntity otherDuctNodePos = iNodeBlockEntity;
        DuctEdgeType nextType = currentType.nextScrewdrivable();
        DuctBlockEntity.setEdgeType$default(this, dir, (DuctNodePos)otherDuctNodePos, nextType, false, false, false, 48, null);
        return nextType;
    }

    public final void setEdgeType(@NotNull Direction dir, @NotNull DuctNodePos otherDuctNodePos, @NotNull DuctEdgeType edgeType, boolean clientPacket, boolean silent, boolean forced) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)otherDuctNodePos, (String)"otherDuctNodePos");
        Intrinsics.checkNotNullParameter((Object)((Object)edgeType), (String)"edgeType");
        Level level = this.f_58857_;
        if (!(level != null ? !level.f_46443_ : false) && !clientPacket) {
            return;
        }
        DuctEdgeType ductEdgeType = this.DIR_TO_CONNECTION_TYPE.get(dir);
        Intrinsics.checkNotNull((Object)((Object)ductEdgeType));
        DuctEdgeType previousType = ductEdgeType;
        ((Map)this.DIR_TO_CONNECTION_TYPE).put(dir, edgeType);
        if (!clientPacket) {
            this.syncEdge(dir);
            if (previousType != edgeType && !silent || forced) {
                ClockworkMod.getKelvin().removeEdge(this.getDuctNodePosition(), otherDuctNodePos);
                if (edgeType != DuctEdgeType.NONE) {
                    DuctNodePos nodeA = null;
                    DuctNodePos nodeB = null;
                    if (edgeType.isOneWay()) {
                        if (DuctNetworkUtils.INSTANCE.magnitudeSqr(this.getDuctNodePosition()) > DuctNetworkUtils.INSTANCE.magnitudeSqr(otherDuctNodePos)) {
                            nodeA = this.getDuctNodePosition();
                            nodeB = otherDuctNodePos;
                        } else {
                            nodeA = otherDuctNodePos;
                            nodeB = this.getDuctNodePosition();
                        }
                    } else {
                        nodeA = this.getDuctNodePosition();
                        nodeB = otherDuctNodePos;
                    }
                    DuctEdge newEdge = DuctEdgeType.Companion.createEdgeType(nodeA, nodeB, edgeType);
                    if (this.edgeData.get(new EdgePos(nodeA, nodeB)) != null) {
                        CompoundTag compoundTag = this.edgeData.get(new EdgePos(nodeA, nodeB));
                        Intrinsics.checkNotNull((Object)compoundTag);
                        newEdge.deserialize(compoundTag);
                    }
                    ClockworkMod.getKelvin().addEdge(nodeA, nodeB, newEdge);
                }
            }
        }
    }

    public static /* synthetic */ void setEdgeType$default(DuctBlockEntity ductBlockEntity, Direction direction, DuctNodePos ductNodePos, DuctEdgeType ductEdgeType, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        if ((n & 0x20) != 0) {
            bl3 = false;
        }
        ductBlockEntity.setEdgeType(direction, ductNodePos, ductEdgeType, bl, bl2, bl3);
    }

    public final void clearEdgeType(@NotNull Direction dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Level level = this.f_58857_;
        if (!(level != null ? !level.f_46443_ : false)) {
            return;
        }
        ((Map)this.DIR_TO_CONNECTION_TYPE).put(dir, DuctEdgeType.NONE);
        this.syncEdge(dir);
    }

    private final void syncEdge(Direction direction) {
        Level level = this.f_58857_;
        if (!(level != null ? !level.f_46443_ : false)) {
            return;
        }
        DuctEdgeType ductEdgeType = this.DIR_TO_CONNECTION_TYPE.get(direction);
        Intrinsics.checkNotNull((Object)((Object)ductEdgeType));
        DuctEdgeType edgeType = ductEdgeType;
        Level level2 = this.f_58857_;
        Intrinsics.checkNotNull((Object)level2);
        BlockPos blockPos = this.m_58899_();
        BlockPos blockPos2 = this.m_58899_();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"getBlockPos(...)");
        ClockworkPackets.Companion.sendToNear(level2, blockPos, 64, new DuctEdgeSyncPacket(blockPos2, direction, edgeType));
    }

    @Nullable
    protected AABB createRenderBoundingBox() {
        return super.createRenderBoundingBox().m_82400_(0.0625);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J$\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0014\u001a\u0004\b\u0015\u0010\u0004R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0014\u001a\u0004\b\u0016\u0010\u0004\u00a8\u0006\u0019"}, d2={"Lorg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctBlockEntity$EdgePos;", "", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "component1", "()Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "component2", "first", "second", "copy", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;)Lorg/valkyrienskies/clockwork/content/logistics/gas/duct/DuctBlockEntity$EdgePos;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/valkyrienskies/kelvin/api/DuctNodePos;", "getFirst", "getSecond", "<init>", "(Lorg/valkyrienskies/kelvin/api/DuctNodePos;Lorg/valkyrienskies/kelvin/api/DuctNodePos;)V", "clockwork"})
    public static final class EdgePos {
        @NotNull
        private final DuctNodePos first;
        @NotNull
        private final DuctNodePos second;

        public EdgePos(@NotNull DuctNodePos first, @NotNull DuctNodePos second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            this.first = first;
            this.second = second;
        }

        @NotNull
        public final DuctNodePos getFirst() {
            return this.first;
        }

        @NotNull
        public final DuctNodePos getSecond() {
            return this.second;
        }

        @NotNull
        public final DuctNodePos component1() {
            return this.first;
        }

        @NotNull
        public final DuctNodePos component2() {
            return this.second;
        }

        @NotNull
        public final EdgePos copy(@NotNull DuctNodePos first, @NotNull DuctNodePos second) {
            Intrinsics.checkNotNullParameter((Object)first, (String)"first");
            Intrinsics.checkNotNullParameter((Object)second, (String)"second");
            return new EdgePos(first, second);
        }

        public static /* synthetic */ EdgePos copy$default(EdgePos edgePos, DuctNodePos ductNodePos, DuctNodePos ductNodePos2, int n, Object object) {
            if ((n & 1) != 0) {
                ductNodePos = edgePos.first;
            }
            if ((n & 2) != 0) {
                ductNodePos2 = edgePos.second;
            }
            return edgePos.copy(ductNodePos, ductNodePos2);
        }

        @NotNull
        public String toString() {
            return "EdgePos(first=" + this.first + ", second=" + this.second + ")";
        }

        public int hashCode() {
            int result = this.first.hashCode();
            result = result * 31 + this.second.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EdgePos)) {
                return false;
            }
            EdgePos edgePos = (EdgePos)other;
            if (!Intrinsics.areEqual((Object)this.first, (Object)edgePos.first)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.second, (Object)edgePos.second);
        }
    }
}

