/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.kinetics.resistor;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.RotationPropagator;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.transmission.SplitShaftBlockEntity;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.ticks.TickPriority;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.util.ClockworkConstants;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\f\u0010*\u001a\b\u0012\u0002\b\u0003\u0018\u00010)\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u0012\u0006\u0010 \u001a\u00020+\u00a2\u0006\u0004\b,\u0010-J\u000f\u0010\u0004\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000f\u0010\u0006\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0005J\u001f\u0010\u000b\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\r\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\r\u0010\fJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J%\u0010\u001e\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001d\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010!\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\"\u0010&\u001a\u00020\u00128\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b&\u0010!\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%\u00a8\u0006."}, d2={"Lorg/valkyrienskies/clockwork/content/kinetics/resistor/RedstoneResistorBlockEntity;", "Lcom/simibubi/create/content/kinetics/transmission/SplitShaftBlockEntity;", "Lcom/simibubi/create/api/equipment/goggles/IHaveGoggleInformation;", "", "tick", "()V", "detachKinetics", "Lnet/minecraft/nbt/CompoundTag;", "compound", "", "clientPacket", "write", "(Lnet/minecraft/nbt/CompoundTag;Z)V", "read", "Lnet/minecraft/world/level/Level;", "worldIn", "Lnet/minecraft/core/BlockPos;", "pos", "", "getPower", "(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)I", "Lnet/minecraft/core/Direction;", "face", "", "getRotationSpeedModifier", "(Lnet/minecraft/core/Direction;)F", "", "Lnet/minecraft/network/chat/Component;", "tooltip", "isPlayerSneaking", "addToGoggleTooltip", "(Ljava/util/List;Z)Z", "state", "I", "getState", "()I", "setState", "(I)V", "lastChange", "getLastChange", "setLastChange", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "type", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/world/level/block/entity/BlockEntityType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "clockwork"})
public class RedstoneResistorBlockEntity
extends SplitShaftBlockEntity
implements IHaveGoggleInformation {
    private int state;
    private int lastChange;

    public RedstoneResistorBlockEntity(@Nullable BlockEntityType<?> type, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(type, pos, state);
    }

    public final int getState() {
        return this.state;
    }

    public final void setState(int n) {
        this.state = n;
    }

    public final int getLastChange() {
        return this.lastChange;
    }

    public final void setLastChange(int n) {
        this.lastChange = n;
    }

    public void tick() {
        super.tick();
        this.lastChange = this.state;
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        BlockPos blockPos = this.f_58858_;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        this.state = this.getPower(level, blockPos);
        if (this.state != this.lastChange) {
            this.detachKinetics();
        }
    }

    public void detachKinetics() {
        RotationPropagator.handleRemoved((Level)this.f_58857_, (BlockPos)this.f_58858_, (KineticBlockEntity)((KineticBlockEntity)this));
        Level level = this.f_58857_;
        Intrinsics.checkNotNull((Object)level);
        level.m_186464_(this.f_58858_, this.m_58900_().m_60734_(), 0, TickPriority.EXTREMELY_HIGH);
    }

    public void write(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        compound.m_128405_(ClockworkConstants.Nbt.INSTANCE.getREDSTONE_LEVEL(), this.state);
        compound.m_128405_(ClockworkConstants.Nbt.INSTANCE.getCHANGE_TIMER(), this.lastChange);
        super.write(compound, clientPacket);
    }

    protected void read(@NotNull CompoundTag compound, boolean clientPacket) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        this.state = compound.m_128451_(ClockworkConstants.Nbt.INSTANCE.getREDSTONE_LEVEL());
        this.lastChange = compound.m_128451_(ClockworkConstants.Nbt.INSTANCE.getCHANGE_TIMER());
        super.read(compound, clientPacket);
    }

    private final int getPower(Level worldIn, BlockPos pos) {
        Direction direction;
        int power = 0;
        Iterator iterator = ArrayIteratorKt.iterator((Object[])Iterate.directions);
        while (iterator.hasNext()) {
            direction = (Direction)iterator.next();
            power = RangesKt.coerceAtLeast((int)worldIn.m_277185_(pos.m_121945_(direction), direction), (int)power);
        }
        iterator = ArrayIteratorKt.iterator((Object[])Iterate.directions);
        while (iterator.hasNext()) {
            direction = (Direction)iterator.next();
            power = RangesKt.coerceAtLeast((int)worldIn.m_277185_(pos.m_121945_(direction), Direction.UP), (int)power);
        }
        return power;
    }

    public float getRotationSpeedModifier(@NotNull Direction face) {
        Intrinsics.checkNotNullParameter((Object)face, (String)"face");
        if (this.hasSource() && face != this.getSourceFacing()) {
            double i = (double)Math.abs(this.state - 15) / 15.0;
            i = Math.rint(i * 10.0) / 10.0;
            return (float)i;
        }
        return 1.0f;
    }

    public boolean addToGoggleTooltip(@NotNull List<Component> tooltip, boolean isPlayerSneaking) {
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Object[] objectArray = new Object[]{this.state};
        MutableComponent mutableComponent = CreateLang.translateDirect((String)"tooltip.analogStrength", (Object[])objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"translateDirect(...)");
        tooltip.add((Component)mutableComponent);
        return true;
    }
}

