/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.tools.gravitron;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.CreativeGravitronItem;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronState;
import org.valkyrienskies.clockwork.mixinduck.MixinPlayerDuck;
import org.valkyrienskies.clockwork.util.EaseHelper;
import org.valkyrienskies.mod.api.ValkyrienSkies;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0011\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b$\u0010\u001aJO\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J/\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u0019\u001a\u00020\u0011H\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\"\u0010!\u001a\u00020\u00148\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b!\u0010\u001c\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 \u00a8\u0006%"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronItemRenderer;", "Lcom/simibubi/create/foundation/item/render/CustomRenderedItemModelRenderer;", "Lnet/minecraft/world/item/ItemStack;", "stack", "Lcom/simibubi/create/foundation/item/render/CustomRenderedItemModel;", "model", "Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;", "renderer", "Lnet/minecraft/world/item/ItemDisplayContext;", "transformType", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "render", "(Lnet/minecraft/world/item/ItemStack;Lcom/simibubi/create/foundation/item/render/CustomRenderedItemModel;Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;Lnet/minecraft/world/item/ItemDisplayContext;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "", "angle", "matrices", "renderDial", "(FLcom/mojang/blaze3d/vertex/PoseStack;Lcom/simibubi/create/foundation/item/render/PartialItemModelRenderer;I)V", "renderProngs", "()V", "tempAngle", "F", "getTempAngle", "()F", "setTempAngle", "(F)V", "overloadAngle", "getOverloadAngle", "setOverloadAngle", "<init>", "clockwork"})
public class GravitronItemRenderer
extends CustomRenderedItemModelRenderer {
    private float tempAngle;
    private float overloadAngle;

    public final float getTempAngle() {
        return this.tempAngle;
    }

    public final void setTempAngle(float f) {
        this.tempAngle = f;
    }

    public final float getOverloadAngle() {
        return this.overloadAngle;
    }

    public final void setOverloadAngle(float f) {
        this.overloadAngle = f;
    }

    protected void render(@NotNull ItemStack stack, @NotNull CustomRenderedItemModel model, @NotNull PartialItemModelRenderer renderer, @NotNull ItemDisplayContext transformType, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)transformType, (String)"transformType");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ValkyrienSkies.api();
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        Intrinsics.checkNotNull((Object)localPlayer);
        LocalPlayer player = localPlayer;
        float partialTicks = AnimationTickHolder.getPartialTicks();
        float prevAngle = GravitronState.Companion.getPrevDialAngle((Player)player);
        float angle = GravitronState.Companion.getDialAngle((Player)player);
        boolean needsRefresh = GravitronState.Companion.getNeedRefresh((Player)player);
        if (needsRefresh) {
            this.tempAngle = 0.0f;
            MixinPlayerDuck duckPlayer = (MixinPlayerDuck)player;
            duckPlayer.setNeedsRefresh(false);
        }
        float targetAngle = (angle - prevAngle) * 1.0f % 360.0f + prevAngle;
        if (this.tempAngle < 1.0f) {
            this.tempAngle = Math.min(1.0f, this.tempAngle + partialTicks / 32.0f);
            float amount = EaseHelper.INSTANCE.easeOutOvershoot(this.tempAngle);
            targetAngle = (angle - prevAngle) * amount % 360.0f + prevAngle;
        }
        if ((targetAngle %= 360.0f) >= 270.0f) {
            ms.m_252880_((float)Math.sin(partialTicks / 2.0f) / 32.0f, (float)Math.cos(partialTicks / 2.0f + 7.0f) / 64.0f, 0.0f);
        }
        renderer.renderSolid(model.getOriginalModel(), light);
        this.renderDial(targetAngle, ms, renderer, light);
        renderer.render(ClockworkPartials.INSTANCE.getGRAV_PRONG_TOP_ONE().get(), light);
        renderer.render(ClockworkPartials.INSTANCE.getGRAV_PRONG_TOP_TWO().get(), light);
        renderer.render(ClockworkPartials.INSTANCE.getGRAV_PRONG_TOP_THREE().get(), light);
        renderer.render(ClockworkPartials.INSTANCE.getGRAV_PRONG_LEFT_ONE().get(), light);
        renderer.render(ClockworkPartials.INSTANCE.getGRAV_PRONG_LEFT_TWO().get(), light);
        renderer.render(ClockworkPartials.INSTANCE.getGRAV_PRONG_LEFT_THREE().get(), light);
        renderer.render(ClockworkPartials.INSTANCE.getGRAV_PRONG_RIGHT_ONE().get(), light);
        renderer.render(ClockworkPartials.INSTANCE.getGRAV_PRONG_RIGHT_TWO().get(), light);
        renderer.render(ClockworkPartials.INSTANCE.getGRAV_PRONG_RIGHT_THREE().get(), light);
        if (stack.m_41720_() instanceof CreativeGravitronItem) {
            this.overloadAngle = (this.overloadAngle + 1.0f * partialTicks) % 360.0f;
            ms.m_85836_();
            ms.m_85837_(0.0, -0.1, 0.0);
            ms.m_252781_(new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)this.overloadAngle), 0.0f, 0.0f, 1.0f)));
            ms.m_85837_(0.5, 0.5, 0.0);
            renderer.render(ClockworkPartials.INSTANCE.getOVERLOAD_FX().get(), light);
            ms.m_85849_();
        }
    }

    private final void renderDial(float angle, PoseStack matrices, PartialItemModelRenderer renderer, int light) {
        matrices.m_85836_();
        matrices.m_252781_(new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)22.5), -1.0f, 0.0f, 0.0f)));
        matrices.m_85837_(0.275, 0.2275, -0.115);
        matrices.m_85836_();
        double x = -0.49375;
        double y = -0.45625;
        double z = -1.375;
        matrices.m_85837_(x, y, y);
        matrices.m_252781_(new Quaternionf(new AxisAngle4f(AngleHelper.rad((double)((double)angle - 180.0 + 10.0)), 0.0f, 0.0f, -1.0f)));
        matrices.m_85837_(-x, -y, -z);
        matrices.m_85836_();
        renderer.render(ClockworkPartials.INSTANCE.getGRAV_DIAL_HAND().get(), light);
        matrices.m_85849_();
        matrices.m_85849_();
        matrices.m_85849_();
    }

    protected final void renderProngs() {
    }
}

