/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.tools.gravitron;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllKeys;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.clockwork.ClockworkItems;
import org.valkyrienskies.clockwork.ClockworkSounds;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.CreativeGravitronItem;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronItem;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.GravitronSelectionScreen;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.tool.IGravitronTool;
import org.valkyrienskies.clockwork.content.curiosities.tools.gravitron.tool.ToolType;
import org.valkyrienskies.clockwork.util.ClockworkHotbarSlotOverlays;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\bM\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J-\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0015\u001a\u00020\u00022\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u001d\u0010\u001f\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001f\u0010 J\u0015\u0010#\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020!\u00a2\u0006\u0004\b#\u0010$J\r\u0010%\u001a\u00020\u0002\u00a2\u0006\u0004\b%\u0010\u0004R$\u0010'\u001a\u0004\u0018\u00010&8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\"\u0010-\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010.\u001a\u0004\b/\u00100\"\u0004\b1\u00102R$\u00103\u001a\u0004\u0018\u00010\u00138\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b3\u00104\u001a\u0004\b5\u00106\"\u0004\b7\u0010\u0016R\"\u00108\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R$\u0010>\u001a\u0004\u0018\u00010\u00178\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b>\u0010?\u001a\u0004\b@\u0010A\"\u0004\bB\u0010CR$\u0010E\u001a\u0004\u0018\u00010D8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR\"\u0010K\u001a\u00020\u00108\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bK\u0010.\u001a\u0004\bK\u00100\"\u0004\bL\u00102\u00a8\u0006N"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronHandler;", "", "", "tick", "()V", "Lnet/minecraft/client/gui/GuiGraphics;", "poseStack", "", "partialTicks", "", "width", "height", "render", "(Lnet/minecraft/client/gui/GuiGraphics;FII)V", "Lnet/minecraft/world/entity/player/Player;", "player", "", "itemLost", "(Lnet/minecraft/world/entity/player/Player;)Z", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/tool/ToolType;", "tool", "equip", "(Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/tool/ToolType;)V", "Lnet/minecraft/world/item/ItemStack;", "findGravitronInHand", "(Lnet/minecraft/world/entity/player/Player;)Lnet/minecraft/world/item/ItemStack;", "button", "pressed", "onMouseInput", "(IZ)Z", "key", "onKeyInput", "(IZ)V", "", "delta", "mouseScrolled", "(D)Z", "init", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronSelectionScreen;", "selectionScreen", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronSelectionScreen;", "getSelectionScreen", "()Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronSelectionScreen;", "setSelectionScreen", "(Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/GravitronSelectionScreen;)V", "active", "Z", "getActive", "()Z", "setActive", "(Z)V", "currentTool", "Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/tool/ToolType;", "getCurrentTool", "()Lorg/valkyrienskies/clockwork/content/curiosities/tools/gravitron/tool/ToolType;", "setCurrentTool", "activeHotbarSlot", "I", "getActiveHotbarSlot", "()I", "setActiveHotbarSlot", "(I)V", "activeSchematicItem", "Lnet/minecraft/world/item/ItemStack;", "getActiveSchematicItem", "()Lnet/minecraft/world/item/ItemStack;", "setActiveSchematicItem", "(Lnet/minecraft/world/item/ItemStack;)V", "Lorg/valkyrienskies/clockwork/util/ClockworkHotbarSlotOverlays;", "overlay", "Lorg/valkyrienskies/clockwork/util/ClockworkHotbarSlotOverlays;", "getOverlay", "()Lorg/valkyrienskies/clockwork/util/ClockworkHotbarSlotOverlays;", "setOverlay", "(Lorg/valkyrienskies/clockwork/util/ClockworkHotbarSlotOverlays;)V", "isRegular", "setRegular", "<init>", "clockwork"})
public class GravitronHandler {
    @Nullable
    private GravitronSelectionScreen selectionScreen;
    private boolean active;
    @Nullable
    private ToolType currentTool;
    private int activeHotbarSlot;
    @Nullable
    private ItemStack activeSchematicItem;
    @Nullable
    private ClockworkHotbarSlotOverlays overlay = new ClockworkHotbarSlotOverlays();
    private boolean isRegular = true;

    public GravitronHandler() {
        this.currentTool = ToolType.GRAB;
        this.selectionScreen = new GravitronSelectionScreen(ToolType.Companion.getTools(), arg_0 -> GravitronHandler._init_$lambda$0(this, arg_0));
    }

    @Nullable
    public final GravitronSelectionScreen getSelectionScreen() {
        return this.selectionScreen;
    }

    public final void setSelectionScreen(@Nullable GravitronSelectionScreen gravitronSelectionScreen) {
        this.selectionScreen = gravitronSelectionScreen;
    }

    public final boolean getActive() {
        return this.active;
    }

    public final void setActive(boolean bl) {
        this.active = bl;
    }

    @Nullable
    public final ToolType getCurrentTool() {
        return this.currentTool;
    }

    public final void setCurrentTool(@Nullable ToolType toolType) {
        this.currentTool = toolType;
    }

    public final int getActiveHotbarSlot() {
        return this.activeHotbarSlot;
    }

    public final void setActiveHotbarSlot(int n) {
        this.activeHotbarSlot = n;
    }

    @Nullable
    public final ItemStack getActiveSchematicItem() {
        return this.activeSchematicItem;
    }

    public final void setActiveSchematicItem(@Nullable ItemStack itemStack) {
        this.activeSchematicItem = itemStack;
    }

    @Nullable
    public final ClockworkHotbarSlotOverlays getOverlay() {
        return this.overlay;
    }

    public final void setOverlay(@Nullable ClockworkHotbarSlotOverlays clockworkHotbarSlotOverlays) {
        this.overlay = clockworkHotbarSlotOverlays;
    }

    public final boolean isRegular() {
        return this.isRegular;
    }

    public final void setRegular(boolean bl) {
        this.isRegular = bl;
    }

    public final void tick() {
        LocalPlayer player;
        ItemStack stack;
        Minecraft mc = Minecraft.m_91087_();
        boolean wasActive = this.active;
        if (mc.f_91072_ != null) {
            MultiPlayerGameMode multiPlayerGameMode = mc.f_91072_;
            Intrinsics.checkNotNull((Object)multiPlayerGameMode);
            if (multiPlayerGameMode.m_105295_() == GameType.SPECTATOR) {
                if (this.active) {
                    this.active = false;
                    this.activeHotbarSlot = 0;
                    this.activeSchematicItem = null;
                }
                return;
            }
        }
        if ((stack = this.findGravitronInHand((Player)(player = mc.f_91074_))) == null) {
            this.active = false;
            if (wasActive) {
                LocalPlayer localPlayer = player;
                Level it = localPlayer != null ? localPlayer.m_9236_() : null;
                boolean bl = false;
                Level level = it;
                if (level != null) {
                    LocalPlayer localPlayer2 = player;
                    Intrinsics.checkNotNull((Object)localPlayer2);
                    Player player2 = (Player)localPlayer2;
                    BlockPos blockPos = player.m_20183_();
                    SoundEvent soundEvent = ClockworkSounds.INSTANCE.getGRAVITRON_SHUTDOWN().getMainEvent();
                    Intrinsics.checkNotNull((Object)soundEvent);
                    level.m_5594_(player2, blockPos, soundEvent, player.m_5720_(), 0.5f, 1.0f);
                }
            }
            if (this.activeSchematicItem != null) {
                LocalPlayer localPlayer = player;
                Intrinsics.checkNotNull((Object)localPlayer);
                if (this.itemLost((Player)localPlayer)) {
                    this.activeHotbarSlot = 0;
                    this.activeSchematicItem = null;
                }
            }
            return;
        }
        this.active = true;
        if (!wasActive) {
            LocalPlayer localPlayer = player;
            Level it = localPlayer != null ? localPlayer.m_9236_() : null;
            boolean bl = false;
            Level level = it;
            if (level != null) {
                LocalPlayer localPlayer3 = player;
                Intrinsics.checkNotNull((Object)localPlayer3);
                Player player3 = (Player)localPlayer3;
                BlockPos blockPos = player.m_20183_();
                SoundEvent soundEvent = ClockworkSounds.INSTANCE.getGRAVITRON_START().getMainEvent();
                Intrinsics.checkNotNull((Object)soundEvent);
                level.m_5594_(player3, blockPos, soundEvent, player.m_5720_(), 0.3f, 1.0f);
            }
        }
        if (!this.active) {
            return;
        }
        GravitronSelectionScreen gravitronSelectionScreen = this.selectionScreen;
        Intrinsics.checkNotNull((Object)((Object)gravitronSelectionScreen));
        gravitronSelectionScreen.update();
        if (this.isRegular && this.currentTool != ToolType.GRAB) {
            this.equip(ToolType.GRAB);
        }
    }

    public final void render(@NotNull GuiGraphics poseStack, float partialTicks, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)poseStack, (String)"poseStack");
        if (Minecraft.m_91087_().f_91066_.f_92062_ || !this.active) {
            return;
        }
        if (this.activeSchematicItem != null && this.isRegular) {
            ClockworkHotbarSlotOverlays clockworkHotbarSlotOverlays = this.overlay;
            Intrinsics.checkNotNull((Object)clockworkHotbarSlotOverlays);
            clockworkHotbarSlotOverlays.renderBrass(poseStack, this.activeHotbarSlot);
        } else if (this.activeSchematicItem != null) {
            ClockworkHotbarSlotOverlays clockworkHotbarSlotOverlays = this.overlay;
            Intrinsics.checkNotNull((Object)clockworkHotbarSlotOverlays);
            clockworkHotbarSlotOverlays.renderWanderlite(poseStack, this.activeHotbarSlot, partialTicks);
        }
        if (this.isRegular) {
            return;
        }
        ToolType toolType = this.currentTool;
        Intrinsics.checkNotNull((Object)((Object)toolType));
        IGravitronTool iGravitronTool = toolType.getTool();
        PoseStack poseStack2 = poseStack.m_280168_();
        Intrinsics.checkNotNullExpressionValue((Object)poseStack2, (String)"pose(...)");
        iGravitronTool.renderOverlay(poseStack2, partialTicks, width, height);
        GravitronSelectionScreen gravitronSelectionScreen = this.selectionScreen;
        Intrinsics.checkNotNull((Object)((Object)gravitronSelectionScreen));
        gravitronSelectionScreen.renderPassive(poseStack, partialTicks);
    }

    private final boolean itemLost(Player player) {
        int n = Inventory.m_36059_();
        for (int i = 0; i < n; ++i) {
            boolean bl = player.m_150109_().m_8020_(i).m_150930_(((GravitronItem)((Object)ClockworkItems.GRAVITRON.get())).m_5456_());
            boolean bl2 = player.m_150109_().m_8020_(i).m_150930_(((CreativeGravitronItem)((Object)ClockworkItems.CREATIVE_GRAVITRON.get())).m_5456_());
            if (!bl && !bl2) continue;
            return false;
        }
        return true;
    }

    public final void equip(@Nullable ToolType tool) {
        ToolType toolType = this.currentTool = tool;
        Intrinsics.checkNotNull((Object)((Object)toolType));
        toolType.getTool().init();
    }

    private final ItemStack findGravitronInHand(Player player) {
        Player player2 = player;
        Intrinsics.checkNotNull((Object)player2);
        ItemStack stack = player2.m_21205_();
        if (!ClockworkItems.GRAVITRON.isIn(stack) && !ClockworkItems.CREATIVE_GRAVITRON.isIn(stack)) {
            return null;
        }
        this.isRegular = ClockworkItems.GRAVITRON.isIn(stack);
        this.activeSchematicItem = stack;
        this.activeHotbarSlot = player.m_150109_().f_35977_;
        return stack;
    }

    public final boolean onMouseInput(int button, boolean pressed) {
        if (!this.active) {
            return false;
        }
        if (!pressed) {
            return false;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer localPlayer = mc.f_91074_;
        Intrinsics.checkNotNull((Object)localPlayer);
        if (localPlayer.m_6144_()) {
            return false;
        }
        if (button == 1) {
            ToolType toolType = this.currentTool;
            Intrinsics.checkNotNull((Object)((Object)toolType));
            return toolType.getTool().handleRightClick(this.isRegular);
        }
        if (button == 0) {
            ToolType toolType = this.currentTool;
            Intrinsics.checkNotNull((Object)((Object)toolType));
            return toolType.getTool().handleLeftClick(this.isRegular);
        }
        return false;
    }

    public final void onKeyInput(int key, boolean pressed) {
        if (!this.active) {
            return;
        }
        if (!AllKeys.TOOL_MENU.doesModifierAndCodeMatch(key)) {
            return;
        }
        if (pressed) {
            GravitronSelectionScreen gravitronSelectionScreen = this.selectionScreen;
            Intrinsics.checkNotNull((Object)((Object)gravitronSelectionScreen));
            if (!gravitronSelectionScreen.getFocus()) {
                GravitronSelectionScreen gravitronSelectionScreen2 = this.selectionScreen;
                Intrinsics.checkNotNull((Object)((Object)gravitronSelectionScreen2));
                gravitronSelectionScreen2.setFocus(true);
            }
        }
        if (!pressed) {
            GravitronSelectionScreen gravitronSelectionScreen = this.selectionScreen;
            Intrinsics.checkNotNull((Object)((Object)gravitronSelectionScreen));
            if (gravitronSelectionScreen.getFocus()) {
                GravitronSelectionScreen gravitronSelectionScreen3 = this.selectionScreen;
                Intrinsics.checkNotNull((Object)((Object)gravitronSelectionScreen3));
                gravitronSelectionScreen3.setFocus(false);
                GravitronSelectionScreen gravitronSelectionScreen4 = this.selectionScreen;
                Intrinsics.checkNotNull((Object)((Object)gravitronSelectionScreen4));
                gravitronSelectionScreen4.m_7379_();
            }
        }
    }

    public final boolean mouseScrolled(double delta) {
        if (!this.active) {
            return false;
        }
        if (this.isRegular) {
            return false;
        }
        GravitronSelectionScreen gravitronSelectionScreen = this.selectionScreen;
        Intrinsics.checkNotNull((Object)((Object)gravitronSelectionScreen));
        if (gravitronSelectionScreen.getFocus()) {
            GravitronSelectionScreen gravitronSelectionScreen2 = this.selectionScreen;
            Intrinsics.checkNotNull((Object)((Object)gravitronSelectionScreen2));
            gravitronSelectionScreen2.cycle((int)delta);
            return true;
        }
        if (AllKeys.ctrlDown()) {
            ToolType toolType = this.currentTool;
            Intrinsics.checkNotNull((Object)((Object)toolType));
            return toolType.getTool().handleMouseWheel(delta);
        }
        return false;
    }

    public final void init() {
    }

    private static final void _init_$lambda$0(GravitronHandler this$0, ToolType tool) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.equip(tool);
    }
}

