/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.sensor.rotation;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.belt.BeltHelper;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.AxisAngle4f;
import org.joml.Quaternionf;
import org.valkyrienskies.clockwork.content.curiosities.sensor.rotation.LodefocusBlockEntity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0011\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJO\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001d"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/sensor/rotation/LodefocusRenderer;", "Lcom/simibubi/create/foundation/blockEntity/renderer/SmartBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/curiosities/sensor/rotation/LodefocusBlockEntity;", "blockEntity", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/curiosities/sensor/rotation/LodefocusBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/minecraft/world/item/ItemStack;", "itemStack", "angle", "Lnet/minecraft/util/RandomSource;", "r", "Lnet/minecraft/world/phys/Vec3;", "itemPosition", "renderItem", "(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;IILnet/minecraft/world/item/ItemStack;ILnet/minecraft/util/RandomSource;Lnet/minecraft/world/phys/Vec3;)V", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class LodefocusRenderer
extends SmartBlockEntityRenderer<LodefocusBlockEntity> {
    public LodefocusRenderer(@Nullable BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(@NotNull LodefocusBlockEntity blockEntity, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.renderSafe((SmartBlockEntity)blockEntity, partialTicks, ms, buffer, light, overlay);
        if (((ItemStack)blockEntity.getInventory().get(0)).m_41619_() || blockEntity.m_58904_() == null) {
            return;
        }
        ms.m_85836_();
        Vec3 itemPosition = VecHelper.getCenterOf((Vec3i)((Vec3i)blockEntity.m_58899_()));
        Object object = blockEntity.getInventory().get(0);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        ItemStack stack = (ItemStack)object;
        Level level = blockEntity.m_58904_();
        Intrinsics.checkNotNull((Object)level);
        RandomSource randomSource = level.f_46441_;
        Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
        Intrinsics.checkNotNull((Object)itemPosition);
        this.renderItem(ms, buffer, light, overlay, stack, 90, randomSource, itemPosition);
        ms.m_85849_();
    }

    public final void renderItem(@NotNull PoseStack ms, @Nullable MultiBufferSource buffer, int light, int overlay, @NotNull ItemStack itemStack, int angle, @NotNull RandomSource r, @NotNull Vec3 itemPosition) {
        int i;
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Intrinsics.checkNotNullParameter((Object)itemPosition, (String)"itemPosition");
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        PoseTransformStack msr = TransformStack.of((PoseStack)ms);
        int count = Mth.m_14173_((int)itemStack.m_41613_()) / 2;
        boolean renderUpright = BeltHelper.isItemUpright((ItemStack)itemStack) || itemStack.m_150930_(Items.f_42522_);
        BakedModel bakedModel = itemRenderer.m_174264_(itemStack, null, null, 0);
        boolean blockItem = bakedModel.m_7539_();
        ms.m_85836_();
        msr.rotateYDegrees((float)angle);
        if (renderUpright) {
            Entity renderViewEntity = Minecraft.m_91087_().f_91075_;
            if (renderViewEntity != null) {
                Vec3 positionVec = renderViewEntity.m_20182_();
                Vec3 vectorForOffset = itemPosition;
                Vec3 diff = vectorForOffset.m_82546_(positionVec);
                float yRot = (float)(Mth.m_14136_((double)diff.f_82479_, (double)diff.f_82481_) + Math.PI);
                ms.m_252781_(new Quaternionf(new AxisAngle4f(yRot, 0.0f, 1.0f, 0.0f)));
            }
            ms.m_85837_(0.0, 0.09375, -0.0625);
        }
        if ((i = 0) <= count) {
            while (true) {
                ms.m_85836_();
                if (blockItem) {
                    ms.m_85837_((double)(r.m_188501_() * 0.0625f * (float)i), 0.0, (double)(r.m_188501_() * 0.0625f * (float)i));
                }
                ms.m_85841_(0.5f, 0.5f, 0.5f);
                itemRenderer.m_115143_(itemStack, ItemDisplayContext.FIXED, false, ms, buffer, light, overlay, bakedModel);
                ms.m_85849_();
                if (!renderUpright) {
                    if (!blockItem) {
                        msr.rotateYDegrees(10.0f);
                    }
                    ms.m_85837_(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                } else {
                    ms.m_85837_(0.0, 0.0, -0.0625);
                }
                if (i == count) break;
                ++i;
            }
        }
        ms.m_85849_();
    }
}

