/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.meteor;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.IntRange;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkBlocks;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b%\u0010&J5\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\f\u0010\rJr\u0010\u0017\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u0007\u001a\u00020\u00062K\u0010\u0016\u001aG\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u000b0\u0010H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J)\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u00192\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001f\u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ%\u0010\u001f\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u00068\u0006X\u0086D\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/meteor/MeteorGenerator;", "", "Lnet/minecraft/server/level/ServerLevel;", "level", "Lnet/minecraft/core/BlockPos;", "center", "", "threshold", "", "maxDistance", "metaBallsCount", "", "generate", "(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;DII)V", "", "balls", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "x", "y", "z", "func", "iterate", "(Ljava/util/List;DLkotlin/jvm/functions/Function3;)V", "Lkotlin/Pair;", "largestAndSmallest", "(Ljava/util/List;)Lkotlin/Pair;", "pos", "randomizedPos", "(Lnet/minecraft/core/BlockPos;I)Lnet/minecraft/core/BlockPos;", "metaBall", "(Ljava/util/List;Lnet/minecraft/core/BlockPos;)D", "resolution", "D", "getResolution", "()D", "<init>", "()V", "clockwork"})
@SourceDebugExtension(value={"SMAP\nMeteorGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MeteorGenerator.kt\norg/valkyrienskies/clockwork/content/curiosities/meteor/MeteorGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1863#2,2:95\n*S KotlinDebug\n*F\n+ 1 MeteorGenerator.kt\norg/valkyrienskies/clockwork/content/curiosities/meteor/MeteorGenerator\n*L\n67#1:95,2\n*E\n"})
public final class MeteorGenerator {
    @NotNull
    public static final MeteorGenerator INSTANCE = new MeteorGenerator();
    private static final double resolution = 0.25;

    private MeteorGenerator() {
    }

    public final double getResolution() {
        return resolution;
    }

    public final void generate(@NotNull ServerLevel level, @NotNull BlockPos center, double threshold, int maxDistance, int metaBallsCount) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)center, (String)"center");
        Object[] objectArray = new Integer[]{1, 1};
        PerlinNoise noise = PerlinNoise.m_230529_((RandomSource)((RandomSource)new SingleThreadedRandomSource(level.m_7328_())), (List)CollectionsKt.mutableListOf((Object[])objectArray));
        List balls = new ArrayList();
        balls.add(center);
        int i = 2;
        if (i <= metaBallsCount) {
            while (true) {
                balls.add(this.randomizedPos(center, maxDistance));
                if (i == metaBallsCount) break;
                ++i;
            }
        }
        this.iterate(balls, threshold, (Function3<? super Integer, ? super Integer, ? super Integer, Unit>)((Function3)(arg_0, arg_1, arg_2) -> MeteorGenerator.generate$lambda$0(threshold, noise, balls, level, arg_0, arg_1, arg_2)));
    }

    private final void iterate(List<? extends BlockPos> balls, double threshold, Function3<? super Integer, ? super Integer, ? super Integer, Unit> func) {
        int n;
        Pair<BlockPos, BlockPos> res = this.largestAndSmallest(balls);
        BlockPos smallest = (BlockPos)res.getFirst();
        BlockPos largest = (BlockPos)res.getSecond();
        int x = smallest.m_123341_() - (int)(0.5 / threshold);
        if (x <= (n = largest.m_123341_() + (int)(0.5 / threshold))) {
            while (true) {
                int n2;
                int y;
                if ((y = smallest.m_123342_() - (int)(0.5 / threshold)) <= (n2 = largest.m_123342_() + (int)(0.5 / threshold))) {
                    while (true) {
                        int n3;
                        int z;
                        if ((z = smallest.m_123343_() - (int)(0.5 / threshold)) <= (n3 = largest.m_123343_() + (int)(0.5 / threshold))) {
                            while (true) {
                                func.invoke((Object)x, (Object)y, (Object)z);
                                if (z == n3) break;
                                ++z;
                            }
                        }
                        if (y == n2) break;
                        ++y;
                    }
                }
                if (x == n) break;
                ++x;
            }
        }
    }

    private final Pair<BlockPos, BlockPos> largestAndSmallest(List<? extends BlockPos> balls) {
        BlockPos smallest = null;
        smallest = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        BlockPos largest = null;
        largest = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        Iterable $this$forEach$iv = balls;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            if (it.m_123341_() > largest.m_123341_()) {
                largest = new BlockPos(it.m_123341_(), largest.m_123342_(), largest.m_123343_());
            }
            if (it.m_123341_() < smallest.m_123341_()) {
                smallest = new BlockPos(it.m_123341_(), smallest.m_123342_(), smallest.m_123343_());
            }
            if (it.m_123342_() > largest.m_123342_()) {
                largest = new BlockPos(largest.m_123341_(), it.m_123342_(), largest.m_123343_());
            }
            if (it.m_123342_() < smallest.m_123342_()) {
                smallest = new BlockPos(smallest.m_123341_(), it.m_123342_(), smallest.m_123343_());
            }
            if (it.m_123343_() > largest.m_123343_()) {
                largest = new BlockPos(largest.m_123341_(), largest.m_123342_(), it.m_123343_());
            }
            if (it.m_123343_() >= smallest.m_123343_()) continue;
            smallest = new BlockPos(smallest.m_123341_(), smallest.m_123342_(), it.m_123343_());
        }
        return new Pair((Object)smallest, (Object)largest);
    }

    private final BlockPos randomizedPos(BlockPos pos, int maxDistance) {
        BlockPos blockPos = pos.m_7918_(RandomKt.nextInt((Random)((Random)Random.Default), (IntRange)new IntRange(-maxDistance, maxDistance)), RandomKt.nextInt((Random)((Random)Random.Default), (IntRange)new IntRange(-maxDistance, maxDistance)), RandomKt.nextInt((Random)((Random)Random.Default), (IntRange)new IntRange(-maxDistance, maxDistance)));
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"offset(...)");
        return blockPos;
    }

    private final double metaBall(List<? extends BlockPos> balls, BlockPos pos) {
        double sigma = 0.0;
        for (BlockPos blockPos : balls) {
            sigma += 1.0 / blockPos.m_123331_((Vec3i)pos);
        }
        return sigma;
    }

    private static final Unit generate$lambda$0(double $threshold, PerlinNoise $noise, List $balls, ServerLevel $level, int x, int y, int z) {
        Intrinsics.checkNotNullParameter((Object)$balls, (String)"$balls");
        Intrinsics.checkNotNullParameter((Object)$level, (String)"$level");
        double t = $threshold - $noise.m_75408_((double)x * resolution, (double)y * resolution, (double)z * resolution) / (double)500;
        double mb = INSTANCE.metaBall($balls, new BlockPos(x, y, z));
        BlockState state = null;
        state = mb > t ? ClockworkBlocks.NYX.getDefaultState() : Blocks.f_50016_.m_49966_();
        $level.m_46865_(new BlockPos(x, y, z)).m_6978_(new BlockPos(x, y, z), state, false);
        return Unit.INSTANCE;
    }
}

