/*
 * Decompiled with CFR 0.152.
 */
package org.valkyrienskies.clockwork.content.curiosities.clock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.clockwork.ClockworkPartials;
import org.valkyrienskies.clockwork.content.curiosities.clock.ClockBlockEntity;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b%\u0010&J?\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\nH\u0014\u00a2\u0006\u0004\b\u000e\u0010\u000fJ'\u0010\u0014\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0012H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\"\u0010\u0017\u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\"\u0010\u001d\u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u0018\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001cR\"\u0010 \u001a\u00020\u00168\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b \u0010\u0018\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001c\u00a8\u0006'"}, d2={"Lorg/valkyrienskies/clockwork/content/curiosities/clock/ClockRenderer;", "Lcom/simibubi/create/foundation/blockEntity/renderer/SmartBlockEntityRenderer;", "Lorg/valkyrienskies/clockwork/content/curiosities/clock/ClockBlockEntity;", "blockEntity", "", "partialTicks", "Lcom/mojang/blaze3d/vertex/PoseStack;", "ms", "Lnet/minecraft/client/renderer/MultiBufferSource;", "buffer", "", "light", "overlay", "", "renderSafe", "(Lorg/valkyrienskies/clockwork/content/curiosities/clock/ClockBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V", "Lnet/createmod/catnip/render/SuperByteBuffer;", "angle", "Lnet/minecraft/core/Direction;", "facing", "rotateHand", "(Lnet/createmod/catnip/render/SuperByteBuffer;FLnet/minecraft/core/Direction;)Lnet/createmod/catnip/render/SuperByteBuffer;", "", "currentSecondHandRotation", "D", "getCurrentSecondHandRotation", "()D", "setCurrentSecondHandRotation", "(D)V", "currentMinuteHandRotation", "getCurrentMinuteHandRotation", "setCurrentMinuteHandRotation", "currentHourHandRotation", "getCurrentHourHandRotation", "setCurrentHourHandRotation", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;", "context", "<init>", "(Lnet/minecraft/client/renderer/blockentity/BlockEntityRendererProvider$Context;)V", "clockwork"})
public final class ClockRenderer
extends SmartBlockEntityRenderer<ClockBlockEntity> {
    private double currentSecondHandRotation;
    private double currentMinuteHandRotation;
    private double currentHourHandRotation;

    public ClockRenderer(@NotNull BlockEntityRendererProvider.Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
    }

    public final double getCurrentSecondHandRotation() {
        return this.currentSecondHandRotation;
    }

    public final void setCurrentSecondHandRotation(double d) {
        this.currentSecondHandRotation = d;
    }

    public final double getCurrentMinuteHandRotation() {
        return this.currentMinuteHandRotation;
    }

    public final void setCurrentMinuteHandRotation(double d) {
        this.currentMinuteHandRotation = d;
    }

    public final double getCurrentHourHandRotation() {
        return this.currentHourHandRotation;
    }

    public final void setCurrentHourHandRotation(double d) {
        this.currentHourHandRotation = d;
    }

    protected void renderSafe(@NotNull ClockBlockEntity blockEntity, float partialTicks, @NotNull PoseStack ms, @NotNull MultiBufferSource buffer, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)((Object)blockEntity), (String)"blockEntity");
        Intrinsics.checkNotNullParameter((Object)ms, (String)"ms");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        super.renderSafe((SmartBlockEntity)blockEntity, partialTicks, ms, buffer, light, overlay);
        if (blockEntity.m_58904_() == null) {
            return;
        }
        blockEntity.calcHandRotation(blockEntity.getDoingTrailerAnim());
        if (blockEntity.getDoingTrailerAnim() && blockEntity.getTrailerAnimProgress() < 1.0) {
            blockEntity.setTrailerAnimProgress(blockEntity.getTrailerAnimProgress() + 0.01);
        }
        float secondHandRotation = AngleHelper.rad((double)AngleHelper.angleLerp((double)partialTicks, (double)AngleHelper.deg((double)this.currentSecondHandRotation), (double)AngleHelper.deg((double)blockEntity.getSecondHandTargetRotation())));
        float minuteHandRotation = AngleHelper.rad((double)AngleHelper.angleLerp((double)partialTicks, (double)AngleHelper.deg((double)this.currentMinuteHandRotation), (double)AngleHelper.deg((double)blockEntity.getMinuteHandTargetRotation())));
        float hourHandRotation = AngleHelper.rad((double)AngleHelper.angleLerp((double)partialTicks, (double)AngleHelper.deg((double)this.currentHourHandRotation), (double)AngleHelper.deg((double)blockEntity.getHourHandTargetRotation())));
        SuperByteBuffer clockRing = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getCLOCK_FRAME(), (BlockState)blockEntity.m_58900_());
        SuperByteBuffer secondHand = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getHAND_SECOND(), (BlockState)blockEntity.m_58900_());
        SuperByteBuffer minuteHand = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getHAND_MINUTE(), (BlockState)blockEntity.m_58900_());
        SuperByteBuffer hourHand = CachedBuffers.partial((PartialModel)ClockworkPartials.INSTANCE.getHAND_HOUR(), (BlockState)blockEntity.m_58900_());
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110451_());
        Direction facing = (Direction)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        ms.m_85836_();
        clockRing.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())), Direction.UP);
        clockRing.translate(0.5, 0.0, 0.5);
        clockRing.light(light).overlay(overlay).renderInto(ms, vb);
        ms.m_85849_();
        ms.m_85836_();
        Intrinsics.checkNotNull((Object)secondHand);
        Intrinsics.checkNotNull((Object)facing);
        this.rotateHand(secondHand, secondHandRotation, facing).light(light).overlay(overlay).renderInto(ms, vb);
        Intrinsics.checkNotNull((Object)minuteHand);
        this.rotateHand(minuteHand, minuteHandRotation, facing).light(light).overlay(overlay).renderInto(ms, vb);
        Intrinsics.checkNotNull((Object)hourHand);
        this.rotateHand(hourHand, hourHandRotation, facing).light(light).overlay(overlay).renderInto(ms, vb);
        ms.m_85849_();
        this.currentSecondHandRotation = secondHandRotation;
        this.currentMinuteHandRotation = minuteHandRotation;
        this.currentHourHandRotation = hourHandRotation;
    }

    private final SuperByteBuffer rotateHand(SuperByteBuffer buffer, float angle, Direction facing) {
        float pivotX = 0.5f;
        float pivotY = 0.5f;
        float pivotZ = 0.875f;
        buffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing.m_122424_())), Direction.UP);
        buffer.translate((double)pivotX, (double)pivotY, (double)pivotZ);
        buffer.rotate(angle, Direction.SOUTH);
        buffer.translate(-((double)pivotX), -((double)pivotY), -((double)pivotZ));
        return buffer;
    }
}

